/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.management.persistence.ExchangeData;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public PersistInInterceptor() {
        super("receive");
    }

    private void getSoapRequest(Message soapMessage, ExchangeData exchange) {
        InputStream is = soapMessage.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                IOUtils.copy(is, bos);
                bos.flush();
                is.close();
                soapMessage.setContent(InputStream.class, bos.getInputStream());
                StringBuilder builder = new StringBuilder();
                bos.writeCacheTo(builder, bos.size());
                bos.close();
                exchange.setRequest(builder.toString());
                exchange.setRequestSize((int)bos.size());
            }
            catch (IOException e) {
                throw new Fault(e);
            }
        }
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        ExchangeData soapExchange = new ExchangeData();
        soapExchange.setInDate(new Date());
        message.setContent(ExchangeData.class, soapExchange);
        this.getSoapRequest(message, soapExchange);
    }
}

