/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSamlPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.ClaimsPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.DefaultClaimsPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedTokenPolicyValidator
extends AbstractSamlPolicyValidator {
    private List<WSSecurityEngineResult> signedResults;
    private Message message;
    private ClaimsPolicyValidator claimsValidator = new DefaultClaimsPolicyValidator();

    public IssuedTokenPolicyValidator(List<WSSecurityEngineResult> signedResults, Message message) {
        this.signedResults = signedResults;
        this.message = message;
    }

    public boolean validatePolicy(Collection<AssertionInfo> ais, AssertionWrapper assertionWrapper) {
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        for (AssertionInfo ai : ais) {
            IssuedToken issuedToken = (IssuedToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired(issuedToken, this.message)) continue;
            if (assertionWrapper == null) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                return false;
            }
            Element template = issuedToken.getRstTemplate();
            if (template != null && !this.checkIssuedTokenTemplate(template, assertionWrapper)) {
                ai.setNotAsserted("Error in validating the IssuedToken policy");
                return false;
            }
            TLSSessionInfo tlsInfo = this.message.get(TLSSessionInfo.class);
            Certificate[] tlsCerts = null;
            if (tlsInfo != null) {
                tlsCerts = tlsInfo.getPeerCertificates();
            }
            if (this.checkHolderOfKey(assertionWrapper, this.signedResults, tlsCerts)) continue;
            ai.setNotAsserted("Assertion fails holder-of-key requirements");
            return false;
        }
        return true;
    }

    public boolean validatePolicy(Collection<AssertionInfo> ais, BinarySecurity binarySecurityToken) {
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        for (AssertionInfo ai : ais) {
            IssuedToken issuedToken = (IssuedToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired(issuedToken, this.message)) continue;
            if (binarySecurityToken == null) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                return false;
            }
            Element template = issuedToken.getRstTemplate();
            if (template == null || this.checkIssuedTokenTemplate(template, binarySecurityToken)) continue;
            ai.setNotAsserted("Error in validating the IssuedToken policy");
            return false;
        }
        return true;
    }

    private boolean checkIssuedTokenTemplate(Element template, AssertionWrapper assertionWrapper) {
        Element child = DOMUtils.getFirstElement(template);
        while (child != null) {
            String content;
            if ("TokenType".equals(child.getLocalName())) {
                content = child.getTextContent();
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(content) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
                    return false;
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(content) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_20) {
                    return false;
                }
            } else if ("KeyType".equals(child.getLocalName())) {
                SAMLKeyInfo subjectKeyInfo;
                content = child.getTextContent();
                if (content.endsWith("SymmetricKey") ? (subjectKeyInfo = assertionWrapper.getSubjectKeyInfo()) == null || subjectKeyInfo.getSecret() == null : content.endsWith("PublicKey") && ((subjectKeyInfo = assertionWrapper.getSubjectKeyInfo()) == null || subjectKeyInfo.getPublicKey() == null && subjectKeyInfo.getCerts() == null)) {
                    return false;
                }
            } else if ("Claims".equals(child.getLocalName())) {
                String dialect = child.getAttributeNS(null, "Dialect");
                if (this.claimsValidator.getDialect().equals(dialect) && !this.claimsValidator.validatePolicy(child, assertionWrapper)) {
                    return false;
                }
            }
            child = DOMUtils.getNextElement(child);
        }
        return true;
    }

    private boolean checkIssuedTokenTemplate(Element template, BinarySecurity binarySecurityToken) {
        Element child = DOMUtils.getFirstElement(template);
        while (child != null) {
            String valueType;
            String content;
            if ("TokenType".equals(child.getLocalName()) && !(content = child.getTextContent()).equals(valueType = binarySecurityToken.getValueType())) {
                return false;
            }
            child = DOMUtils.getNextElement(child);
        }
        return true;
    }
}

