/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.osgi;

import fr.dyade.aaa.common.Debug;
import java.util.HashMap;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminItf;
import org.objectweb.joram.client.osgi.AdminStruct;
import org.objectweb.joram.client.osgi.AdminWrapperTracker;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class AdminWrapperHelper {
    public static final Logger logmon = Debug.getLogger((String)AdminWrapperHelper.class.getName());
    private static HashMap<AdminStruct, AdminWrapperTracker> wrapperTrackers = new HashMap();

    public static AdminItf getWrapper(BundleContext bundleContext, AdminStruct adminStruct) throws AdminException {
        AdminWrapperTracker wrapperTracker;
        if (adminStruct == null) {
            throw new AdminException("The admin struct is null.");
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("getWrapper(" + adminStruct.wrapperName + ", " + adminStruct.adminHost + ", " + adminStruct.adminPort + ", " + adminStruct.adminUser + ')'));
        }
        if ((wrapperTracker = wrapperTrackers.get(adminStruct)) == null) {
            try {
                wrapperTracker = new AdminWrapperTracker(bundleContext, adminStruct.wrapperName, adminStruct.adminHost, adminStruct.adminPort, adminStruct.adminUser);
            }
            catch (InvalidSyntaxException e) {
                if (logmon.isLoggable(BasicLevel.WARN)) {
                    logmon.log(BasicLevel.WARN, (Object)"getWrapper ", (Throwable)e);
                }
                throw new AdminException("EXCEPTION:: getWrapper: " + e.getMessage());
            }
            wrapperTrackers.put(adminStruct, wrapperTracker);
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("getWrapper wrapperTrackers = " + wrapperTrackers));
            }
        }
        try {
            return wrapperTracker.getAdminWrapper();
        }
        catch (Exception e) {
            wrapperTrackers.remove(adminStruct);
            if (logmon.isLoggable(BasicLevel.WARN)) {
                logmon.log(BasicLevel.WARN, (Object)"getWrapper ", (Throwable)e);
            }
            throw new AdminException("The admin wrapper tracker not available.");
        }
    }

    public void removeWrapperTracker(AdminStruct adminStruct) {
        AdminWrapperTracker wrapperTracker = wrapperTrackers.remove(adminStruct);
        if (wrapperTracker != null) {
            wrapperTracker.close();
        }
    }
}

