/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.Strings;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DumpAttributes {
    public static Logger logger = Debug.getLogger(DumpAttributes.class.getName());

    static void addRecord(StringBuffer strbuf, String mbean, String att, Object value) {
        strbuf.append(mbean).append(':').append(att).append('=');
        Strings.toString(strbuf, value);
        strbuf.append('\n');
    }

    public static void dumpAttributes(String name, String path) {
        FileWriter writer = null;
        try {
            Set<String> mBeans = null;
            try {
                mBeans = MXWrapper.queryNames(name);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)("DumpAttributes.dumpAttributes, bad name: " + name), (Throwable)exc);
                return;
            }
            if (mBeans != null) {
                writer = new FileWriter(path, true);
                StringBuffer strbuf = new StringBuffer();
                for (String mBean : mBeans) {
                    try {
                        List<String> attributes = MXWrapper.getAttributeNames(mBean);
                        if (attributes != null) {
                            for (int i = 0; i < attributes.size(); ++i) {
                                String attname = attributes.get(i);
                                try {
                                    DumpAttributes.addRecord(strbuf, mBean, attname, MXWrapper.getAttribute(mBean, attname));
                                    continue;
                                }
                                catch (Exception exc) {
                                    logger.log(BasicLevel.ERROR, (Object)("DumpAttributes.dumpAttributes, bad attribute : " + mBean + ":" + attname), (Throwable)exc);
                                }
                            }
                        }
                        writer.write(strbuf.toString());
                        strbuf.setLength(0);
                    }
                    catch (Exception exc) {
                        logger.log(BasicLevel.ERROR, (Object)"DumpAttributes.dumpAttributes", (Throwable)exc);
                    }
                }
                writer.close();
            }
        }
        catch (IOException exc) {
            logger.log(BasicLevel.ERROR, (Object)("FileMonitoringTimerTask.<init>, cannot open file \"" + path + "\""), (Throwable)exc);
        }
    }
}

