/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.Encoder;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.PhoneticFilter;
import org.apache.solr.core.SolrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneticFilterFactory
extends BaseTokenFilterFactory {
    public static final String ENCODER = "encoder";
    public static final String INJECT = "inject";
    private static final Map<String, Class<? extends Encoder>> registry = new HashMap<String, Class<? extends Encoder>>();
    protected boolean inject = true;
    protected String name = null;
    protected Encoder encoder = null;

    @Override
    public void init(Map<String, String> args) {
        String name;
        super.init(args);
        if (args.get(INJECT) != null) {
            this.inject = Boolean.getBoolean(args.get(INJECT));
        }
        if ((name = args.get(ENCODER)) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter: encoder [" + registry.keySet() + "]");
        }
        Class<? extends Encoder> clazz = registry.get(name.toUpperCase());
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown encoder: " + name + " [" + registry.keySet() + "]");
        }
        try {
            this.encoder = clazz.newInstance();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing: " + name + "/" + clazz, (Throwable)e);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new PhoneticFilter(input, this.encoder, this.name, this.inject);
    }

    static {
        registry.put("DoubleMetaphone".toUpperCase(), DoubleMetaphone.class);
        registry.put("Metaphone".toUpperCase(), Metaphone.class);
        registry.put("Soundex".toUpperCase(), Soundex.class);
        registry.put("RefinedSoundex".toUpperCase(), RefinedSoundex.class);
    }
}

