/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.HashMap;
import javax.persistence.QueryHint;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.annotations.ResultsetMappingSecondPass;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, QueryBinder.class.getName());

    public static void bindQuery(javax.persistence.NamedQuery queryAnn, Mappings mappings, boolean isDefault) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        QueryHint[] hints = queryAnn.hints();
        String queryName = queryAnn.query();
        NamedQueryDefinition query = new NamedQueryDefinition(queryAnn.name(), queryName, QueryBinder.getBoolean(queryName, "org.hibernate.cacheable", hints), QueryBinder.getString(queryName, "org.hibernate.cacheRegion", hints), QueryBinder.getTimeout(queryName, hints), QueryBinder.getInteger(queryName, "org.hibernate.fetchSize", hints), QueryBinder.getFlushMode(queryName, hints), QueryBinder.getCacheMode(queryName, hints), QueryBinder.getBoolean(queryName, "org.hibernate.readOnly", hints), QueryBinder.getString(queryName, "org.hibernate.comment", hints), null);
        if (isDefault) {
            mappings.addDefaultQuery(query.getName(), query);
        } else {
            mappings.addQuery(query.getName(), query);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", (Object)query.getName(), (Object)query.getQueryString());
        }
    }

    public static void bindNativeQuery(javax.persistence.NamedNativeQuery queryAnn, Mappings mappings, boolean isDefault) {
        NamedSQLQueryDefinition query;
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String resultSetMapping = queryAnn.resultSetMapping();
        QueryHint[] hints = queryAnn.hints();
        String queryName = queryAnn.query();
        if (!BinderHelper.isEmptyAnnotationValue(resultSetMapping)) {
            query = new NamedSQLQueryDefinition(queryAnn.name(), queryName, resultSetMapping, null, QueryBinder.getBoolean(queryName, "org.hibernate.cacheable", hints), QueryBinder.getString(queryName, "org.hibernate.cacheRegion", hints), QueryBinder.getTimeout(queryName, hints), QueryBinder.getInteger(queryName, "org.hibernate.fetchSize", hints), QueryBinder.getFlushMode(queryName, hints), QueryBinder.getCacheMode(queryName, hints), QueryBinder.getBoolean(queryName, "org.hibernate.readOnly", hints), QueryBinder.getString(queryName, "org.hibernate.comment", hints), null, QueryBinder.getBoolean(queryName, "org.hibernate.callable", hints));
        } else if (!Void.TYPE.equals(queryAnn.resultClass())) {
            NativeSQLQueryRootReturn entityQueryReturn = new NativeSQLQueryRootReturn("alias1", queryAnn.resultClass().getName(), new HashMap<String, String[]>(), LockMode.READ);
            query = new NamedSQLQueryDefinition(queryAnn.name(), queryName, new NativeSQLQueryReturn[]{entityQueryReturn}, null, QueryBinder.getBoolean(queryName, "org.hibernate.cacheable", hints), QueryBinder.getString(queryName, "org.hibernate.cacheRegion", hints), QueryBinder.getTimeout(queryName, hints), QueryBinder.getInteger(queryName, "org.hibernate.fetchSize", hints), QueryBinder.getFlushMode(queryName, hints), QueryBinder.getCacheMode(queryName, hints), QueryBinder.getBoolean(queryName, "org.hibernate.readOnly", hints), QueryBinder.getString(queryName, "org.hibernate.comment", hints), null, QueryBinder.getBoolean(queryName, "org.hibernate.callable", hints));
        } else {
            throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
        }
        if (isDefault) {
            mappings.addDefaultSQLQuery(query.getName(), query);
        } else {
            mappings.addSQLQuery(query.getName(), query);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", (Object)queryAnn.name(), (Object)queryAnn.query());
        }
    }

    public static void bindNativeQuery(NamedNativeQuery queryAnn, Mappings mappings) {
        NamedSQLQueryDefinition query;
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String resultSetMapping = queryAnn.resultSetMapping();
        if (!BinderHelper.isEmptyAnnotationValue(resultSetMapping)) {
            query = new NamedSQLQueryDefinition(queryAnn.name(), queryAnn.query(), resultSetMapping, null, queryAnn.cacheable(), BinderHelper.isEmptyAnnotationValue(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion(), queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()), queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()), QueryBinder.getFlushMode(queryAnn.flushMode()), QueryBinder.getCacheMode(queryAnn.cacheMode()), queryAnn.readOnly(), BinderHelper.isEmptyAnnotationValue(queryAnn.comment()) ? null : queryAnn.comment(), null, queryAnn.callable());
        } else if (!Void.TYPE.equals(queryAnn.resultClass())) {
            NativeSQLQueryRootReturn entityQueryReturn = new NativeSQLQueryRootReturn("alias1", queryAnn.resultClass().getName(), new HashMap<String, String[]>(), LockMode.READ);
            query = new NamedSQLQueryDefinition(queryAnn.name(), queryAnn.query(), new NativeSQLQueryReturn[]{entityQueryReturn}, null, queryAnn.cacheable(), BinderHelper.isEmptyAnnotationValue(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion(), queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()), queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()), QueryBinder.getFlushMode(queryAnn.flushMode()), QueryBinder.getCacheMode(queryAnn.cacheMode()), queryAnn.readOnly(), BinderHelper.isEmptyAnnotationValue(queryAnn.comment()) ? null : queryAnn.comment(), null, queryAnn.callable());
        } else {
            throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
        }
        mappings.addSQLQuery(query.getName(), query);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", (Object)query.getName(), (Object)queryAnn.query());
        }
    }

    public static void bindQueries(javax.persistence.NamedQueries queriesAnn, Mappings mappings, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (javax.persistence.NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, mappings, isDefault);
        }
    }

    public static void bindNativeQueries(javax.persistence.NamedNativeQueries queriesAnn, Mappings mappings, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (javax.persistence.NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, mappings, isDefault);
        }
    }

    public static void bindNativeQueries(NamedNativeQueries queriesAnn, Mappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, mappings);
        }
    }

    public static void bindQuery(NamedQuery queryAnn, Mappings mappings) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        FlushMode flushMode = QueryBinder.getFlushMode(queryAnn.flushMode());
        NamedQueryDefinition query = new NamedQueryDefinition(queryAnn.name(), queryAnn.query(), queryAnn.cacheable(), BinderHelper.isEmptyAnnotationValue(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion(), queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()), queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()), flushMode, QueryBinder.getCacheMode(queryAnn.cacheMode()), queryAnn.readOnly(), BinderHelper.isEmptyAnnotationValue(queryAnn.comment()) ? null : queryAnn.comment(), null);
        mappings.addQuery(query.getName(), query);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", (Object)query.getName(), (Object)query.getQueryString());
        }
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        FlushMode flushMode;
        switch (flushModeType) {
            case ALWAYS: {
                flushMode = FlushMode.ALWAYS;
                break;
            }
            case AUTO: {
                flushMode = FlushMode.AUTO;
                break;
            }
            case COMMIT: {
                flushMode = FlushMode.COMMIT;
                break;
            }
            case NEVER: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case MANUAL: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                flushMode = null;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown flushModeType: " + (Object)((Object)flushModeType));
            }
        }
        return flushMode;
    }

    private static CacheMode getCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + (Object)((Object)cacheModeType));
    }

    public static void bindQueries(NamedQueries queriesAnn, Mappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, mappings);
        }
    }

    public static void bindSqlResultsetMappings(SqlResultSetMappings ann, Mappings mappings, boolean isDefault) {
        if (ann == null) {
            return;
        }
        for (SqlResultSetMapping rs : ann.value()) {
            mappings.addSecondPass(new ResultsetMappingSecondPass(rs, mappings, true));
        }
    }

    public static void bindSqlResultsetMapping(SqlResultSetMapping ann, Mappings mappings, boolean isDefault) {
        mappings.addSecondPass(new ResultsetMappingSecondPass(ann, mappings, isDefault));
    }

    private static CacheMode getCacheMode(String query, QueryHint[] hints) {
        for (QueryHint hint : hints) {
            if (!"org.hibernate.cacheMode".equals(hint.name())) continue;
            if (hint.value().equalsIgnoreCase(CacheMode.GET.toString())) {
                return CacheMode.GET;
            }
            if (hint.value().equalsIgnoreCase(CacheMode.IGNORE.toString())) {
                return CacheMode.IGNORE;
            }
            if (hint.value().equalsIgnoreCase(CacheMode.NORMAL.toString())) {
                return CacheMode.NORMAL;
            }
            if (hint.value().equalsIgnoreCase(CacheMode.PUT.toString())) {
                return CacheMode.PUT;
            }
            if (hint.value().equalsIgnoreCase(CacheMode.REFRESH.toString())) {
                return CacheMode.REFRESH;
            }
            throw new AnnotationException("Unknown CacheMode in hint: " + query + ":" + hint.name());
        }
        return null;
    }

    private static FlushMode getFlushMode(String query, QueryHint[] hints) {
        for (QueryHint hint : hints) {
            if (!"org.hibernate.flushMode".equals(hint.name())) continue;
            if (hint.value().equalsIgnoreCase(FlushMode.ALWAYS.toString())) {
                return FlushMode.ALWAYS;
            }
            if (hint.value().equalsIgnoreCase(FlushMode.AUTO.toString())) {
                return FlushMode.AUTO;
            }
            if (hint.value().equalsIgnoreCase(FlushMode.COMMIT.toString())) {
                return FlushMode.COMMIT;
            }
            if (hint.value().equalsIgnoreCase(FlushMode.NEVER.toString())) {
                return FlushMode.MANUAL;
            }
            if (hint.value().equalsIgnoreCase(FlushMode.MANUAL.toString())) {
                return FlushMode.MANUAL;
            }
            throw new AnnotationException("Unknown FlushMode in hint: " + query + ":" + hint.name());
        }
        return null;
    }

    private static boolean getBoolean(String query, String hintName, QueryHint[] hints) {
        for (QueryHint hint : hints) {
            if (!hintName.equals(hint.name())) continue;
            if (hint.value().equalsIgnoreCase("true")) {
                return true;
            }
            if (hint.value().equalsIgnoreCase("false")) {
                return false;
            }
            throw new AnnotationException("Not a boolean in hint: " + query + ":" + hint.name());
        }
        return false;
    }

    private static String getString(String query, String hintName, QueryHint[] hints) {
        for (QueryHint hint : hints) {
            if (!hintName.equals(hint.name())) continue;
            return hint.value();
        }
        return null;
    }

    private static Integer getInteger(String query, String hintName, QueryHint[] hints) {
        for (QueryHint hint : hints) {
            if (!hintName.equals(hint.name())) continue;
            try {
                return Integer.decode(hint.value());
            }
            catch (NumberFormatException nfe) {
                throw new AnnotationException("Not an integer in hint: " + query + ":" + hint.name(), nfe);
            }
        }
        return null;
    }

    private static Integer getTimeout(String queryName, QueryHint[] hints) {
        Integer timeout = QueryBinder.getInteger(queryName, "javax.persistence.query.timeout", hints);
        timeout = timeout != null ? new Integer((int)Math.round(timeout.doubleValue() / 1000.0)) : QueryBinder.getInteger(queryName, "org.hibernate.timeout", hints);
        return timeout;
    }
}

