/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.cache.spi.NaturalIdCacheKey;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class NaturalIdXrefDelegate {
    private static final Logger LOG = Logger.getLogger(NaturalIdXrefDelegate.class);
    private final StatefulPersistenceContext persistenceContext;
    private final Map<EntityPersister, NaturalIdResolutionCache> naturalIdResolutionCacheMap = new ConcurrentHashMap<EntityPersister, NaturalIdResolutionCache>();

    public NaturalIdXrefDelegate(StatefulPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    protected SessionImplementor session() {
        return this.persistenceContext.getSession();
    }

    public void cacheNaturalIdResolution(EntityPersister persister, final Serializable pk, Object[] naturalIdValues, CachedNaturalIdValueSource valueSource) {
        this.validateNaturalId(persister, naturalIdValues);
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(persister);
        if (entityNaturalIdResolutionCache == null) {
            entityNaturalIdResolutionCache = new NaturalIdResolutionCache(persister);
            this.naturalIdResolutionCacheMap.put(persister, entityNaturalIdResolutionCache);
        }
        final boolean justAddedToLocalCache = entityNaturalIdResolutionCache.cache(pk, naturalIdValues);
        if (persister.hasNaturalIdCache()) {
            final NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
            final NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(naturalIdValues, persister, this.session());
            final SessionFactoryImplementor factory = this.session().getFactory();
            switch (valueSource) {
                case LOAD: {
                    boolean put = naturalIdCacheAccessStrategy.putFromLoad(naturalIdCacheKey, pk, this.session().getTimestamp(), null);
                    if (!put || !justAddedToLocalCache || !factory.getStatistics().isStatisticsEnabled()) break;
                    factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                    break;
                }
                case INSERT: {
                    naturalIdCacheAccessStrategy.insert(naturalIdCacheKey, pk);
                    ((EventSource)this.session()).getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                        @Override
                        public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
                            boolean put = naturalIdCacheAccessStrategy.afterInsert(naturalIdCacheKey, pk);
                            if (put && justAddedToLocalCache && factory.getStatistics().isStatisticsEnabled()) {
                                factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                            }
                        }
                    });
                    break;
                }
                case UPDATE: {
                    final SoftLock lock = naturalIdCacheAccessStrategy.lockItem(naturalIdCacheKey, null);
                    naturalIdCacheAccessStrategy.update(naturalIdCacheKey, pk);
                    ((EventSource)this.session()).getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                        @Override
                        public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
                            boolean put = naturalIdCacheAccessStrategy.afterUpdate(naturalIdCacheKey, pk, lock);
                            if (put && justAddedToLocalCache && factory.getStatistics().isStatisticsEnabled()) {
                                factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                            }
                        }
                    });
                    break;
                }
            }
        }
    }

    protected void validateNaturalId(EntityPersister persister, Object[] naturalIdValues) {
        if (!persister.hasNaturalIdentifier()) {
            throw new IllegalArgumentException("Entity did not define a natrual-id");
        }
        if (persister.getNaturalIdentifierProperties().length != naturalIdValues.length) {
            throw new IllegalArgumentException("Mismatch between expected number of natural-id values and found.");
        }
    }

    public void evictNaturalIdResolution(EntityPersister persister, Serializable pk, Object[] deletedNaturalIdValues) {
        CachedNaturalId cachedNaturalId;
        this.validateNaturalId(persister, deletedNaturalIdValues);
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(persister);
        Object[] sessionCachedNaturalIdValues = null;
        if (entityNaturalIdResolutionCache != null && (cachedNaturalId = (CachedNaturalId)entityNaturalIdResolutionCache.pkToNaturalIdMap.remove(pk)) != null) {
            entityNaturalIdResolutionCache.naturalIdToPkMap.remove(cachedNaturalId);
            sessionCachedNaturalIdValues = cachedNaturalId.getValues();
        }
        if (persister.hasNaturalIdCache()) {
            NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
            NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(deletedNaturalIdValues, persister, this.session());
            naturalIdCacheAccessStrategy.evict(naturalIdCacheKey);
            if (sessionCachedNaturalIdValues != null && !Arrays.equals(sessionCachedNaturalIdValues, deletedNaturalIdValues)) {
                NaturalIdCacheKey sessionNaturalIdCacheKey = new NaturalIdCacheKey(sessionCachedNaturalIdValues, persister, this.session());
                naturalIdCacheAccessStrategy.evict(sessionNaturalIdCacheKey);
            }
        }
    }

    public Object[] findCachedNaturalId(EntityPersister persister, Serializable pk) {
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(persister);
        if (entityNaturalIdResolutionCache == null) {
            return null;
        }
        CachedNaturalId cachedNaturalId = (CachedNaturalId)entityNaturalIdResolutionCache.pkToNaturalIdMap.get(pk);
        if (cachedNaturalId == null) {
            return null;
        }
        return cachedNaturalId.getValues();
    }

    public Serializable findCachedNaturalIdResolution(EntityPersister persister, Object[] naturalIdValues) {
        Serializable pk;
        this.validateNaturalId(persister, naturalIdValues);
        NaturalIdResolutionCache entityNaturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(persister);
        CachedNaturalId cachedNaturalId = new CachedNaturalId(persister, naturalIdValues);
        if (entityNaturalIdResolutionCache != null && (pk = (Serializable)entityNaturalIdResolutionCache.naturalIdToPkMap.get(cachedNaturalId)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resolved natural key -> primary key resolution in session cache: " + persister.getRootEntityName() + "#[" + Arrays.toString(naturalIdValues) + "]");
            }
            return pk;
        }
        if (!persister.hasNaturalIdCache()) {
            return null;
        }
        NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(naturalIdValues, persister, this.session());
        NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
        pk = (Serializable)naturalIdCacheAccessStrategy.get(naturalIdCacheKey, this.session().getTimestamp());
        SessionFactoryImplementor factory = this.session().getFactory();
        if (pk != null) {
            if (factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatisticsImplementor().naturalIdCacheHit(naturalIdCacheAccessStrategy.getRegion().getName());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Found natural key [%s] -> primary key [%s] xref in second-level cache for %s", (Object)Arrays.toString(naturalIdValues), (Object)pk, (Object)persister.getRootEntityName());
            }
            if (entityNaturalIdResolutionCache == null) {
                entityNaturalIdResolutionCache = new NaturalIdResolutionCache(persister);
                this.naturalIdResolutionCacheMap.put(persister, entityNaturalIdResolutionCache);
            }
            entityNaturalIdResolutionCache.pkToNaturalIdMap.put(pk, cachedNaturalId);
            entityNaturalIdResolutionCache.naturalIdToPkMap.put(cachedNaturalId, pk);
        } else if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().naturalIdCacheMiss(naturalIdCacheAccessStrategy.getRegion().getName());
        }
        return pk;
    }

    private static class NaturalIdResolutionCache
    implements Serializable {
        private final EntityPersister persister;
        private final Type[] naturalIdTypes;
        private Map<Serializable, CachedNaturalId> pkToNaturalIdMap = new ConcurrentHashMap<Serializable, CachedNaturalId>();
        private Map<CachedNaturalId, Serializable> naturalIdToPkMap = new ConcurrentHashMap<CachedNaturalId, Serializable>();

        private NaturalIdResolutionCache(EntityPersister persister) {
            this.persister = persister;
            int[] naturalIdPropertyIndexes = persister.getNaturalIdentifierProperties();
            this.naturalIdTypes = new Type[naturalIdPropertyIndexes.length];
            int i = 0;
            for (int naturalIdPropertyIndex : naturalIdPropertyIndexes) {
                this.naturalIdTypes[i++] = persister.getPropertyType(persister.getPropertyNames()[naturalIdPropertyIndex]);
            }
        }

        public EntityPersister getPersister() {
            return this.persister;
        }

        public boolean cache(Serializable pk, Object[] naturalIdValues) {
            CachedNaturalId initial = this.pkToNaturalIdMap.get(pk);
            if (initial != null && this.areSame(naturalIdValues, initial.getValues())) {
                return false;
            }
            CachedNaturalId cachedNaturalId = new CachedNaturalId(this.persister, naturalIdValues);
            this.pkToNaturalIdMap.put(pk, cachedNaturalId);
            this.naturalIdToPkMap.put(cachedNaturalId, pk);
            return true;
        }

        private boolean areSame(Object[] naturalIdValues, Object[] values) {
            for (int i = 0; i < this.naturalIdTypes.length; ++i) {
                if (this.naturalIdTypes[i].compare(naturalIdValues[i], values[i]) == 0) continue;
                return false;
            }
            return true;
        }
    }

    private static class CachedNaturalId {
        private final EntityPersister persister;
        private final Object[] values;
        private int hashCode;

        public CachedNaturalId(EntityPersister persister, Object[] values) {
            this.persister = persister;
            this.values = values;
            int prime = 31;
            int result = 1;
            result = 31 * result + (persister == null ? 0 : persister.hashCode());
            this.hashCode = result = 31 * result + Arrays.hashCode(values);
        }

        public Object[] getValues() {
            return this.values;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedNaturalId other = (CachedNaturalId)obj;
            return this.persister.equals(other.persister) && Arrays.equals(this.values, other.values);
        }
    }
}

