/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.ObjectName;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

public class TableBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TableBinder.class.getName());

    private TableBinder() {
    }

    public static void bind(AnnotationBindingContext bindingContext) {
        List annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.TABLE);
        for (AnnotationInstance tableAnnotation : annotations) {
            TableBinder.bind(bindingContext.getMetadataImplementor(), tableAnnotation);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.TABLES);
        for (AnnotationInstance tables : annotations) {
            for (AnnotationInstance table : JandexHelper.getValue(tables, "value", AnnotationInstance[].class)) {
                TableBinder.bind(bindingContext.getMetadataImplementor(), table);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance tableAnnotation) {
        String tableName = JandexHelper.getValue(tableAnnotation, "appliesTo", String.class);
        ObjectName objectName = new ObjectName(tableName);
        Schema schema = metadata.getDatabase().getSchema(objectName.getSchema(), objectName.getCatalog());
        Table table = schema.locateTable(objectName.getName());
        if (table != null) {
            TableBinder.bindHibernateTableAnnotation(table, tableAnnotation);
        }
    }

    private static void bindHibernateTableAnnotation(Table table, AnnotationInstance tableAnnotation) {
        for (AnnotationInstance indexAnnotation : JandexHelper.getValue(tableAnnotation, "indexes", AnnotationInstance[].class)) {
            TableBinder.bindIndexAnnotation(table, indexAnnotation);
        }
        String comment = JandexHelper.getValue(tableAnnotation, "comment", String.class);
        if (StringHelper.isNotEmpty(comment)) {
            table.addComment(comment.trim());
        }
    }

    private static void bindIndexAnnotation(Table table, AnnotationInstance indexAnnotation) {
        String indexName = JandexHelper.getValue(indexAnnotation, "appliesTo", String.class);
        String[] columnNames = JandexHelper.getValue(indexAnnotation, "columnNames", String[].class);
        if (columnNames == null) {
            LOG.noColumnsSpecifiedForIndex(indexName, table.toLoggableString());
            return;
        }
        Index index = table.getOrCreateIndex(indexName);
        for (String columnName : columnNames) {
            Column column = TableBinder.findColumn(table, columnName);
            if (column == null) {
                throw new AnnotationException("@Index references a unknown column: " + columnName);
            }
            index.addColumn(column);
        }
    }

    private static Column findColumn(Table table, String columnName) {
        Column column = null;
        for (SimpleValue value : table.values()) {
            if (!(value instanceof Column) || !((Column)value).getColumnName().getName().equals(columnName)) continue;
            column = (Column)value;
            break;
        }
        return column;
    }
}

