/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractWorkspaceImpl
implements Workspace {
    private static final Log log = LoggerFactory.make();
    private final OptimizerStrategy optimizerStrategy;
    private final Set<Class<?>> entitiesInIndexManager;
    private final DirectoryBasedIndexManager indexManager;
    protected final IndexWriterHolder writerHolder;
    private final AtomicLong operations = new AtomicLong(0L);

    public AbstractWorkspaceImpl(DirectoryBasedIndexManager indexManager, ErrorHandler errorHandler) {
        this.indexManager = indexManager;
        this.optimizerStrategy = indexManager.getOptimizerStrategy();
        this.entitiesInIndexManager = indexManager.getContainedTypes();
        this.writerHolder = new IndexWriterHolder(errorHandler, indexManager);
    }

    @Override
    public <T> DocumentBuilderIndexedEntity<?> getDocumentBuilder(Class<T> entity) {
        return this.indexManager.getIndexBindingForEntity(entity).getDocumentBuilder();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.indexManager.getAnalyzer(name);
    }

    @Override
    public void optimizerPhase() {
        this.optimizerStrategy.addOperationWithinTransactionCount(this.operations.getAndSet(0L));
        this.optimizerStrategy.optimize(this);
    }

    @Override
    public void performOptimization(IndexWriter writer) {
        this.optimizerStrategy.performOptimization(writer);
    }

    @Override
    public void incrementModificationCounter(int modCount) {
        this.operations.addAndGet(modCount);
    }

    @Override
    public Set<Class<?>> getEntitiesInIndexManager() {
        return this.entitiesInIndexManager;
    }

    @Override
    public abstract void afterTransactionApplied(boolean var1);

    public void shutDownNow() {
        log.shuttingDownBackend(this.indexManager.getIndexName());
        this.writerHolder.closeIndexWriter();
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this.writerHolder.getIndexWriter();
    }

    public IndexWriter getIndexWriter(ErrorContextBuilder errorContextBuilder) {
        return this.writerHolder.getIndexWriter(errorContextBuilder);
    }
}

