/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericField;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;

public class LuceneOptionsImpl
implements LuceneOptions {
    private final boolean storeCompressed;
    private final boolean storeUncompressed;
    private final Field.Index indexMode;
    private final Field.TermVector termVector;
    private final Float boost;
    private final Store storeType;
    private final int precisionStep;
    private final String indexNullAs;

    public LuceneOptionsImpl(Store store, Field.Index indexMode, Field.TermVector termVector, Float boost) {
        this(store, indexMode, termVector, boost, null, 4);
    }

    public LuceneOptionsImpl(Store store, Field.Index indexMode, Field.TermVector termVector, Float boost, String indexNullAs, int precisionStep) {
        this.indexMode = indexMode;
        this.termVector = termVector;
        this.boost = boost;
        this.storeType = store;
        this.storeCompressed = store.equals((Object)Store.COMPRESS);
        this.storeUncompressed = store.equals((Object)Store.YES);
        this.indexNullAs = indexNullAs;
        this.precisionStep = precisionStep;
    }

    @Override
    public void addFieldToDocument(String name, String indexedString, Document document) {
        if (StringHelper.isNotEmpty(indexedString)) {
            if (!this.indexMode.equals((Object)Field.Index.NO) || !this.storeCompressed) {
                this.standardFieldAdd(name, indexedString, document);
            }
            if (this.storeCompressed) {
                this.compressedFieldAdd(name, indexedString, document);
            }
        }
    }

    @Override
    public void addNumericFieldToDocument(String fieldName, Object value, Document document) {
        if (this.storeType == Store.COMPRESS) {
            throw new SearchException("Error indexing field " + fieldName + ", @NumericField cannot be compressed");
        }
        if (value != null) {
            NumericField numericField = new NumericField(fieldName, this.precisionStep, this.storeType != Store.NO ? Field.Store.YES : Field.Store.NO, true);
            NumericFieldUtils.setNumericValue(value, numericField);
            if (this.boost != null) {
                numericField.setBoost(this.boost.floatValue());
            }
            if (numericField.getNumericValue() != null) {
                document.add(numericField);
            }
        }
    }

    private void standardFieldAdd(String name, String indexedString, Document document) {
        Field field = new Field(name, false, indexedString, this.storeUncompressed ? Field.Store.YES : Field.Store.NO, this.indexMode, this.termVector);
        if (this.boost != null) {
            field.setBoost(this.boost.floatValue());
        }
        document.add(field);
    }

    private void compressedFieldAdd(String name, String indexedString, Document document) {
        byte[] compressedString = CompressionTools.compressString(indexedString);
        Field field = new Field(name, compressedString);
        document.add(field);
    }

    @Override
    public Float getBoost() {
        if (this.boost != null) {
            return this.boost;
        }
        return Float.valueOf(1.0f);
    }

    @Override
    public String indexNullAs() {
        return this.indexNullAs;
    }

    @Override
    public boolean isCompressed() {
        return this.storeCompressed;
    }

    @Override
    public Field.Index getIndex() {
        return this.indexMode;
    }

    @Override
    public Field.Store getStore() {
        if (this.storeUncompressed || this.storeCompressed) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    @Override
    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    public Store getStoreStrategy() {
        return this.storeType;
    }
}

