/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.util.AttributeImpl;
import org.apache.solr.handler.AnalysisRequestHandlerBase;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.spi.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.spi.LuceneNumericFieldContext;
import org.hibernate.search.indexes.serialization.spi.Serializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AvroSerializer
implements Serializer {
    private static final Log log = LoggerFactory.make();
    private GenericRecord idRecord;
    private List<GenericRecord> fieldables;
    private List<GenericRecord> operations;
    private List<String> classReferences;
    private GenericRecord document;
    private final Protocol protocol;

    public AvroSerializer(Protocol protocol) {
        this.protocol = protocol;
        this.classReferences = new ArrayList<String>();
    }

    @Override
    public void luceneWorks(List<LuceneWork> works) {
        this.operations = new ArrayList<GenericRecord>(works.size());
    }

    @Override
    public void addOptimizeAll() {
        this.operations.add((GenericRecord)new GenericData.Record(this.protocol.getType("OptimizeAll")));
    }

    @Override
    public void addPurgeAll(String entityClassName) {
        int classRef = this.getClassReference(entityClassName);
        GenericData.Record purgeAll = new GenericData.Record(this.protocol.getType("PurgeAll"));
        purgeAll.put("class", (Object)classRef);
        this.operations.add((GenericRecord)purgeAll);
    }

    private int getClassReference(String entityClassName) {
        int classRef = this.classReferences.indexOf(entityClassName);
        if (classRef == -1) {
            this.classReferences.add(entityClassName);
            classRef = this.classReferences.size() - 1;
        }
        return classRef;
    }

    @Override
    public void addIdSerializedInJava(byte[] id) {
        this.idRecord = new GenericData.Record(this.protocol.getType("Id"));
        this.idRecord.put("value", (Object)ByteBuffer.wrap(id));
    }

    @Override
    public void addIdAsInteger(int id) {
        this.idRecord = new GenericData.Record(this.protocol.getType("Id"));
        this.idRecord.put("value", (Object)id);
    }

    @Override
    public void addIdAsLong(long id) {
        this.idRecord = new GenericData.Record(this.protocol.getType("Id"));
        this.idRecord.put("value", (Object)id);
    }

    @Override
    public void addIdAsFloat(float id) {
        this.idRecord = new GenericData.Record(this.protocol.getType("Id"));
        this.idRecord.put("value", (Object)Float.valueOf(id));
    }

    @Override
    public void addIdAsDouble(double id) {
        this.idRecord = new GenericData.Record(this.protocol.getType("Id"));
        this.idRecord.put("value", (Object)id);
    }

    @Override
    public void addIdAsString(String id) {
        this.idRecord = new GenericData.Record(this.protocol.getType("Id"));
        this.idRecord.put("value", (Object)id);
    }

    @Override
    public void addDelete(String entityClassName) {
        int classRef = this.getClassReference(entityClassName);
        GenericData.Record delete = new GenericData.Record(this.protocol.getType("Delete"));
        delete.put("class", (Object)classRef);
        delete.put("id", (Object)this.idRecord);
        this.operations.add((GenericRecord)delete);
        this.idRecord = null;
    }

    @Override
    public void addAdd(String entityClassName, Map<String, String> fieldToAnalyzerMap) {
        int classRef = this.getClassReference(entityClassName);
        GenericData.Record add = new GenericData.Record(this.protocol.getType("Add"));
        add.put("class", (Object)classRef);
        add.put("id", (Object)this.idRecord);
        add.put("document", (Object)this.document);
        add.put("fieldToAnalyzerMap", fieldToAnalyzerMap);
        this.operations.add((GenericRecord)add);
        this.idRecord = null;
        this.clearDocument();
    }

    @Override
    public void addUpdate(String entityClassName, Map<String, String> fieldToAnalyzerMap) {
        int classRef = this.getClassReference(entityClassName);
        GenericData.Record update = new GenericData.Record(this.protocol.getType("Update"));
        update.put("class", (Object)classRef);
        update.put("id", (Object)this.idRecord);
        update.put("document", (Object)this.document);
        update.put("fieldToAnalyzerMap", fieldToAnalyzerMap);
        this.operations.add((GenericRecord)update);
        this.idRecord = null;
        this.clearDocument();
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(AvroSerializationProvider.getMajorVersion());
        out.write(AvroSerializationProvider.getMinorVersion());
        Schema msgSchema = this.protocol.getType("Message");
        GenericDatumWriter writer = new GenericDatumWriter(msgSchema);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        GenericData.Record message = new GenericData.Record(msgSchema);
        message.put("classReferences", this.classReferences);
        message.put("operations", this.operations);
        this.operations = null;
        try {
            writer.write((Object)message, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw log.unableToSerializeInAvro(e);
        }
        return out.toByteArray();
    }

    @Override
    public void fields(List<Fieldable> fields) {
        this.fieldables = new ArrayList<GenericRecord>(fields.size());
    }

    @Override
    public void addIntNumericField(int value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericIntField", context);
        numericField.put("value", (Object)value);
        this.fieldables.add(numericField);
    }

    private GenericRecord createNumericfield(String schemaName, LuceneNumericFieldContext context) {
        GenericData.Record numericField = new GenericData.Record(this.protocol.getType(schemaName));
        numericField.put("name", (Object)context.getName());
        numericField.put("precisionStep", (Object)context.getPrecisionStep());
        numericField.put("store", (Object)context.getStore());
        numericField.put("indexed", (Object)context.isIndexed());
        numericField.put("boost", (Object)Float.valueOf(context.getBoost()));
        numericField.put("omitNorms", (Object)context.getOmitNorms());
        numericField.put("omitTermFreqAndPositions", (Object)context.getOmitTermFreqAndPositions());
        return numericField;
    }

    @Override
    public void addLongNumericField(long value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericLongField", context);
        numericField.put("value", (Object)value);
        this.fieldables.add(numericField);
    }

    @Override
    public void addFloatNumericField(float value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericFloatField", context);
        numericField.put("value", (Object)Float.valueOf(value));
        this.fieldables.add(numericField);
    }

    @Override
    public void addDoubleNumericField(double value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericDoubleField", context);
        numericField.put("value", (Object)value);
        this.fieldables.add(numericField);
    }

    @Override
    public void addFieldWithBinaryData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("BinaryField", context);
        field.put("offset", (Object)context.getBinaryOffset());
        field.put("length", (Object)context.getBinaryLength());
        field.put("value", (Object)ByteBuffer.wrap(context.getBinaryValue()));
        this.fieldables.add(field);
    }

    private GenericRecord createNormalField(String schemaName, LuceneFieldContext context) {
        GenericData.Record field = new GenericData.Record(this.protocol.getType(schemaName));
        field.put("name", (Object)context.getName());
        field.put("boost", (Object)Float.valueOf(context.getBoost()));
        field.put("omitNorms", (Object)context.isOmitNorms());
        field.put("omitTermFreqAndPositions", (Object)context.isOmitTermFreqAndPositions());
        return field;
    }

    @Override
    public void addFieldWithStringData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("StringField", context);
        field.put("value", (Object)context.getStringValue());
        field.put("store", (Object)context.getStore());
        field.put("index", (Object)context.getIndex());
        field.put("termVector", (Object)context.getTermVector());
        this.fieldables.add(field);
    }

    @Override
    public void addFieldWithTokenStreamData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("TokenStreamField", context);
        List<List<AttributeImpl>> stream = context.getTokenStream().getStream();
        ArrayList value = new ArrayList(stream.size());
        for (List<AttributeImpl> attrs : stream) {
            ArrayList<Object> elements = new ArrayList<Object>(attrs.size());
            for (AttributeImpl attr : attrs) {
                elements.add(this.buildAttributeImpl(attr));
            }
            value.add(elements);
        }
        field.put("value", value);
        field.put("termVector", (Object)context.getTermVector());
        this.fieldables.add(field);
    }

    private Object buildAttributeImpl(AttributeImpl attr) {
        if (attr instanceof AnalysisRequestHandlerBase.TokenTrackingAttributeImpl) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("TokenTrackingAttribute"));
            int[] positions = ((AnalysisRequestHandlerBase.TokenTrackingAttributeImpl)attr).getPositions();
            ArrayList<Integer> fullPositions = new ArrayList<Integer>(positions.length);
            for (int position : positions) {
                fullPositions.add(position);
            }
            record.put("positions", fullPositions);
            return record;
        }
        if (attr instanceof CharTermAttributeImpl) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("CharTermAttribute"));
            CharTermAttribute charAttr = (CharTermAttribute)((Object)attr);
            record.put("sequence", (Object)charAttr.toString());
            return record;
        }
        if (attr instanceof PayloadAttribute) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("PayloadAttribute"));
            PayloadAttribute payloadAttr = (PayloadAttribute)((Object)attr);
            record.put("payload", (Object)ByteBuffer.wrap(payloadAttr.getPayload().toByteArray()));
            return record;
        }
        if (attr instanceof KeywordAttribute) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("KeywordAttribute"));
            KeywordAttribute narrowedAttr = (KeywordAttribute)((Object)attr);
            record.put("isKeyword", (Object)narrowedAttr.isKeyword());
            return record;
        }
        if (attr instanceof PositionIncrementAttribute) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("PositionIncrementAttribute"));
            PositionIncrementAttribute narrowedAttr = (PositionIncrementAttribute)((Object)attr);
            record.put("positionIncrement", (Object)narrowedAttr.getPositionIncrement());
            return record;
        }
        if (attr instanceof FlagsAttribute) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("FlagsAttribute"));
            FlagsAttribute narrowedAttr = (FlagsAttribute)((Object)attr);
            record.put("flags", (Object)narrowedAttr.getFlags());
            return record;
        }
        if (attr instanceof TypeAttribute) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("TypeAttribute"));
            TypeAttribute narrowedAttr = (TypeAttribute)((Object)attr);
            record.put("type", (Object)narrowedAttr.type());
            return record;
        }
        if (attr instanceof OffsetAttribute) {
            GenericData.Record record = new GenericData.Record(this.protocol.getType("OffsetAttribute"));
            OffsetAttribute narrowedAttr = (OffsetAttribute)((Object)attr);
            record.put("startOffset", (Object)narrowedAttr.startOffset());
            record.put("endOffset", (Object)narrowedAttr.endOffset());
            return record;
        }
        if (attr instanceof Serializable) {
            return ByteBuffer.wrap(SerializationHelper.toByteArray(attr));
        }
        throw log.attributeNotRecognizedNorSerializable(attr.getClass());
    }

    @Override
    public void addFieldWithSerializableReaderData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("ReaderField", context);
        field.put("value", (Object)ByteBuffer.wrap(context.getReaderValue()));
        field.put("termVector", (Object)context.getTermVector());
        this.fieldables.add(field);
    }

    @Override
    public void addFieldWithSerializableFieldable(byte[] fieldable) {
        GenericData.Record customFieldable = new GenericData.Record(this.protocol.getType("CustomFieldable"));
        customFieldable.put("instance", (Object)ByteBuffer.wrap(fieldable));
        this.fieldables.add((GenericRecord)customFieldable);
    }

    @Override
    public void addDocument(float boost) {
        this.document = new GenericData.Record(this.protocol.getType("Document"));
        this.document.put("boost", (Object)Float.valueOf(boost));
        this.document.put("fieldables", this.fieldables);
    }

    private void clearDocument() {
        this.document = null;
        this.fieldables = null;
    }
}

