/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.optimization.impl;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ExplicitOnlyOptimizerStrategy
implements OptimizerStrategy {
    private static final Log log = LoggerFactory.make();
    protected String indexName;
    private final AtomicBoolean optimizerIsBusy = new AtomicBoolean();

    @Override
    public boolean performOptimization(IndexWriter writer) {
        boolean acquired = this.optimizerIsBusy.compareAndSet(false, true);
        if (acquired) {
            try {
                writer.optimize();
            }
            catch (IOException e) {
                throw new SearchException("Unable to optimize directoryProvider: " + this.indexName, e);
            }
            finally {
                this.optimizerIsBusy.set(false);
            }
            return true;
        }
        log.optimizationSkippedStillBusy(this.indexName);
        return false;
    }

    @Override
    public void addOperationWithinTransactionCount(long operations) {
    }

    @Override
    public void optimize(Workspace workspace) {
    }

    @Override
    public void initialize(IndexManager indexManager, Properties indexProperties) {
        this.indexName = indexManager.getIndexName();
    }
}

