/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.jdbc.connections.spi.DataSourceBasedMultiTenantConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class MultiTenantConnectionProviderInitiator
implements BasicServiceInitiator<MultiTenantConnectionProvider> {
    public static final MultiTenantConnectionProviderInitiator INSTANCE = new MultiTenantConnectionProviderInitiator();
    private static final Logger log = Logger.getLogger(MultiTenantConnectionProviderInitiator.class);

    @Override
    public Class<MultiTenantConnectionProvider> getServiceInitiated() {
        return MultiTenantConnectionProvider.class;
    }

    @Override
    public MultiTenantConnectionProvider initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Class implClass;
        Object configValue;
        MultiTenancyStrategy strategy = MultiTenancyStrategy.determineMultiTenancyStrategy(configurationValues);
        if (strategy == MultiTenancyStrategy.NONE || strategy == MultiTenancyStrategy.DISCRIMINATOR) {
            // empty if block
        }
        if ((configValue = configurationValues.get("hibernate.multi_tenant_connection_provider")) == null) {
            Object dataSourceConfigValue = configurationValues.get("hibernate.connection.datasource");
            if (dataSourceConfigValue != null && String.class.isInstance(dataSourceConfigValue)) {
                return new DataSourceBasedMultiTenantConnectionProviderImpl();
            }
            return null;
        }
        if (MultiTenantConnectionProvider.class.isInstance(configValue)) {
            return (MultiTenantConnectionProvider)configValue;
        }
        if (Class.class.isInstance(configValue)) {
            implClass = (Class)configValue;
        } else {
            String className = configValue.toString();
            ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
            try {
                implClass = classLoaderService.classForName(className);
            }
            catch (ClassLoadingException cle) {
                log.warn((Object)("Unable to locate specified class [" + className + "]"), cle);
                return null;
            }
        }
        try {
            return (MultiTenantConnectionProvider)implClass.newInstance();
        }
        catch (Exception e) {
            log.warn((Object)("Unable to instantiate specified class [" + implClass.getName() + "]"), e);
            return null;
        }
    }
}

