/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.ejb.SessionBean;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.cmi.ha.ReplicationException;
import org.ow2.cmi.ha.StatefulBeanReference;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.lib.ejb21.JStatefulContext;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.ha.JRepStatefulInputStream;
import org.ow2.jonas.lib.ejb21.ha.JRepStatefulOutputStream;
import org.ow2.jonas.lib.util.Log;

public class StatefulBeanRefImpl
implements StatefulBeanReference {
    protected static Logger cmilogger = Log.getLogger((String)"org.ow2.jonas.lib.ejb21.ha");
    private JStatefulSwitch bs;

    public StatefulBeanRefImpl(JStatefulSwitch bs) {
        this.bs = bs;
    }

    public byte[] getState() throws ReplicationException {
        return StatefulBeanRefImpl.getStatefulState(this.bs);
    }

    public boolean isModified() throws ReplicationException {
        SessionStatefulDesc ssd = (SessionStatefulDesc)this.bs.getBeanFactory().getDeploymentDescriptor();
        if (ssd.hasIsModifiedMethod()) {
            Method isModifiedMethod = ssd.getIsModifiedMethod();
            try {
                SessionBean sb = this.bs.getStatefulContext().getInstance();
                return (Boolean)isModifiedMethod.invoke((Object)sb, (Object[])null);
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Cannot invoke method " + isModifiedMethod.getName()), (Throwable)e);
                throw new ReplicationException("Cannot invoke method " + isModifiedMethod.getName(), (Throwable)e);
            }
        }
        return true;
    }

    public void injectState(byte[] state) throws ReplicationException {
        if (this.bs != null) {
            try {
                StatefulBeanRefImpl.injectState(this.bs, state);
            }
            catch (Exception e) {
                cmilogger.log(BasicLevel.ERROR, (Object)("Cannot inject state for bean " + this.bs.getBeanFactory().getEJBName()), (Throwable)e);
                throw new ReplicationException("Cannot inject state for bean " + this.bs.getBeanFactory().getEJBName(), (Throwable)e);
            }
        }
    }

    private static byte[] getStatefulState(JStatefulSwitch jss) throws ReplicationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JStatefulContext ctx = jss.getStatefulContext();
        try {
            SessionBean instance = ctx.getInstance();
            JRepStatefulOutputStream out = new JRepStatefulOutputStream(bos);
            out.writeObject(instance);
            out.close();
        }
        catch (Exception e) {
            cmilogger.log(BasicLevel.ERROR, (Object)("Can't get state of " + jss.getBeanFactory().getEJBName() + " inst."), (Throwable)e);
            throw new ReplicationException("Can't get state of " + jss.getBeanFactory().getEJBName() + " inst.", (Throwable)e);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void injectState(JStatefulSwitch bean, byte[] beanState) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Object obj;
        JStatefulContext bctx = bean.getStatefulContext();
        ByteArrayInputStream bais = new ByteArrayInputStream(beanState);
        JRepStatefulInputStream in = new JRepStatefulInputStream(bais, bean);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bean.getBeanFactory().myClassLoader());
        try {
            obj = in.readObject();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        in.close();
        SessionBean sb = (SessionBean)obj;
        SessionBean oldInstance = bctx.getInstance();
        for (Field field : sb.getClass().getDeclaredFields()) {
            if (!Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            field.set(sb, field.get(oldInstance));
        }
        bctx.setInstance(sb);
        sb.ejbActivate();
    }
}

