/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.db.h2;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.h2.engine.Constants;
import org.h2.tools.Server;
import org.ow2.jonas.db.DBService;
import org.ow2.jonas.db.base.AbsDBServiceImpl;
import org.ow2.jonas.db.base.User;
import org.ow2.jonas.db.h2.H2DBServiceImplMBean;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2DBServiceImpl
extends AbsDBServiceImpl
implements DBService,
H2DBServiceImplMBean,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __Fusers;
    private List<User> users;
    private boolean __FdatabaseName;
    private String databaseName;
    private static final String DEFAULT_PORT = "9001";
    private boolean __Fserver;
    private Server server;
    private boolean __FextraArgs;
    private List<String> extraArgs;
    private boolean __MinitServer$java_util_List$java_lang_String$java_lang_String;
    private boolean __MdoStart;
    private boolean __MsetExtraArgs$java_lang_String;
    private boolean __MdoStop;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    List __getusers() {
        if (!this.__Fusers) {
            return this.users;
        }
        return (List)this.__IM.onGet((Object)this, "users");
    }

    void __setusers(List list) {
        if (!this.__Fusers) {
            this.users = list;
            return;
        }
        this.__IM.onSet((Object)this, "users", (Object)list);
    }

    String __getdatabaseName() {
        if (!this.__FdatabaseName) {
            return this.databaseName;
        }
        return (String)this.__IM.onGet((Object)this, "databaseName");
    }

    void __setdatabaseName(String string) {
        if (!this.__FdatabaseName) {
            this.databaseName = string;
            return;
        }
        this.__IM.onSet((Object)this, "databaseName", (Object)string);
    }

    Server __getserver() {
        if (!this.__Fserver) {
            return this.server;
        }
        return (Server)this.__IM.onGet((Object)this, "server");
    }

    void __setserver(Server server) {
        if (!this.__Fserver) {
            this.server = server;
            return;
        }
        this.__IM.onSet((Object)this, "server", (Object)server);
    }

    List __getextraArgs() {
        if (!this.__FextraArgs) {
            return this.extraArgs;
        }
        return (List)this.__IM.onGet((Object)this, "extraArgs");
    }

    void __setextraArgs(List list) {
        if (!this.__FextraArgs) {
            this.extraArgs = list;
            return;
        }
        this.__IM.onSet((Object)this, "extraArgs", (Object)list);
    }

    public H2DBServiceImpl() {
        this(null);
    }

    private H2DBServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(H2DBServiceImpl.class));
        this.__setusers(null);
        this.__setdatabaseName(null);
        this.__setserver(null);
        this.__setextraArgs(null);
    }

    protected void initServer(List<User> list, String string, String string2) {
        if (!this.__MinitServer$java_util_List$java_lang_String$java_lang_String) {
            this.__M_initServer(list, string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initServer$java_util_List$java_lang_String$java_lang_String", new Object[]{list, string, string2});
            this.__M_initServer(list, string, string2);
            this.__IM.onExit((Object)this, "initServer$java_util_List$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initServer$java_util_List$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_initServer(List<User> users, String databaseName, String portNumber) {
        this.__setusers(users);
        this.portNumber = portNumber != null ? portNumber : DEFAULT_PORT;
        this.__setdatabaseName(databaseName);
        String baseDir = this.getServerProperties().getWorkDirectory() + File.separator + "h2" + File.separator + databaseName;
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-tcpPort");
        argList.add(this.portNumber);
        argList.add("-baseDir");
        argList.add(baseDir);
        if (this.__getextraArgs() != null && this.__getextraArgs().size() > 0) {
            argList.addAll(this.__getextraArgs());
        }
        String[] args = argList.toArray(new String[argList.size()]);
        try {
            this.__setserver(Server.createTcpServer(args));
        }
        catch (SQLException e) {
            throw new ServiceException("Unable to init the server", (Throwable)e);
        }
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        super.doStart();
        this.__getlogger().info((Object)"Starting H2 Server ''{0}'' on port ''{1}''", new Object[]{Constants.getVersion(), this.portNumber});
        try {
            this.__getserver().start();
        }
        catch (SQLException e) {
            throw new ServiceException("Unable to start the H2 server", (Throwable)e);
        }
        Connection conn = null;
        Statement st = null;
        try {
            Class.forName("org.h2.Driver");
            conn = DriverManager.getConnection("jdbc:h2:tcp://localhost:" + this.portNumber + "/" + this.__getdatabaseName(), "sa", "");
            st = conn.createStatement();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot access to H2", (Throwable)e);
        }
        User user2 = null;
        String userName = null;
        String password = null;
        for (User user2 : this.__getusers()) {
            try {
                password = user2.getPassword();
                userName = user2.getUserName();
                this.__getlogger().info((Object)"Dropping and adding user ''{0}'' with password ''{1}''.", new Object[]{userName, password});
                try {
                    st.execute("DROP USER " + userName);
                }
                catch (Exception e) {
                    this.__getlogger().debug((Object)"User ''{0}'' doesn't exists", new Object[]{userName, e});
                }
                st.execute("Create USER " + userName + " PASSWORD '" + password + "' ADMIN");
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Error while creating/adding user", new Object[]{e});
            }
        }
        try {
            st.close();
        }
        catch (Exception e) {
            this.__getlogger().debug((Object)"Error while closing statement object", new Object[]{e});
        }
    }

    public void setExtraArgs(String string) {
        if (!this.__MsetExtraArgs$java_lang_String) {
            this.__M_setExtraArgs(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setExtraArgs$java_lang_String", new Object[]{string});
            this.__M_setExtraArgs(string);
            this.__IM.onExit((Object)this, "setExtraArgs$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setExtraArgs$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setExtraArgs(String extraArgs) {
        this.__setextraArgs(H2DBServiceImpl.convertToList((String)extraArgs));
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        super.doStop();
        this.__getserver().stop();
        this.__getlogger().info((Object)"H2 Server ''{0}'' stopped.", new Object[]{Constants.getVersion()});
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("databaseName")) {
                this.__FdatabaseName = true;
            }
            if (set.contains("extraArgs")) {
                this.__FextraArgs = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("server")) {
                this.__Fserver = true;
            }
            if (set.contains("users")) {
                this.__Fusers = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initServer$java_util_List$java_lang_String$java_lang_String")) {
                this.__MinitServer$java_util_List$java_lang_String$java_lang_String = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("setExtraArgs$java_lang_String")) {
                this.__MsetExtraArgs$java_lang_String = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

