/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.util.SerializableClientProxy;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.JumpMarker;
import org.jboss.weld.util.bytecode.JumpUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.MethodUtils;
import org.jboss.weld.util.bytecode.StaticMethodInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyFactory<T>
extends ProxyFactory<T> {
    private static final Set<Class<? extends Annotation>> CACHABLE_SCOPES;
    public static final String CLIENT_PROXY_SUFFIX = "ClientProxy";
    private static final String CACHE_FIELD = "BEAN_INSTANCE_CACHE";
    private final String beanId;

    public ClientProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        super(proxiedBeanType, typeClosure, bean);
        this.beanId = Container.instance().services().get(ContextualStore.class).putIfAbsent(bean);
    }

    @Override
    protected void addFields(ClassFile proxyClassType, Bytecode initialValueBytecode) {
        super.addFields(proxyClassType, initialValueBytecode);
        if (CACHABLE_SCOPES.contains(this.getBean().getScope())) {
            try {
                FieldInfo sfield = new FieldInfo(proxyClassType.getConstPool(), CACHE_FIELD, "Ljava/lang/ThreadLocal;");
                sfield.setAccessFlags(130);
                proxyClassType.addField(sfield);
                initialValueBytecode.addAload(0);
                initialValueBytecode.addNew(ThreadLocal.class.getName());
                initialValueBytecode.add(89);
                initialValueBytecode.addInvokespecial(ThreadLocal.class.getName(), "<init>", "()V");
                initialValueBytecode.addPutfield(proxyClassType.getName(), CACHE_FIELD, "Ljava/lang/ThreadLocal;");
            }
            catch (DuplicateMemberException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void addSerializationSupport(ClassFile proxyClassType) {
        try {
            Class[] exceptions = new Class[]{ObjectStreamException.class};
            Bytecode writeReplaceBody = this.createWriteReplaceBody(proxyClassType);
            StaticMethodInformation writeReplaceInfo = new StaticMethodInformation("writeReplace", new Class[0], Object.class, proxyClassType.getName());
            proxyClassType.addMethod(MethodUtils.makeMethod(writeReplaceInfo, exceptions, writeReplaceBody, proxyClassType.getConstPool()));
        }
        catch (DuplicateMemberException e) {
            throw new RuntimeException(e);
        }
    }

    private Bytecode createWriteReplaceBody(ClassFile proxyClassType) {
        Bytecode b = new Bytecode(proxyClassType.getConstPool());
        b.addNew(SerializableClientProxy.class.getName());
        b.add(89);
        b.addLdc(this.beanId);
        b.addInvokespecial(SerializableClientProxy.class.getName(), "<init>", "(Ljava/lang/String;)V");
        b.add(176);
        b.setMaxLocals(1);
        return b;
    }

    @Override
    protected Bytecode createForwardingMethodBody(ClassFile file, MethodInformation methodInfo) throws NotFoundException {
        Method method = methodInfo.getMethod();
        boolean bytecodeInvocationAllowed = Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getReturnType().getModifiers());
        for (Class<?> paramType : method.getParameterTypes()) {
            if (Modifier.isPublic(paramType.getModifiers())) continue;
            bytecodeInvocationAllowed = false;
            break;
        }
        if (!bytecodeInvocationAllowed) {
            return this.createInterceptorBody(file, methodInfo);
        }
        Bytecode b = new Bytecode(file.getConstPool());
        int localCount = MethodUtils.calculateMaxLocals(method) + 1;
        int start = b.currentPc();
        b.addInvokestatic("org.jboss.weld.bean.proxy.InterceptionDecorationContext", "startInterceptorContext", "()V");
        Class<Annotation> scope = this.getBean().getScope();
        if (CACHABLE_SCOPES.contains(scope)) {
            this.loadCachableBeanInstance(file, methodInfo, b);
        } else {
            this.loadBeanInstance(file, methodInfo, b);
        }
        b.add(89);
        String methodDescriptor = methodInfo.getDescriptor();
        BytecodeUtils.loadParameters(b, methodDescriptor);
        if (method.getDeclaringClass().isInterface()) {
            b.addInvokeinterface(methodInfo.getDeclaringClass(), methodInfo.getName(), methodDescriptor, method.getParameterTypes().length + 1);
        } else {
            b.addInvokevirtual(methodInfo.getDeclaringClass(), methodInfo.getName(), methodDescriptor);
        }
        b.addInvokestatic("org.jboss.weld.bean.proxy.InterceptionDecorationContext", "endInterceptorContext", "()V");
        b.addOpcode(167);
        JumpMarker gotoEnd = JumpUtils.addJumpInstruction(b);
        b.addExceptionHandler(start, b.currentPc(), b.currentPc(), 0);
        b.addInvokestatic("org.jboss.weld.bean.proxy.InterceptionDecorationContext", "endInterceptorContext", "()V");
        b.add(191);
        gotoEnd.mark();
        if (method.getReturnType().isPrimitive()) {
            BytecodeUtils.addReturnInstruction(b, methodInfo.getReturnType());
        } else {
            b.add(90);
            b.add(165);
            JumpMarker returnInstruction = JumpUtils.addJumpInstruction(b);
            BytecodeUtils.addReturnInstruction(b, methodInfo.getReturnType());
            returnInstruction.mark();
            b.add(42);
            b.addCheckcast(methodInfo.getMethod().getReturnType().getName());
            BytecodeUtils.addReturnInstruction(b, methodInfo.getReturnType());
        }
        if (b.getMaxLocals() < localCount) {
            b.setMaxLocals(localCount);
        }
        return b;
    }

    private void loadCachableBeanInstance(ClassFile file, MethodInformation methodInfo, Bytecode b) {
        b.addInvokestatic(RequestScopedBeanCache.class.getName(), "isActive", "()Z");
        b.add(153);
        JumpMarker returnInstruction = JumpUtils.addJumpInstruction(b);
        b.addAload(0);
        b.addGetfield(file.getName(), CACHE_FIELD, "Ljava/lang/ThreadLocal;");
        b.addInvokevirtual(ThreadLocal.class.getName(), "get", "()Ljava/lang/Object;");
        b.add(89);
        b.add(198);
        JumpMarker createNewInstance = JumpUtils.addJumpInstruction(b);
        b.addCheckcast(methodInfo.getDeclaringClass());
        b.add(167);
        JumpMarker loadedFromCache = JumpUtils.addJumpInstruction(b);
        createNewInstance.mark();
        b.add(87);
        this.loadBeanInstance(file, methodInfo, b);
        b.add(89);
        b.addAload(0);
        b.addGetfield(file.getName(), CACHE_FIELD, "Ljava/lang/ThreadLocal;");
        b.add(90);
        b.add(95);
        b.addInvokevirtual(ThreadLocal.class.getName(), "set", "(Ljava/lang/Object;)V");
        b.addInvokestatic(RequestScopedBeanCache.class.getName(), "addItem", "(Ljava/lang/ThreadLocal;)V");
        b.add(167);
        JumpMarker endOfIfStatement = JumpUtils.addJumpInstruction(b);
        returnInstruction.mark();
        this.loadBeanInstance(file, methodInfo, b);
        endOfIfStatement.mark();
        loadedFromCache.mark();
    }

    private void loadBeanInstance(ClassFile file, MethodInformation methodInfo, Bytecode b) {
        b.add(42);
        b.addGetfield(file.getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.add(42);
        b.add(1);
        b.add(1);
        b.add(1);
        b.addInvokeinterface(MethodHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        b.addCheckcast(methodInfo.getDeclaringClass());
    }

    @Override
    protected MethodInfo generateHashCodeMethod(ClassFile proxyClassType) {
        MethodInfo method = new MethodInfo(proxyClassType.getConstPool(), "hashCode", "()I");
        method.setAccessFlags(1);
        Bytecode b = new Bytecode(proxyClassType.getConstPool());
        int classLocation = proxyClassType.getConstPool().addClassInfo(proxyClassType.getName());
        b.addLdc(classLocation);
        b.addInvokevirtual("java.lang.Object", "hashCode", "()I");
        b.add(172);
        b.setMaxLocals(1);
        b.setMaxStack(1);
        method.setCodeAttribute(b.toCodeAttribute());
        return method;
    }

    @Override
    protected MethodInfo generateEqualsMethod(ClassFile proxyClassType) {
        MethodInfo method = new MethodInfo(proxyClassType.getConstPool(), "equals", "(Ljava/lang/Object;)Z");
        method.setAccessFlags(1);
        Bytecode b = new Bytecode(proxyClassType.getConstPool());
        b.addAload(1);
        b.addInstanceof(proxyClassType.getName());
        b.add(172);
        b.setMaxLocals(2);
        b.setMaxStack(1);
        method.setCodeAttribute(b.toCodeAttribute());
        return method;
    }

    @Override
    protected String getProxyNameSuffix() {
        return CLIENT_PROXY_SUFFIX;
    }

    static {
        HashSet<Class> scopes = new HashSet<Class>();
        scopes.add(RequestScoped.class);
        scopes.add(ConversationScoped.class);
        scopes.add(SessionScoped.class);
        scopes.add(ApplicationScoped.class);
        CACHABLE_SCOPES = Collections.unmodifiableSet(scopes);
    }
}

