/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.messages;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.Properties;
import fr.dyade.aaa.common.stream.StreamUtil;
import fr.dyade.aaa.common.stream.Streamable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class Message
implements Cloneable,
Serializable,
Streamable {
    private static final long serialVersionUID = 3L;
    public static final int NON_PERSISTENT = 1;
    public static final int PERSISTENT = 2;
    public static final int DEFAULT_DELIVERY_MODE = 2;
    public static final int DEFAULT_PRIORITY = 4;
    public static final long DEFAULT_TIME_TO_LIVE = 0L;
    public static Logger logger = Debug.getLogger((String)Message.class.getName());
    public transient byte[] body = null;
    public transient Properties properties = null;
    public transient String id = null;
    public transient boolean persistent = true;
    public static final int SIMPLE = 0;
    public static final int TEXT = 1;
    public static final int OBJECT = 2;
    public static final int MAP = 3;
    public static final int STREAM = 4;
    public static final int BYTES = 5;
    public static final int ADMIN = 6;
    public transient int type = 0;
    public transient String jmsType = null;
    public transient int priority = 4;
    public transient long expiration = 0L;
    public transient long timestamp;
    public transient boolean redelivered = false;
    public transient String toId = null;
    public transient byte toType;
    public transient String replyToId = null;
    public transient byte replyToType;
    public transient String correlationId = null;
    public transient int deliveryCount = 0;
    private static final short typeFlag = 1;
    private static final short replyToIdFlag = 2;
    private static final short replyToTypeFlag = 4;
    private static final short propertiesFlag = 8;
    private static final short priorityFlag = 16;
    private static final short expirationFlag = 32;
    private static final short corrrelationIdFlag = 64;
    private static final short deliveryCountFlag = 128;
    private static final short jmsTypeFlag = 256;
    private static final short redeliveredFlag = 512;
    private static final short persistentFlag = 1024;

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (value instanceof Boolean || value instanceof Number || value instanceof String) {
            this.properties.put(name, value);
        } else {
            this.properties.put(name, (Object)value.toString());
        }
    }

    public final void setDestination(String id, byte type) {
        this.toId = id;
        this.toType = type;
    }

    public final void setReplyTo(String id, byte type) {
        this.replyToId = id;
        this.replyToType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toBytes(Serializable object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    private Serializable fromBytes(byte[] body) throws Exception {
        if (body == null) {
            return null;
        }
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        Object obj = null;
        try {
            try {
                bais = new ByteArrayInputStream(body);
                ois = new ObjectInputStream(bais);
                obj = ois.readObject();
            }
            catch (ClassNotFoundException cnfexc) {
                bais = new ByteArrayInputStream(body);
                class Specialized_OIS
                extends ObjectInputStream {
                    Specialized_OIS(InputStream is) throws IOException {
                        super(is);
                    }

                    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
                        String n = osc.getName();
                        return Class.forName(n, false, Thread.currentThread().getContextClassLoader());
                    }
                }
                ois = new Specialized_OIS(bais);
                obj = ois.readObject();
            }
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"ERROR: fromBytes(body)", (Throwable)exc);
            }
            throw exc;
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {}
            try {
                bais.close();
            }
            catch (Exception e) {}
        }
        return (Serializable)obj;
    }

    public void setText(String text) throws IOException {
        this.body = this.toBytes((Serializable)((Object)text));
    }

    public String getText() throws Exception {
        if (this.body == null) {
            return null;
        }
        return (String)((Object)this.fromBytes(this.body));
    }

    public void setObject(Serializable object) throws IOException {
        this.type = 2;
        this.body = this.toBytes(object);
    }

    public Serializable getObject() throws Exception {
        return this.fromBytes(this.body);
    }

    public void setAdminMessage(AbstractAdminMessage adminMsg) throws IOException {
        this.type = 6;
        if (adminMsg == null) {
            this.body = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AbstractAdminMessage.write(adminMsg, baos);
            baos.flush();
            this.body = baos.toByteArray();
            baos.close();
        }
    }

    public AbstractAdminMessage getAdminMessage() {
        AbstractAdminMessage adminMsg;
        block3: {
            if (this.body == null) {
                return null;
            }
            ByteArrayInputStream bais = null;
            adminMsg = null;
            try {
                bais = new ByteArrayInputStream(this.body);
                adminMsg = AbstractAdminMessage.read(bais);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block3;
                logger.log(BasicLevel.ERROR, (Object)"ERROR: getAdminMessage()", (Throwable)e);
            }
        }
        return adminMsg;
    }

    public final String toString() {
        StringBuffer strbuf = new StringBuffer();
        this.toString(strbuf);
        return strbuf.toString();
    }

    public void toString(StringBuffer strbuf) {
        strbuf.append('(').append(super.toString());
        strbuf.append(",id=").append(this.id);
        strbuf.append(",type=").append(this.type);
        strbuf.append(",persistent=").append(this.persistent);
        strbuf.append(",priority=").append(this.priority);
        strbuf.append(",expiration=").append(this.expiration);
        strbuf.append(",timestamp=").append(this.timestamp);
        strbuf.append(",toId=").append(this.toId);
        strbuf.append(",replyToId=").append(this.replyToId);
        strbuf.append(",correlationId=").append(this.correlationId);
        strbuf.append(')');
    }

    public Object clone() {
        try {
            Message clone = (Message)super.clone();
            if (this.body != null) {
                clone.body = new byte[this.body.length];
                System.arraycopy(this.body, 0, clone.body, 0, this.body.length);
            }
            if (this.properties != null) {
                clone.properties = (Properties)this.properties.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException cE) {
            return null;
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        this.writeHeaderTo(os);
        StreamUtil.writeTo((byte[])this.body, (OutputStream)os);
    }

    public void writeHeaderTo(OutputStream os) throws IOException {
        StreamUtil.writeTo((String)this.id, (OutputStream)os);
        StreamUtil.writeTo((String)this.toId, (OutputStream)os);
        StreamUtil.writeTo((byte)this.toType, (OutputStream)os);
        StreamUtil.writeTo((long)this.timestamp, (OutputStream)os);
        short s = 0;
        if (this.type != 0) {
            s = (short)(s | 1);
        }
        if (this.replyToId != null) {
            s = (short)(s | 2);
        }
        if (this.replyToType != 0) {
            s = (short)(s | 4);
        }
        if (this.properties != null) {
            s = (short)(s | 8);
        }
        if (this.priority != 4) {
            s = (short)(s | 0x10);
        }
        if (this.expiration != 0L) {
            s = (short)(s | 0x20);
        }
        if (this.correlationId != null) {
            s = (short)(s | 0x40);
        }
        if (this.deliveryCount != 0) {
            s = (short)(s | 0x80);
        }
        if (this.jmsType != null) {
            s = (short)(s | 0x100);
        }
        if (this.redelivered) {
            s = (short)(s | 0x200);
        }
        if (this.persistent) {
            s = (short)(s | 0x400);
        }
        StreamUtil.writeTo((short)s, (OutputStream)os);
        if (this.type != 0) {
            StreamUtil.writeTo((int)this.type, (OutputStream)os);
        }
        if (this.replyToId != null) {
            StreamUtil.writeTo((String)this.replyToId, (OutputStream)os);
        }
        if (this.replyToType != 0) {
            StreamUtil.writeTo((byte)this.replyToType, (OutputStream)os);
        }
        if (this.properties != null) {
            StreamUtil.writeTo((Properties)this.properties, (OutputStream)os);
        }
        if (this.priority != 4) {
            StreamUtil.writeTo((int)this.priority, (OutputStream)os);
        }
        if (this.expiration != 0L) {
            StreamUtil.writeTo((long)this.expiration, (OutputStream)os);
        }
        if (this.correlationId != null) {
            StreamUtil.writeTo((String)this.correlationId, (OutputStream)os);
        }
        if (this.deliveryCount != 0) {
            StreamUtil.writeTo((int)this.deliveryCount, (OutputStream)os);
        }
        if (this.jmsType != null) {
            StreamUtil.writeTo((String)this.jmsType, (OutputStream)os);
        }
    }

    public void readFrom(InputStream is) throws IOException {
        this.readHeaderFrom(is);
        this.body = StreamUtil.readByteArrayFrom((InputStream)is);
    }

    public void readHeaderFrom(InputStream is) throws IOException {
        this.id = StreamUtil.readStringFrom((InputStream)is);
        this.toId = StreamUtil.readStringFrom((InputStream)is);
        this.toType = StreamUtil.readByteFrom((InputStream)is);
        this.timestamp = StreamUtil.readLongFrom((InputStream)is);
        short s = StreamUtil.readShortFrom((InputStream)is);
        if ((s & 1) != 0) {
            this.type = StreamUtil.readIntFrom((InputStream)is);
        }
        if ((s & 2) != 0) {
            this.replyToId = StreamUtil.readStringFrom((InputStream)is);
        }
        if ((s & 4) != 0) {
            this.replyToType = StreamUtil.readByteFrom((InputStream)is);
        }
        if ((s & 8) != 0) {
            this.properties = StreamUtil.readPropertiesFrom((InputStream)is);
        }
        this.priority = 4;
        if ((s & 0x10) != 0) {
            this.priority = StreamUtil.readIntFrom((InputStream)is);
        }
        if ((s & 0x20) != 0) {
            this.expiration = StreamUtil.readLongFrom((InputStream)is);
        }
        if ((s & 0x40) != 0) {
            this.correlationId = StreamUtil.readStringFrom((InputStream)is);
        }
        if ((s & 0x80) != 0) {
            this.deliveryCount = StreamUtil.readIntFrom((InputStream)is);
        }
        if ((s & 0x100) != 0) {
            this.jmsType = StreamUtil.readStringFrom((InputStream)is);
        }
        this.redelivered = (s & 0x200) != 0;
        this.persistent = (s & 0x400) != 0;
    }

    public static void writeVectorTo(Vector messages, OutputStream os) throws IOException {
        if (messages == null) {
            StreamUtil.writeTo((int)-1, (OutputStream)os);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"writeVectorTo: -1");
            }
        } else {
            int size = messages.size();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("writeVectorTo: " + size));
            }
            StreamUtil.writeTo((int)size, (OutputStream)os);
            for (int i = 0; i < size; ++i) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("writeVectorTo: msg#" + i));
                }
                ((Message)messages.elementAt(i)).writeTo(os);
            }
        }
    }

    public static Vector readVectorFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom((InputStream)is);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("readVectorFrom: " + size));
        }
        if (size == -1) {
            return null;
        }
        Vector<Message> messages = new Vector<Message>(size);
        for (int i = 0; i < size; ++i) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("readVectorFrom: msg#" + i));
            }
            Message msg = new Message();
            msg.readFrom(is);
            messages.addElement(msg);
        }
        return messages;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readFrom(in);
    }
}

