/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.context.FacesContext;
import org.jboss.weld.Container;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.jsf.FacesUrlTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationAwareViewHandler
extends ViewHandlerWrapper {
    private final ViewHandler delegate;
    private volatile ConversationContext conversationContext;
    private static final ThreadLocal<Source> source = new ThreadLocal();

    public ConversationAwareViewHandler(ViewHandler delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConversationContext getConversationContext() {
        if (this.conversationContext == null) {
            ConversationAwareViewHandler conversationAwareViewHandler = this;
            synchronized (conversationAwareViewHandler) {
                if (this.conversationContext == null) {
                    Container container = Container.instance();
                    this.conversationContext = (ConversationContext)container.deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
                }
            }
        }
        return this.conversationContext;
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        String actionUrl = super.getActionURL(facesContext, viewId);
        ManagedConversation conversation = this.getConversationContext().getCurrentConversation();
        if (!this.getSource().equals((Object)Source.BOOKMARKABLE) && this.getConversationContext().isActive() && !conversation.isTransient()) {
            return new FacesUrlTransformer(actionUrl, facesContext).appendConversationIdIfNecessary(this.getConversationContext().getParameterName(), conversation.getId()).getUrl();
        }
        return actionUrl;
    }

    private Source getSource() {
        if (source.get() == null) {
            return Source.ACTION;
        }
        return source.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            source.set(Source.BOOKMARKABLE);
            String string = super.getBookmarkableURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        try {
            source.set(Source.REDIRECT);
            String string = super.getRedirectURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceURL(FacesContext context, String path) {
        try {
            source.set(Source.RESOURCE);
            String string = super.getResourceURL(context, path);
            return string;
        }
        finally {
            source.remove();
        }
    }

    public ViewHandler getWrapped() {
        return this.delegate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Source {
        ACTION,
        BOOKMARKABLE,
        REDIRECT,
        RESOURCE;

    }
}

