/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeansClosure {
    private final BeanManagerImpl owner;
    private volatile Set<BeanManagerImpl> accessibleBeanManagers;
    private final Map<Bean<?>, Bean<?>> specialized = new ConcurrentHashMap();
    private final Map<BeanDeployerEnvironment, Object> envs = new ConcurrentHashMap<BeanDeployerEnvironment, Object>();

    public BeansClosure(BeanManagerImpl owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BeanManagerImpl> getAccessibleBeanManagers() {
        if (this.accessibleBeanManagers == null) {
            BeansClosure beansClosure = this;
            synchronized (beansClosure) {
                if (this.accessibleBeanManagers == null) {
                    HashSet<BeanManagerImpl> tmp = new HashSet<BeanManagerImpl>();
                    for (Iterable<BeanManagerImpl> beanManagers : BeanManagers.getAccessibleClosure(this.owner)) {
                        for (BeanManagerImpl accessibleBeanManager : beanManagers) {
                            if (this.owner == accessibleBeanManager) continue;
                            tmp.add(accessibleBeanManager);
                        }
                    }
                    this.accessibleBeanManagers = tmp;
                }
            }
        }
        return this.accessibleBeanManagers;
    }

    public void addSpecialized(Bean<?> target, Bean<?> override) {
        this.addSpecializedInternal(target, override);
        for (BeanManagerImpl accessibleBeanManager : this.getAccessibleBeanManagers()) {
            BeansClosure closure = accessibleBeanManager.getClosure();
            closure.addSpecializedInternal(target, override);
        }
    }

    protected void addSpecializedInternal(Bean<?> target, Bean<?> override) {
        this.specialized.put(target, override);
    }

    public void addEnvironment(BeanDeployerEnvironment environment) {
        this.addEnvironmentInternal(environment);
        for (BeanManagerImpl accessibleBeanManager : this.getAccessibleBeanManagers()) {
            BeansClosure closure = accessibleBeanManager.getClosure();
            closure.addEnvironmentInternal(environment);
        }
    }

    protected void addEnvironmentInternal(BeanDeployerEnvironment environment) {
        this.envs.put(environment, Object.class);
    }

    public void clear() {
        this.envs.clear();
    }

    public void destroy() {
        this.specialized.clear();
        if (this.accessibleBeanManagers != null) {
            this.accessibleBeanManagers.clear();
        }
    }

    @Deprecated
    public Map getSpecialized() {
        return Collections.unmodifiableMap(this.specialized);
    }

    public Bean<?> getSpecialized(Bean<?> bean) {
        return this.specialized.get(bean);
    }

    public boolean isSpecialized(Bean<?> bean) {
        return this.getSpecialized(bean) != null;
    }

    public Bean<?> mostSpecialized(Bean<?> bean) {
        Bean<?> most = bean;
        while (most != null) {
            Bean<?> temp = most;
            most = this.specialized.get(bean);
            bean = temp;
        }
        return bean;
    }

    public boolean isEJB(WeldClass<?> clazz) {
        for (BeanDeployerEnvironment bde : this.envs.keySet()) {
            EjbDescriptors ed = bde.getEjbDescriptors();
            if (!ed.contains(clazz.getJavaClass())) continue;
            return true;
        }
        return false;
    }

    public Bean<?> getClassBean(WeldClass<?> clazz) {
        for (BeanDeployerEnvironment bde : this.envs.keySet()) {
            AbstractClassBean<?> classBean = bde.getClassBean(clazz);
            if (classBean == null) continue;
            return classBean;
        }
        return null;
    }

    public ProducerMethod<?, ?> getProducerMethod(WeldMethod<?, ?> superClassMethod) {
        for (BeanDeployerEnvironment bde : this.envs.keySet()) {
            ProducerMethod<?, ?> pm = bde.getProducerMethod(superClassMethod);
            if (pm == null) continue;
            return pm;
        }
        return null;
    }
}

