/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyDiscovery {
    private final Type type;
    private BiMap<Type, Class<?>> types;
    private Map<Class, Type> cache = new HashMap<Class, Type>();

    public HierarchyDiscovery(Type type) {
        this.type = type;
    }

    protected void add(Class<?> clazz, Type type) {
        this.types.forcePut(type, clazz);
        this.cache.put(clazz, type);
    }

    public Set<Type> getTypeClosure() {
        if (this.types == null) {
            this.init();
            this.cache = null;
        }
        return new ArraySet(this.types.keySet()).trimToSize();
    }

    public Map<Class<?>, Type> getTypeMap() {
        if (this.types == null) {
            this.init();
        }
        return this.types.inverse();
    }

    private void init() {
        this.types = HashBiMap.create();
        try {
            this.discoverTypes(this.type);
        }
        catch (StackOverflowError e) {
            System.out.println("type" + this.type);
            Thread.dumpStack();
            throw e;
        }
    }

    public Type getResolvedType() {
        if (this.type instanceof Class) {
            Class clazz = (Class)this.type;
            return this.resolveType(clazz);
        }
        return this.type;
    }

    private void discoverTypes(Type type) {
        if (type != null) {
            Type rawType;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                this.add(clazz, this.resolveType(clazz));
                this.discoverFromClass(clazz);
            } else if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                Type genericComponentType = arrayType.getGenericComponentType();
                Class<?> arrayClass = Array.newInstance(Reflections.getRawType(genericComponentType), 0).getClass();
                this.add(arrayClass, type);
                this.discoverFromClass(arrayClass);
            } else if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
                Class clazz = (Class)rawType;
                this.discoverFromClass(clazz);
                this.add(clazz, type);
            }
        }
    }

    private Type resolveType(Class<?> clazz) {
        if (clazz.getTypeParameters().length > 0) {
            Type[] actualTypeParameters = clazz.getTypeParameters();
            return new ParameterizedTypeImpl(clazz, actualTypeParameters, clazz.getDeclaringClass());
        }
        return clazz;
    }

    private void discoverFromClass(Class<?> clazz) {
        try {
            this.discoverTypes(this.resolveType(this.type, this.type, clazz.getGenericSuperclass()));
            for (Type c : clazz.getGenericInterfaces()) {
                this.discoverTypes(this.resolveType(this.type, this.type, c));
            }
        }
        catch (AccessControlException e) {
            Reflections.log.trace(UtilMessage.SECURITY_EXCEPTION_SCANNING, clazz);
            Reflections.xLog.throwing(XLogger.Level.TRACE, e);
        }
    }

    private Type resolveType(Type beanType, Type beanType2, Type type) {
        if (type instanceof ParameterizedType) {
            if (beanType instanceof ParameterizedType) {
                return this.resolveParameterizedType((ParameterizedType)beanType, (ParameterizedType)type);
            }
            if (beanType instanceof Class) {
                return this.resolveType(((Class)beanType).getGenericSuperclass(), beanType2, type);
            }
        }
        if (type instanceof TypeVariable) {
            if (beanType instanceof ParameterizedType) {
                return this.resolveTypeParameter((ParameterizedType)beanType, beanType2, (TypeVariable)type);
            }
            if (beanType instanceof Class) {
                return this.resolveType(((Class)beanType).getGenericSuperclass(), beanType2, type);
            }
        }
        return type;
    }

    private Type resolveParameterizedType(ParameterizedType beanType, ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypes = parameterizedType.getActualTypeArguments();
        Type resolvedRawType = this.resolveType(beanType, beanType, rawType);
        Type[] resolvedActualTypes = new Type[actualTypes.length];
        for (int i = 0; i < actualTypes.length; ++i) {
            resolvedActualTypes[i] = this.resolveType(beanType, beanType, actualTypes[i]);
        }
        ParameterizedTypeImpl pt = new ParameterizedTypeImpl(resolvedRawType, resolvedActualTypes, parameterizedType.getOwnerType());
        if (resolvedRawType instanceof Class) {
            this.cache.put((Class)resolvedRawType, pt);
        }
        return pt;
    }

    private Type resolveTypeParameter(ParameterizedType type, Type beanType, TypeVariable<?> typeVariable) {
        Type resolvedGenericSuperType;
        Class actualType = (Class)type.getRawType();
        TypeVariable<Class<T>>[] typeVariables = actualType.getTypeParameters();
        Type[] actualTypes = type.getActualTypeArguments();
        for (int i = 0; i < typeVariables.length; ++i) {
            if (actualTypes[i] instanceof TypeVariable || !typeVariables[i].equals(typeVariable) || actualTypes[i].equals(typeVariable)) continue;
            return this.resolveType(this.type, beanType, actualTypes[i]);
        }
        Class superClass = actualType.getSuperclass();
        Type genericSuperType = this.cache.get(superClass);
        if (genericSuperType == null) {
            genericSuperType = actualType.getGenericSuperclass();
        }
        if (!((resolvedGenericSuperType = this.resolveType(genericSuperType, beanType, typeVariable)) instanceof TypeVariable)) {
            return resolvedGenericSuperType;
        }
        for (Type interfaceType : actualType.getGenericInterfaces()) {
            Type resolvedType;
            Type cached;
            Type rawType;
            if (interfaceType instanceof ParameterizedType && (rawType = ((ParameterizedType)interfaceType).getRawType()) instanceof Class && (cached = this.cache.get(Class.class.cast(rawType))) != null) {
                interfaceType = cached;
            }
            if ((resolvedType = this.resolveType(interfaceType, interfaceType, typeVariable)) instanceof TypeVariable) continue;
            return resolvedType;
        }
        return typeVariable;
    }
}

