/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.object;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.object.LocalServerListener;
import org.apache.cxf.binding.object.ObjectBinding;
import org.apache.cxf.binding.object.ObjectBindingConfiguration;
import org.apache.cxf.binding.object.ObjectDispatchInInterceptor;
import org.apache.cxf.binding.object.ObjectDispatchOutInterceptor;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

@NoJSR250Annotations(unlessNull={"bus"})
public class ObjectBindingFactory
extends AbstractBindingFactory {
    public static final String BINDING_ID = "http://cxf.apache.org/binding/object";
    public static final String RUN_NON_LOGICAL = "objectBinding.stopAfterLogical";
    public static final Collection<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/binding/object");
    private boolean autoRegisterLocalEndpoint;
    private boolean initialized = true;
    private LocalServerListener listener;

    public ObjectBindingFactory() {
    }

    public ObjectBindingFactory(Bus b) {
        super(b, DEFAULT_NAMESPACES);
        this.initialize();
    }

    @PostConstruct
    public final void initialize() {
        Bus bus;
        ServerLifeCycleManager manager;
        if (this.autoRegisterLocalEndpoint) {
            Bus bus2 = this.getBus();
            ServerLifeCycleManager manager2 = bus2.getExtension(ServerLifeCycleManager.class);
            if (manager2 != null) {
                this.listener = new LocalServerListener(bus2, this);
                manager2.registerListener(this.listener);
            }
        } else if (this.listener != null && (manager = (bus = this.getBus()).getExtension(ServerLifeCycleManager.class)) != null) {
            manager.unRegisterListener(this.listener);
            this.listener = null;
        }
        this.initialized = true;
    }

    @Override
    public Binding createBinding(BindingInfo bi) {
        ObjectBinding binding = new ObjectBinding(bi);
        binding.getOutInterceptors().add(new ObjectDispatchOutInterceptor());
        binding.getInInterceptors().add(new ObjectDispatchInInterceptor());
        return binding;
    }

    @Override
    public BindingInfo createBindingInfo(ServiceInfo si, String bindingid, Object config) {
        BindingInfo info = super.createBindingInfo(si, bindingid, config);
        if (config instanceof ObjectBindingConfiguration) {
            ObjectBindingConfiguration c = (ObjectBindingConfiguration)config;
            info.setProperty(RUN_NON_LOGICAL, c.isNonLogicalPhasesEnabled());
        }
        info.setName(new QName(si.getName().getNamespaceURI(), si.getName().getLocalPart() + "ObjectBinding"));
        for (OperationInfo o : si.getInterface().getOperations()) {
            BindingOperationInfo bop = info.buildOperation(o.getName(), o.getInputName(), o.getOutputName());
            info.addOperation(bop);
        }
        return info;
    }

    public boolean isAutoRegisterLocalEndpoint() {
        return this.autoRegisterLocalEndpoint;
    }

    public void setAutoRegisterLocalEndpoint(boolean autoRegisterLocalEndpoint) {
        this.autoRegisterLocalEndpoint = autoRegisterLocalEndpoint;
        if (this.initialized && this.listener == null) {
            this.initialize();
        }
    }
}

