/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.MessageProcessingException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public final class ResponseImpl
extends Response {
    private int status;
    private Object entity;
    private Annotation[] entityAnnotations;
    private MultivaluedMap<String, Object> metadata;
    private Message responseMessage;
    private boolean entityClosed;
    private boolean entityBufferred;

    ResponseImpl(int s) {
        this.status = s;
    }

    ResponseImpl(int s, Object e) {
        this.status = s;
        this.entity = e;
    }

    void addMetadata(MultivaluedMap<String, Object> meta) {
        this.metadata = meta;
    }

    void setStatus(int s) {
        this.status = s;
    }

    void setEntity(Object e, Annotation[] anns) {
        this.entity = e;
        this.entityAnnotations = anns;
    }

    Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setMessage(Message message) {
        this.responseMessage = message;
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        final Response.Status responseStatus = Response.Status.fromStatusCode((int)this.status);
        return new Response.StatusType(){

            public Response.Status.Family getFamily() {
                return responseStatus.getFamily();
            }

            public String getReasonPhrase() {
                return responseStatus.getReasonPhrase();
            }

            public int getStatusCode() {
                return responseStatus.getStatusCode();
            }
        };
    }

    public Object getEntity() {
        return this.entity;
    }

    public boolean hasEntity() {
        return this.getEntity() != null;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.getHeaders();
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.metadata;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        MetadataMap<String, String> headers = new MetadataMap<String, String>(this.metadata.size());
        for (Map.Entry entry : this.metadata.entrySet()) {
            headers.put((String)entry.getKey(), this.toListOfStrings((List)entry.getValue()));
        }
        return headers;
    }

    public String getHeader(String header) {
        Object value = this.metadata.getFirst((Object)header);
        return value == null ? null : value.toString();
    }

    public String getHeaderString(String header) {
        List methodValues = (List)this.metadata.get((Object)header);
        return HttpUtils.getHeaderString(this.toListOfStrings(methodValues));
    }

    private List<String> toListOfStrings(List<Object> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (Object value : values) {
            stringValues.add(value.toString());
        }
        return stringValues;
    }

    public Set<String> getAllowedMethods() {
        List methodValues = (List)this.metadata.get((Object)"Allow");
        if (methodValues == null) {
            return Collections.emptySet();
        }
        HashSet<String> methods = new HashSet<String>();
        for (Object o : methodValues) {
            methods.add(o.toString());
        }
        return methods;
    }

    public Map<String, NewCookie> getCookies() {
        List cookieValues = (List)this.metadata.get((Object)"Set-Cookie");
        if (cookieValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        for (Object o : cookieValues) {
            NewCookie newCookie = NewCookie.valueOf((String)o.toString());
            cookies.put(newCookie.getName(), newCookie);
        }
        return cookies;
    }

    public Date getDate() {
        return this.doGetDate("Date");
    }

    private Date doGetDate(String dateHeader) {
        return HttpUtils.getHttpDate(this.getHeader(dateHeader));
    }

    public EntityTag getEntityTag() {
        String header = this.getHeader("ETag");
        return header == null ? null : EntityTag.valueOf((String)header);
    }

    public Locale getLanguage() {
        return HttpUtils.getLocale(this.getHeader("Content-Language"));
    }

    public Date getLastModified() {
        return this.doGetDate("Last-Modified");
    }

    public int getLength() {
        return HttpUtils.getContentLength(this.getHeader("Content-Length"));
    }

    public URI getLocation() {
        String header = this.getHeader("Location");
        return header == null ? null : URI.create(header);
    }

    public MediaType getMediaType() {
        String header = this.getHeader("Content-Type");
        return header == null ? null : MediaType.valueOf((String)header);
    }

    public boolean hasLink(String relation) {
        return this.getLink(relation) != null;
    }

    public Link getLink(String relation) {
        Set<Map.Entry<String, Link>> entries = this.getAllLinks().entrySet();
        for (Map.Entry<String, Link> entry : entries) {
            if (!entry.getKey().contains(relation)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        return Link.fromLink((Link)this.getLink(relation));
    }

    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getAllLinks().values());
    }

    private Map<String, Link> getAllLinks() {
        List linkValues = (List)this.metadata.get((Object)"Link");
        if (linkValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Link> links = new HashMap<String, Link>();
        for (Object o : linkValues) {
            Link link = Link.valueOf((String)o.toString());
            links.put(link.getRel(), link);
        }
        return links;
    }

    public <T> T readEntity(Class<T> cls) throws MessageProcessingException, IllegalStateException {
        return this.readEntity(cls, new Annotation[0]);
    }

    public <T> T readEntity(GenericType<T> genType) throws MessageProcessingException, IllegalStateException {
        return this.readEntity(genType, new Annotation[0]);
    }

    public <T> T readEntity(Class<T> cls, Annotation[] anns) throws MessageProcessingException, IllegalStateException {
        return this.doReadEntity(cls, cls, anns);
    }

    public <T> T readEntity(GenericType<T> genType, Annotation[] anns) throws MessageProcessingException, IllegalStateException {
        return this.doReadEntity(genType.getRawType(), genType.getType(), anns);
    }

    public <T> T doReadEntity(Class<T> cls, Type t, Annotation[] anns) throws MessageProcessingException, IllegalStateException {
        this.checkEntityIsClosed();
        if (!this.hasEntity()) {
            return null;
        }
        if (cls.isAssignableFrom(this.entity.getClass())) {
            T response = cls.cast(this.entity);
            this.closeIfNotBufferred(cls);
            return response;
        }
        if (this.responseMessage != null && this.entity instanceof InputStream) {
            MediaType mediaType = this.getMediaType();
            List<ReaderInterceptor> readers = ProviderFactory.getInstance(this.responseMessage).createMessageBodyReaderInterceptor(cls, t, anns, mediaType, this.responseMessage.getExchange().getOutMessage());
            if (readers != null) {
                try {
                    this.responseMessage.put(Message.PROTOCOL_HEADERS, this.getMetadata());
                    T t2 = cls.cast(JAXRSUtils.readFromMessageBodyReader(readers, cls, t, anns, (InputStream)InputStream.class.cast(this.entity), mediaType, this.responseMessage));
                    return t2;
                }
                catch (Exception ex) {
                    throw new MessageProcessingException((Throwable)ex);
                }
                finally {
                    this.closeIfNotBufferred(cls);
                }
            }
        }
        throw new MessageProcessingException("No Message Body reader is available");
    }

    private void closeIfNotBufferred(Class<?> responseCls) {
        if (!this.entityBufferred && !InputStream.class.isAssignableFrom(responseCls)) {
            this.close();
        }
    }

    public boolean bufferEntity() throws MessageProcessingException {
        if (this.entityClosed) {
            throw new IllegalStateException();
        }
        if (!this.entityBufferred && this.entity instanceof InputStream) {
            try {
                InputStream oldEntity = (InputStream)this.entity;
                this.entity = IOUtils.loadIntoBAIS(oldEntity);
                this.entityBufferred = true;
            }
            catch (IOException ex) {
                throw new MessageProcessingException((Throwable)ex);
            }
        }
        return this.entityBufferred;
    }

    public void close() throws MessageProcessingException {
        if (!this.entityClosed) {
            if (this.entity instanceof InputStream) {
                try {
                    ((InputStream)this.entity).close();
                    this.entity = null;
                }
                catch (IOException ex) {
                    throw new MessageProcessingException((Throwable)ex);
                }
            }
            this.entityClosed = true;
        }
    }

    private void checkEntityIsClosed() {
        if (this.entityClosed) {
            throw new IllegalStateException("Entity is not available");
        }
    }
}

