/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.SessionAuthenticityTokenProvider;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

public abstract class RedirectionBasedGrantService
extends AbstractOAuthService {
    private String supportedResponseType;
    private String supportedGrantType;
    private boolean isClientConfidential;
    private SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider;
    private SubjectCreator subjectCreator;

    protected RedirectionBasedGrantService(String supportedResponseType, String supportedGrantType, boolean isConfidential) {
        this.supportedResponseType = supportedResponseType;
        this.supportedGrantType = supportedGrantType;
        this.isClientConfidential = isConfidential;
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorize() {
        MultivaluedMap<String, String> params = this.getQueryParameters();
        return this.startAuthorization(params);
    }

    @GET
    @Path(value="/decision")
    public Response authorizeDecision() {
        MultivaluedMap<String, String> params = this.getQueryParameters();
        return this.completeAuthorization(params);
    }

    @POST
    @Path(value="/decision")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizeDecisionForm(MultivaluedMap<String, String> params) {
        return this.completeAuthorization(params);
    }

    protected Response startAuthorization(MultivaluedMap<String, String> params) {
        SecurityContext sc = this.getAndValidateSecurityContext();
        Client client = this.getClient(params);
        String redirectUri = this.validateRedirectUri(client, (String)params.getFirst((Object)"redirect_uri"));
        if (!OAuthUtils.isGrantSupportedForClient(client, this.isClientConfidential, this.supportedGrantType)) {
            return this.createErrorResponse(params, redirectUri, "unauthorized_client");
        }
        String responseType = (String)params.getFirst((Object)"response_type");
        if (responseType == null || !responseType.equals(this.supportedResponseType)) {
            return this.createErrorResponse(params, redirectUri, "unsupported_response_type");
        }
        List<String> requestedScope = OAuthUtils.parseScope((String)params.getFirst((Object)"scope"));
        UserSubject userSubject = this.createUserSubject(sc);
        ServerAccessToken preauthorizedToken = this.getDataProvider().getPreauthorizedToken(client, requestedScope, userSubject, this.supportedGrantType);
        if (preauthorizedToken != null) {
            return this.createGrant(params, client, redirectUri, requestedScope, Collections.<String>emptyList(), userSubject, preauthorizedToken);
        }
        List<OAuthPermission> permissions = null;
        try {
            permissions = this.getDataProvider().convertScopeToPermissions(client, requestedScope);
        }
        catch (OAuthServiceException ex) {
            return this.createErrorResponse(params, redirectUri, "invalid_scope");
        }
        OAuthAuthorizationData data = this.createAuthorizationData(client, params, permissions);
        return Response.ok((Object)data).build();
    }

    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, List<OAuthPermission> perms) {
        OAuthAuthorizationData secData = new OAuthAuthorizationData();
        this.addAuthenticityTokenToSession(secData);
        secData.setPermissions(perms);
        secData.setProposedScope(OAuthUtils.convertPermissionsToScope(perms));
        secData.setClientId(client.getClientId());
        secData.setRedirectUri((String)params.getFirst((Object)"redirect_uri"));
        secData.setState((String)params.getFirst((Object)"state"));
        secData.setApplicationName(client.getApplicationName());
        secData.setApplicationWebUri(client.getApplicationWebUri());
        secData.setApplicationDescription(client.getApplicationDescription());
        secData.setApplicationLogoUri(client.getApplicationLogoUri());
        String replyTo = this.getMessageContext().getUriInfo().getAbsolutePathBuilder().path("decision").build(new Object[0]).toString();
        secData.setReplyTo(replyTo);
        return secData;
    }

    protected Response completeAuthorization(MultivaluedMap<String, String> params) {
        SecurityContext securityContext = this.getAndValidateSecurityContext();
        if (!this.compareRequestAndSessionTokens((String)params.getFirst((Object)"session_authenticity_token"))) {
            throw new BadRequestException();
        }
        Client client = this.getClient(params);
        String redirectUri = this.validateRedirectUri(client, (String)params.getFirst((Object)"redirect_uri"));
        String decision = (String)params.getFirst((Object)"oauthDecision");
        boolean allow = "allow".equals(decision);
        if (!allow) {
            return this.createErrorResponse(params, redirectUri, "access_denied");
        }
        List<String> requestedScope = OAuthUtils.parseScope((String)params.getFirst((Object)"scope"));
        LinkedList<String> approvedScope = new LinkedList<String>();
        for (String rScope : requestedScope) {
            String param = (String)params.getFirst((Object)(rScope + "_status"));
            if (param == null || !"allow".equals(param)) continue;
            approvedScope.add(rScope);
        }
        if (!requestedScope.containsAll(approvedScope)) {
            return this.createErrorResponse(params, redirectUri, "invalid_scope");
        }
        UserSubject userSubject = this.createUserSubject(securityContext);
        return this.createGrant(params, client, redirectUri, requestedScope, approvedScope, userSubject, null);
    }

    public void setSessionAuthenticityTokenProvider(SessionAuthenticityTokenProvider sessionAuthenticityTokenProvider) {
        this.sessionAuthenticityTokenProvider = sessionAuthenticityTokenProvider;
    }

    public void setSubjectCreator(SubjectCreator creator) {
        this.subjectCreator = creator;
    }

    protected UserSubject createUserSubject(SecurityContext securityContext) {
        UserSubject subject = null;
        if (this.subjectCreator != null && (subject = this.subjectCreator.createUserSubject(this.getMessageContext())) != null) {
            return subject;
        }
        subject = this.getMessageContext().getContent(UserSubject.class);
        if (subject != null) {
            return subject;
        }
        return OAuthUtils.createSubject(securityContext);
    }

    protected abstract Response createErrorResponse(MultivaluedMap<String, String> var1, String var2, String var3);

    protected abstract Response createGrant(MultivaluedMap<String, String> var1, Client var2, String var3, List<String> var4, List<String> var5, UserSubject var6, ServerAccessToken var7);

    private SecurityContext getAndValidateSecurityContext() {
        SecurityContext securityContext = (SecurityContext)this.getMessageContext().get(SecurityContext.class.getName());
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw new NotAuthorizedException(Response.status((int)401).build());
        }
        this.checkTransportSecurity();
        return securityContext;
    }

    protected String validateRedirectUri(Client client, String redirectUri) {
        List<String> uris = client.getRedirectUris();
        if (redirectUri != null) {
            String webUri = client.getApplicationWebUri();
            if (uris.size() > 0 && !uris.contains(redirectUri) || webUri != null && !redirectUri.startsWith(webUri)) {
                redirectUri = null;
            }
        } else if (uris.size() == 1) {
            redirectUri = uris.get(0);
        }
        if (redirectUri == null) {
            this.reportInvalidRequestError("Client Redirect Uri is invalid");
        }
        return redirectUri;
    }

    private void addAuthenticityTokenToSession(OAuthAuthorizationData secData) {
        String sessionToken;
        if (this.sessionAuthenticityTokenProvider != null) {
            sessionToken = this.sessionAuthenticityTokenProvider.createSessionToken(this.getMessageContext());
        } else {
            HttpSession session = this.getMessageContext().getHttpServletRequest().getSession();
            sessionToken = UUID.randomUUID().toString();
            session.setAttribute("session_authenticity_token", (Object)sessionToken);
        }
        secData.setAuthenticityToken(sessionToken);
    }

    private boolean compareRequestAndSessionTokens(String requestToken) {
        String sessionToken;
        if (this.sessionAuthenticityTokenProvider != null) {
            sessionToken = this.sessionAuthenticityTokenProvider.removeSessionToken(this.getMessageContext());
        } else {
            HttpSession session = this.getMessageContext().getHttpServletRequest().getSession();
            sessionToken = (String)session.getAttribute("session_authenticity_token");
            if (sessionToken != null) {
                session.removeAttribute("session_authenticity_token");
            }
        }
        if (StringUtils.isEmpty(sessionToken)) {
            return false;
        }
        return requestToken.equals(sessionToken);
    }

    protected Client getClient(MultivaluedMap<String, String> params) {
        Client client;
        block3: {
            client = null;
            try {
                client = this.getValidClient(params);
            }
            catch (OAuthServiceException ex) {
                if (ex.getError() == null) break block3;
                this.reportInvalidRequestError(ex.getError(), null);
            }
        }
        if (client == null) {
            this.reportInvalidRequestError("Client ID is invalid", null);
        }
        return client;
    }
}

