/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.osgi;

import fr.dyade.aaa.common.Debug;
import java.net.ConnectException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminItf;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.osgi.AdminStruct;
import org.objectweb.joram.client.osgi.AdminWrapperHelper;
import org.objectweb.joram.client.osgi.JndiHelper;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class UserMSF
implements ManagedServiceFactory {
    public static final Logger logmon = Debug.getLogger((String)UserMSF.class.getName());
    public static final String ADMIN_WRAPPER = "adminWrapper";
    public static final String ADMIN_HOST = "adminHost";
    public static final String ADMIN_PORT = "adminPort";
    public static final String ADMIN_USERNAME = "adminUser";
    public static final String NAME = "name";
    public static final String PASSWORD = "password";
    public static final String SERVERID = "serverId";
    public static final String IDENTITYCLASS = "identityClassName";
    public static final String SUBNAME = "subName";
    public static final String THRESHOLD = "threshold";
    public static final String NB_MAXMSG = "nbMaxMsg";
    public static final String JNDINAME = "jndiName";
    public static final String DMQ = "dmq";
    public static final String DMQ_SID = "dmqSid";
    private BundleContext bundleContext;
    private ServiceRegistration registration;
    private HashMap<String, User> users;
    private HashMap<String, String> jndiNames;
    private JndiHelper jndiHelper;

    public UserMSF(BundleContext bundleContext) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("UserMSF(" + bundleContext + ')'));
        }
        this.bundleContext = bundleContext;
        Properties props = new Properties();
        props.setProperty("service.pid", UserMSF.class.getName());
        this.registration = this.bundleContext.registerService(ManagedServiceFactory.class.getName(), (Object)this, (Dictionary)props);
        this.users = new HashMap();
        this.jndiHelper = new JndiHelper();
        this.jndiNames = new HashMap();
    }

    private final boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    private void setUserDMQ(AdminItf wrapper, User user, String dmq, int dmqSid) throws ConnectException, AdminException {
        Destination[] destinations;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("setUserDMQ(" + wrapper + ", " + user + ", " + dmq + ", " + dmqSid + ')'));
        }
        if ((destinations = wrapper.getDestinations(dmqSid)) != null) {
            for (int i = 0; i < destinations.length; ++i) {
                if (!(destinations[i] instanceof Queue) || !dmq.equals(destinations[i].getName())) continue;
                user.setDMQ((Queue)destinations[i]);
                return;
            }
        }
        if (logmon.isLoggable(BasicLevel.WARN)) {
            logmon.log(BasicLevel.WARN, (Object)("setDestinationDMQ: the DMQ \"" + dmq + "\" on server \"" + dmqSid + "\" not found."));
        }
    }

    public void doStop() {
    }

    public void doUpdated(String pid, Dictionary properties) {
        block18: {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("doUpdated(" + pid + ", " + properties + ')'));
            }
            try {
                String dmq;
                String jndiName;
                User user = this.users.get(pid);
                String wrapperName = (String)properties.get(ADMIN_WRAPPER);
                String adminHost = (String)properties.get(ADMIN_HOST);
                String adminPort = (String)properties.get(ADMIN_PORT);
                String adminUser = (String)properties.get(ADMIN_USERNAME);
                AdminItf wrapper = AdminWrapperHelper.getWrapper(this.bundleContext, new AdminStruct(wrapperName, adminHost, adminPort, adminUser));
                if (user == null) {
                    String password;
                    String name = (String)properties.get(NAME);
                    if (!this.isSet(name)) {
                        name = "anonymous";
                    }
                    if (!this.isSet(password = (String)properties.get(PASSWORD))) {
                        password = "anonymous";
                    }
                    int sid = 0;
                    String serverId = (String)properties.get(SERVERID);
                    if (this.isSet(serverId)) {
                        sid = new Integer(serverId);
                    } else if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)"doUpdated serverId not set used 0");
                    }
                    String identityClassName = (String)properties.get(IDENTITYCLASS);
                    if (!this.isSet(identityClassName)) {
                        identityClassName = SimpleIdentity.class.getName();
                    }
                    Properties props = new Properties();
                    Enumeration keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        props.setProperty(key, (String)properties.get(key));
                    }
                    user = wrapper.createUser(name, password, sid, identityClassName, props);
                    this.users.put(pid, user);
                }
                String threshold = (String)properties.get(THRESHOLD);
                String subName = (String)properties.get(SUBNAME);
                if (this.isSet(threshold)) {
                    int th = new Integer(threshold);
                    if (this.isSet(subName)) {
                        user.setThreshold(subName, th);
                    } else {
                        user.setThreshold(th);
                    }
                }
                String nbMaxMsg = (String)properties.get(NB_MAXMSG);
                if (this.isSet(subName) && this.isSet(nbMaxMsg)) {
                    user.setNbMaxMsg(subName, new Integer(nbMaxMsg));
                }
                if (this.isSet(jndiName = (String)properties.get(JNDINAME))) {
                    this.jndiHelper.rebind(jndiName, user);
                    this.jndiNames.put(pid, jndiName);
                }
                if (this.isSet(dmq = (String)properties.get(DMQ))) {
                    String dmqSid = (String)properties.get(DMQ_SID);
                    if (!this.isSet(dmqSid)) {
                        dmqSid = "" + wrapper.getLocalServerId();
                    }
                    this.setUserDMQ(wrapper, user, dmq, new Integer(dmqSid));
                }
            }
            catch (Exception e) {
                if (!logmon.isLoggable(BasicLevel.ERROR)) break block18;
                logmon.log(BasicLevel.ERROR, (Object)"doUpdated ", (Throwable)e);
            }
        }
    }

    public String getName() {
        return "UserMSF";
    }

    public void updated(final String pid, final Dictionary properties) throws ConfigurationException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("updated(" + pid + ", " + properties + ')'));
        }
        if (properties == null) {
            this.deleted(pid);
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                UserMSF.this.doUpdated(pid, properties);
            }
        }).start();
    }

    public void deleted(String pid) {
        block6: {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("deleted(" + pid + ')'));
            }
            if (this.users.containsKey(pid)) {
                User user = this.users.remove(pid);
                try {
                    String jndiName;
                    if (user != null) {
                        user.delete();
                    }
                    if ((jndiName = this.jndiNames.remove(pid)) != null) {
                        this.jndiHelper.unbind(jndiName);
                    }
                }
                catch (Exception e) {
                    if (!logmon.isLoggable(BasicLevel.WARN)) break block6;
                    logmon.log(BasicLevel.WARN, (Object)("deleted " + user), (Throwable)e);
                }
            }
        }
    }
}

