/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message.callback;

import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;

public class PasswordValidationCallback
implements Callback {
    private static final long serialVersionUID = -135437753287939796L;
    private Subject theSubject;
    private String theUsername;
    private char[] thePassword;
    private boolean theResult;

    public PasswordValidationCallback(Subject subject, String username, char[] password) {
        this.theSubject = subject;
        this.theUsername = username;
        if (password != null) {
            this.thePassword = (char[])password.clone();
        }
    }

    public Subject getSubject() {
        return this.theSubject;
    }

    public String getUsername() {
        return this.theUsername;
    }

    public char[] getPassword() {
        return this.thePassword;
    }

    public void clearPassword() {
        if (this.thePassword != null) {
            Arrays.fill(this.thePassword, ' ');
        }
    }

    public void setResult(boolean result) {
        this.theResult = result;
    }

    public boolean getResult() {
        return this.theResult;
    }
}

