/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.util.Base64;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.ow2.shelbie.commands.ssh.server.internal.HostKey;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublickeyAuthenticatorImpl
implements PublickeyAuthenticator {
    private static Log log = LogFactory.getLog(PublickeyAuthenticatorImpl.class);
    private final Set<PublicKey> myHostKeys;
    private volatile PeerKeyCache peerKeyCache;
    private final HostKey hostKey;

    public PublickeyAuthenticatorImpl(KeyPairProvider hostKeyProvider, HostKey hostKey) {
        this.myHostKeys = PublickeyAuthenticatorImpl.myHostKeys(hostKeyProvider);
        this.hostKey = hostKey;
        this.peerKeyCache = new PeerKeyCache(hostKey.getPeerKeys());
    }

    private static Set<PublicKey> myHostKeys(KeyPairProvider p) {
        HashSet<PublicKey> keys = new HashSet<PublicKey>(2);
        PublickeyAuthenticatorImpl.addPublicKey(keys, p, "ssh-rsa");
        PublickeyAuthenticatorImpl.addPublicKey(keys, p, "ssh-dss");
        return keys;
    }

    private static void addPublicKey(Collection<PublicKey> out, KeyPairProvider p, String type) {
        KeyPair pair = p.loadKey(type);
        if (pair != null && pair.getPublic() != null) {
            out.add(pair.getPublic());
        }
    }

    @Override
    public boolean authenticate(String username, PublicKey suppliedKey, ServerSession session) {
        return username.equals(this.hostKey.getUser()) && (this.myHostKeys.contains(suppliedKey) || this.getPeerKeys().contains(suppliedKey));
    }

    private Set<PublicKey> getPeerKeys() {
        PeerKeyCache p = this.peerKeyCache;
        if (!p.isCurrent()) {
            this.peerKeyCache = p = p.reload();
        }
        return p.keys;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PeerKeyCache {
        private final File path;
        private final long modified;
        final Set<PublicKey> keys;

        PeerKeyCache(File path) {
            this.path = path;
            this.modified = path.lastModified();
            this.keys = PeerKeyCache.read(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Set<PublicKey> read(File path) {
            Set<PublicKey> set;
            BufferedReader br = new BufferedReader(new FileReader(path));
            try {
                String line;
                HashSet<PublicKey> keys = new HashSet<PublicKey>();
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    String cleanLine = line.startsWith("ssh-rsa ") ? line.substring("ssh-rsa ".length()) : line;
                    try {
                        byte[] bin = Base64.decodeBase64(cleanLine.getBytes());
                        keys.add(new Buffer(bin).getRawPublicKey());
                    }
                    catch (RuntimeException e) {
                        PeerKeyCache.logBadKey(path, cleanLine, e);
                    }
                    catch (SshException e) {
                        PeerKeyCache.logBadKey(path, cleanLine, e);
                    }
                }
                set = Collections.unmodifiableSet(keys);
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                    throw throwable;
                }
                catch (FileNotFoundException noFile) {
                    return Collections.emptySet();
                }
                catch (IOException err) {
                    log.error((Object)("Cannot read " + path), new Object[]{err});
                    return Collections.emptySet();
                }
            }
            br.close();
            return set;
        }

        private static void logBadKey(File path, String line, Exception e) {
            log.warn((Object)("Invalid key in " + path + ":\n  " + line), new Object[]{e});
        }

        boolean isCurrent() {
            return this.path.lastModified() == this.modified;
        }

        PeerKeyCache reload() {
            return new PeerKeyCache(this.path);
        }
    }
}

