/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class UpdateTimestampsCache {
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, UpdateTimestampsCache.class.getName());
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final TimestampsRegion region;
    private final SessionFactoryImplementor factory;

    public UpdateTimestampsCache(Settings settings, Properties props, SessionFactoryImplementor factory) throws HibernateException {
        this.factory = factory;
        String prefix = settings.getCacheRegionPrefix();
        String regionName = prefix == null ? REGION_NAME : prefix + '.' + REGION_NAME;
        LOG.startingUpdateTimestampsCache(regionName);
        this.region = settings.getRegionFactory().buildTimestampsRegion(regionName, props);
    }

    public UpdateTimestampsCache(Settings settings, Properties props) throws HibernateException {
        this(settings, props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preinvalidate(Serializable[] spaces) throws CacheException {
        this.readWriteLock.writeLock().lock();
        try {
            Long ts = this.region.nextTimestamp() + (long)this.region.getTimeout();
            for (Serializable space : spaces) {
                LOG.debugf("Pre-invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
                this.region.put(space, ts);
                if (this.factory == null || !this.factory.getStatistics().isStatisticsEnabled()) continue;
                this.factory.getStatisticsImplementor().updateTimestampsCachePut();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Serializable[] spaces) throws CacheException {
        this.readWriteLock.writeLock().lock();
        try {
            Long ts = this.region.nextTimestamp();
            for (Serializable space : spaces) {
                LOG.debugf("Invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
                this.region.put(space, ts);
                if (this.factory == null || !this.factory.getStatistics().isStatisticsEnabled()) continue;
                this.factory.getStatisticsImplementor().updateTimestampsCachePut();
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate(Set spaces, Long timestamp) throws HibernateException {
        this.readWriteLock.readLock().lock();
        try {
            for (Serializable space : spaces) {
                Long lastUpdate = (Long)this.region.get(space);
                if (lastUpdate == null) {
                    if (this.factory != null && this.factory.getStatistics().isStatisticsEnabled()) {
                        this.factory.getStatisticsImplementor().updateTimestampsCacheMiss();
                    }
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("[%s] last update timestamp: %s", (Object)space, (Object)(lastUpdate + ", result set timestamp: " + timestamp));
                }
                if (this.factory != null && this.factory.getStatistics().isStatisticsEnabled()) {
                    this.factory.getStatisticsImplementor().updateTimestampsCacheHit();
                }
                if (lastUpdate < timestamp) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void clear() throws CacheException {
        this.region.evictAll();
    }

    public void destroy() {
        try {
            this.region.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyUpdateTimestampsCache(this.region.getName(), e.getMessage());
        }
    }

    public TimestampsRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return "UpdateTimestampsCache";
    }
}

