/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.HibernateException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class OptimizerFactory {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, OptimizerFactory.class.getName());
    private static Class[] CTOR_SIG = new Class[]{Class.class, Integer.TYPE};
    @Deprecated
    public static final String NONE = StandardOptimizerDescriptor.NONE.getExternalName();
    @Deprecated
    public static final String HILO = StandardOptimizerDescriptor.HILO.getExternalName();
    @Deprecated
    public static final String LEGACY_HILO = "legacy-hilo";
    @Deprecated
    public static final String POOL = "pooled";
    @Deprecated
    public static final String POOL_LO = "pooled-lo";

    public static boolean isPooledOptimizer(String type) {
        StandardOptimizerDescriptor standardDescriptor = StandardOptimizerDescriptor.fromExternalName(type);
        return standardDescriptor != null && standardDescriptor.isPooled();
    }

    @Deprecated
    public static Optimizer buildOptimizer(String type, Class returnClass, int incrementSize) {
        Class optimizerClass;
        StandardOptimizerDescriptor standardDescriptor = StandardOptimizerDescriptor.fromExternalName(type);
        if (standardDescriptor != null) {
            optimizerClass = standardDescriptor.getOptimizerClass();
        } else {
            try {
                optimizerClass = ReflectHelper.classForName(type);
            }
            catch (Throwable ignore) {
                LOG.unableToLocateCustomOptimizerClass(type);
                return OptimizerFactory.buildFallbackOptimizer(returnClass, incrementSize);
            }
        }
        try {
            Constructor ctor = optimizerClass.getConstructor(CTOR_SIG);
            return (Optimizer)ctor.newInstance(returnClass, incrementSize);
        }
        catch (Throwable ignore) {
            LOG.unableToInstantiateOptimizer(type);
            return OptimizerFactory.buildFallbackOptimizer(returnClass, incrementSize);
        }
    }

    private static Optimizer buildFallbackOptimizer(Class returnClass, int incrementSize) {
        return new NoopOptimizer(returnClass, incrementSize);
    }

    public static Optimizer buildOptimizer(String type, Class returnClass, int incrementSize, long explicitInitialValue) {
        Optimizer optimizer = OptimizerFactory.buildOptimizer(type, returnClass, incrementSize);
        if (InitialValueAwareOptimizer.class.isInstance(optimizer)) {
            ((InitialValueAwareOptimizer)((Object)optimizer)).injectInitialValue(explicitInitialValue);
        }
        return optimizer;
    }

    public static class PooledLoOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;

        public PooledLoOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating pooled optimizer (lo) with [incrementSize={0}; returnClass=]", (Object)incrementSize, (Object)returnClass.getName());
            }
        }

        @Override
        public Serializable generate(AccessCallback callback) {
            if (this.lastSourceValue == null || !this.value.lt(this.lastSourceValue.copy().add(this.incrementSize))) {
                this.lastSourceValue = callback.getNextValue();
                this.value = this.lastSourceValue.copy();
                while (this.value.lt(1L)) {
                    this.value.increment();
                }
            }
            return this.value.makeValueThenIncrement();
        }

        @Override
        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }
    }

    public static class PooledOptimizer
    extends OptimizerSupport
    implements InitialValueAwareOptimizer {
        private IntegralDataTypeHolder hiValue;
        private IntegralDataTypeHolder value;
        private long initialValue = -1L;

        public PooledOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating pooled optimizer with [incrementSize={0}; returnClass={1}]", (Object)incrementSize, (Object)returnClass.getName());
            }
        }

        @Override
        public synchronized Serializable generate(AccessCallback callback) {
            if (this.hiValue == null) {
                this.value = callback.getNextValue();
                if (this.value.lt(1L)) {
                    LOG.pooledOptimizerReportedInitialValue(this.value);
                }
                if (this.initialValue == -1L && this.value.lt(this.incrementSize) || this.value.eq(this.initialValue)) {
                    this.hiValue = callback.getNextValue();
                } else {
                    this.hiValue = this.value;
                    this.value = this.hiValue.copy().subtract(this.incrementSize);
                }
            } else if (!this.hiValue.gt(this.value)) {
                this.hiValue = callback.getNextValue();
                this.value = this.hiValue.copy().subtract(this.incrementSize);
            }
            return this.value.makeValueThenIncrement();
        }

        @Override
        public IntegralDataTypeHolder getLastSourceValue() {
            return this.hiValue;
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }

        @Override
        public void injectInitialValue(long initialValue) {
            this.initialValue = initialValue;
        }
    }

    public static class LegacyHiLoAlgorithmOptimizer
    extends OptimizerSupport {
        private long maxLo;
        private long lo;
        private IntegralDataTypeHolder hi;
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;

        public LegacyHiLoAlgorithmOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating hilo optimizer (legacy) with [incrementSize={0}; returnClass={1}]", (Object)incrementSize, (Object)returnClass.getName());
            }
            this.maxLo = incrementSize;
            this.lo = this.maxLo + 1L;
        }

        @Override
        public synchronized Serializable generate(AccessCallback callback) {
            if (this.lo > this.maxLo) {
                this.lastSourceValue = callback.getNextValue();
                this.lo = this.lastSourceValue.eq(0L) ? 1L : 0L;
                this.hi = this.lastSourceValue.copy().multiplyBy(this.maxLo + 1L);
            }
            this.value = this.hi.copy().add(this.lo++);
            return this.value.makeValue();
        }

        @Override
        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue.copy();
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value;
        }
    }

    public static class HiLoOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder upperLimit;
        private IntegralDataTypeHolder value;

        public HiLoOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
            if (incrementSize < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Creating hilo optimizer with [incrementSize={0}; returnClass={1}]", (Object)incrementSize, (Object)returnClass.getName());
            }
        }

        @Override
        public synchronized Serializable generate(AccessCallback callback) {
            if (this.lastSourceValue == null) {
                this.lastSourceValue = callback.getNextValue();
                while (this.lastSourceValue.lt(1L)) {
                    this.lastSourceValue = callback.getNextValue();
                }
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
                this.value = this.upperLimit.copy().subtract(this.incrementSize);
            } else if (!this.upperLimit.gt(this.value)) {
                this.lastSourceValue = callback.getNextValue();
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
            }
            return this.value.makeValueThenIncrement();
        }

        @Override
        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }

        public IntegralDataTypeHolder getHiValue() {
            return this.upperLimit;
        }
    }

    public static class NoopOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;

        public NoopOptimizer(Class returnClass, int incrementSize) {
            super(returnClass, incrementSize);
        }

        @Override
        public Serializable generate(AccessCallback callback) {
            IntegralDataTypeHolder value = null;
            while (value == null || value.lt(1L)) {
                value = callback.getNextValue();
            }
            this.lastSourceValue = value;
            return value.makeValue();
        }

        @Override
        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        @Override
        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }
    }

    public static abstract class OptimizerSupport
    implements Optimizer {
        protected final Class returnClass;
        protected final int incrementSize;

        protected OptimizerSupport(Class returnClass, int incrementSize) {
            if (returnClass == null) {
                throw new HibernateException("return class is required");
            }
            this.returnClass = returnClass;
            this.incrementSize = incrementSize;
        }

        public final Class getReturnClass() {
            return this.returnClass;
        }

        @Override
        public final int getIncrementSize() {
            return this.incrementSize;
        }
    }

    public static interface InitialValueAwareOptimizer {
        public void injectInitialValue(long var1);
    }

    public static enum StandardOptimizerDescriptor {
        NONE("none", NoopOptimizer.class),
        HILO("hilo", HiLoOptimizer.class),
        LEGACY_HILO("legacy-hilo", LegacyHiLoAlgorithmOptimizer.class),
        POOLED("pooled", PooledOptimizer.class, true),
        POOLED_LO("pooled-lo", PooledLoOptimizer.class, true);

        private final String externalName;
        private final Class<? extends Optimizer> optimizerClass;
        private final boolean isPooled;

        private StandardOptimizerDescriptor(String externalName, Class<? extends Optimizer> optimizerClass) {
            this(externalName, optimizerClass, false);
        }

        private StandardOptimizerDescriptor(String externalName, Class<? extends Optimizer> optimizerClass, boolean pooled) {
            this.externalName = externalName;
            this.optimizerClass = optimizerClass;
            this.isPooled = pooled;
        }

        public String getExternalName() {
            return this.externalName;
        }

        public Class<? extends Optimizer> getOptimizerClass() {
            return this.optimizerClass;
        }

        public boolean isPooled() {
            return this.isPooled;
        }

        public static StandardOptimizerDescriptor fromExternalName(String externalName) {
            if (StringHelper.isEmpty(externalName)) {
                LOG.debug("No optimizer specified, using NONE as default");
                return NONE;
            }
            if (StandardOptimizerDescriptor.NONE.externalName.equals(externalName)) {
                return NONE;
            }
            if (StandardOptimizerDescriptor.HILO.externalName.equals(externalName)) {
                return HILO;
            }
            if (StandardOptimizerDescriptor.LEGACY_HILO.externalName.equals(externalName)) {
                return LEGACY_HILO;
            }
            if (StandardOptimizerDescriptor.POOLED.externalName.equals(externalName)) {
                return POOLED;
            }
            if (StandardOptimizerDescriptor.POOLED_LO.externalName.equals(externalName)) {
                return POOLED_LO;
            }
            LOG.debugf("Unknown optimizer key [%s]; returning null assuming Optimizer impl class name", new Object[0]);
            return null;
        }
    }
}

