/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    private static final Log log = LoggerFactory.make();
    public static final String AUTO_REGISTER = "hibernate.search.autoregister_listeners";
    private FullTextIndexEventListener listener;

    @Override
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        boolean registerListeners = ConfigurationHelper.getBoolean(AUTO_REGISTER, configuration.getProperties(), true);
        if (!registerListeners) {
            log.debug("Skipping Hibernate Search event listener auto registration");
            return;
        }
        this.listener = new FullTextIndexEventListener(FullTextIndexEventListener.Installation.SINGLE_INSTANCE);
        EventListenerRegistry listenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy(new DuplicationStrategyImpl(FullTextIndexEventListener.class));
        listenerRegistry.getEventListenerGroup(EventType.POST_INSERT).appendListener(this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_UPDATE).appendListener(this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_DELETE).appendListener(this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_RECREATE).appendListener(this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_REMOVE).appendListener(this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_UPDATE).appendListener(this.listener);
        listenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener(this.listener);
        this.listener.initialize(configuration);
    }

    @Override
    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (this.listener != null) {
            this.listener.cleanup();
        }
    }

    public static class DuplicationStrategyImpl
    implements DuplicationStrategy {
        private final Class checkClass;

        public DuplicationStrategyImpl(Class checkClass) {
            this.checkClass = checkClass;
        }

        @Override
        public boolean areMatch(Object listener, Object original) {
            return this.checkClass == original.getClass() && this.checkClass == listener.getClass();
        }

        @Override
        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }
}

