/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.CacheFromIndex;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Similarity;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.SearchMapping;

public class MappingModelMetadataProvider
implements MetadataProvider {
    private static final Filter FILTER = new Filter(){

        @Override
        public boolean returnStatic() {
            return false;
        }

        @Override
        public boolean returnTransient() {
            return true;
        }
    };
    private final MetadataProvider delegate;
    private final SearchMapping mapping;
    private final Map<AnnotatedElement, AnnotationReader> cache = new HashMap<AnnotatedElement, AnnotationReader>(100);
    private Map<Object, Object> defaults;

    public MappingModelMetadataProvider(MetadataProvider delegate, SearchMapping mapping) {
        this.delegate = delegate;
        this.mapping = mapping;
    }

    @Override
    public Map<Object, Object> getDefaults() {
        if (this.defaults == null) {
            Map<Object, Object> delegateDefaults = this.delegate.getDefaults();
            this.defaults = delegateDefaults == null ? new HashMap<Object, Object>() : new HashMap<Object, Object>(delegateDefaults);
            this.defaults.put(AnalyzerDefs.class, this.createAnalyzerDefArray());
            if (!this.mapping.getFullTextFilerDefs().isEmpty()) {
                this.defaults.put(FullTextFilterDefs.class, this.createFullTextFilterDefsForMapping());
            }
        }
        return this.defaults;
    }

    @Override
    public AnnotationReader getAnnotationReader(AnnotatedElement annotatedElement) {
        AnnotationReader reader = this.cache.get(annotatedElement);
        if (reader == null) {
            reader = new MappingModelAnnotationReader(this.mapping, this.delegate, annotatedElement);
            this.cache.put(annotatedElement, reader);
        }
        return reader;
    }

    private AnalyzerDef[] createAnalyzerDefArray() {
        ArrayList<String> globalAnalyzerDefNames = new ArrayList<String>();
        AnalyzerDef[] defs = new AnalyzerDef[this.mapping.getAnalyzerDefs().size()];
        int index = 0;
        for (Map<String, Object> analyzerDef : this.mapping.getAnalyzerDefs()) {
            AnalyzerDef def = this.createAnalyzerDef(analyzerDef);
            if (globalAnalyzerDefNames.contains(def.name())) {
                throw new SearchException("Multiple analyzer definitions with the same name: " + def.name());
            }
            globalAnalyzerDefNames.add(def.name());
            defs[index] = def;
            ++index;
        }
        return defs;
    }

    private FullTextFilterDef[] createFullTextFilterDefsForMapping() {
        Set<Map<String, Object>> fullTextFilterDefs = this.mapping.getFullTextFilerDefs();
        FullTextFilterDef[] filters = new FullTextFilterDef[fullTextFilterDefs.size()];
        int index = 0;
        for (Map<String, Object> filterDef : fullTextFilterDefs) {
            filters[index] = MappingModelMetadataProvider.createFullTextFilterDef(filterDef);
            ++index;
        }
        return filters;
    }

    private static FullTextFilterDef createFullTextFilterDef(Map<String, Object> filterDef) {
        AnnotationDescriptor fullTextFilterDefAnnotation = new AnnotationDescriptor(FullTextFilterDef.class);
        for (Map.Entry<String, Object> entry : filterDef.entrySet()) {
            fullTextFilterDefAnnotation.setValue(entry.getKey(), entry.getValue());
        }
        return (FullTextFilterDef)AnnotationFactory.create(fullTextFilterDefAnnotation);
    }

    private static FullTextFilterDef[] createFullTextFilterDefArray(Set<Map<String, Object>> fullTextFilterDefs) {
        FullTextFilterDef[] filters = new FullTextFilterDef[fullTextFilterDefs.size()];
        int index = 0;
        for (Map<String, Object> filterDef : fullTextFilterDefs) {
            filters[index] = MappingModelMetadataProvider.createFullTextFilterDef(filterDef);
            ++index;
        }
        return filters;
    }

    private AnalyzerDef createAnalyzerDef(Map<String, Object> analyzerDef) {
        AnnotationDescriptor analyzerDefAnnotation = new AnnotationDescriptor(AnalyzerDef.class);
        for (Map.Entry<String, Object> entry : analyzerDef.entrySet()) {
            if (entry.getKey().equals("tokenizer")) {
                AnnotationDescriptor tokenizerAnnotation = new AnnotationDescriptor(TokenizerDef.class);
                Map tokenizer = (Map)entry.getValue();
                for (Map.Entry<String, Object> entry2 : tokenizer.entrySet()) {
                    if (((String)entry2.getKey()).equals("params")) {
                        MappingModelMetadataProvider.addParamsToAnnotation(tokenizerAnnotation, entry2);
                        continue;
                    }
                    tokenizerAnnotation.setValue(entry2.getKey(), entry2.getValue());
                }
                analyzerDefAnnotation.setValue("tokenizer", AnnotationFactory.create(tokenizerAnnotation));
                continue;
            }
            if (entry.getKey().equals("filters")) {
                TokenFilterDef[] filtersArray = this.createFilters((List)entry.getValue());
                analyzerDefAnnotation.setValue("filters", filtersArray);
                continue;
            }
            analyzerDefAnnotation.setValue(entry.getKey(), entry.getValue());
        }
        return (AnalyzerDef)AnnotationFactory.create(analyzerDefAnnotation);
    }

    private static void addParamsToAnnotation(AnnotationDescriptor annotationDescriptor, Map.Entry<String, Object> entry) {
        Parameter[] paramsArray = MappingModelMetadataProvider.createParams((List)entry.getValue());
        annotationDescriptor.setValue("params", paramsArray);
    }

    private TokenFilterDef[] createFilters(List<Map<String, Object>> filters) {
        TokenFilterDef[] filtersArray = new TokenFilterDef[filters.size()];
        int index = 0;
        for (Map<String, Object> filter : filters) {
            AnnotationDescriptor filterAnn = new AnnotationDescriptor(TokenFilterDef.class);
            for (Map.Entry<String, Object> filterEntry : filter.entrySet()) {
                if (filterEntry.getKey().equals("params")) {
                    MappingModelMetadataProvider.addParamsToAnnotation(filterAnn, filterEntry);
                    continue;
                }
                filterAnn.setValue(filterEntry.getKey(), filterEntry.getValue());
            }
            filtersArray[index] = (TokenFilterDef)AnnotationFactory.create(filterAnn);
            ++index;
        }
        return filtersArray;
    }

    private static Parameter[] createParams(List<Map<String, Object>> params) {
        Parameter[] paramArray = new Parameter[params.size()];
        int index = 0;
        for (Map<String, Object> entry : params) {
            AnnotationDescriptor paramAnnotation = new AnnotationDescriptor(Parameter.class);
            paramAnnotation.setValue("name", entry.get("name"));
            paramAnnotation.setValue("value", entry.get("value"));
            paramArray[index] = (Parameter)AnnotationFactory.create(paramAnnotation);
            ++index;
        }
        return paramArray;
    }

    private static class MappingModelAnnotationReader
    implements AnnotationReader {
        private AnnotationReader delegate;
        private SearchMapping mapping;
        private transient Annotation[] annotationsArray;
        private transient Map<Class<? extends Annotation>, Annotation> annotations;
        private Class<?> entityType;
        private ElementType elementType;
        private String propertyName;

        public MappingModelAnnotationReader(SearchMapping mapping, MetadataProvider delegate, AnnotatedElement el) {
            this.delegate = delegate.getAnnotationReader(el);
            this.mapping = mapping;
            if (el instanceof Class) {
                this.entityType = (Class)el;
            } else if (el instanceof Field) {
                Field field = (Field)el;
                this.entityType = field.getDeclaringClass();
                this.propertyName = field.getName();
                this.elementType = ElementType.FIELD;
            } else if (el instanceof Method) {
                Method method = (Method)el;
                this.entityType = method.getDeclaringClass();
                this.propertyName = method.getName();
                if (ReflectionUtil.isProperty(method, null, FILTER)) {
                    if (this.propertyName.startsWith("get")) {
                        this.propertyName = Introspector.decapitalize(this.propertyName.substring("get".length()));
                    } else if (this.propertyName.startsWith("is")) {
                        this.propertyName = Introspector.decapitalize(this.propertyName.substring("is".length()));
                    } else {
                        throw new RuntimeException("Method " + this.propertyName + " is not a property getter");
                    }
                    this.elementType = ElementType.METHOD;
                } else {
                    this.entityType = null;
                    this.propertyName = null;
                }
            } else {
                this.entityType = null;
                this.propertyName = null;
            }
        }

        private void initAnnotations() {
            if (this.annotationsArray == null) {
                this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
                this.delegatesAnnotationReading();
                if (this.entityType != null) {
                    EntityDescriptor entity = this.mapping.getEntityDescriptor(this.entityType);
                    if (entity != null) {
                        if (this.propertyName == null) {
                            this.createIndexed(entity);
                        } else {
                            PropertyDescriptor property = entity.getPropertyDescriptor(this.propertyName, this.elementType);
                            if (property != null) {
                                this.createDocumentId(property);
                                this.createAnalyzerDiscriminator(property);
                                this.createFields(property);
                                this.createIndexEmbedded(property);
                                this.createContainedIn(property);
                            }
                        }
                    }
                } else {
                    this.delegatesAnnotationReading();
                }
                this.populateAnnotationArray();
            }
        }

        private void createDateBridge(PropertyDescriptor property) {
            Map<String, Object> map = property.getDateBridge();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                AnnotationDescriptor dateBrigeAnnotation = new AnnotationDescriptor(DateBridge.class);
                dateBrigeAnnotation.setValue(entry.getKey(), entry.getValue());
                this.annotations.put((Class<? extends Annotation>)DateBridge.class, (Annotation)AnnotationFactory.create(dateBrigeAnnotation));
            }
        }

        private void createCalendarBridge(PropertyDescriptor property) {
            Map<String, Object> map = property.getCalendarBridge();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                AnnotationDescriptor calendarBrigeAnnotation = new AnnotationDescriptor(CalendarBridge.class);
                calendarBrigeAnnotation.setValue(entry.getKey(), entry.getValue());
                this.annotations.put((Class<? extends Annotation>)CalendarBridge.class, (Annotation)AnnotationFactory.create(calendarBrigeAnnotation));
            }
        }

        private void createDocumentId(PropertyDescriptor property) {
            Map<String, Object> documentId = property.getDocumentId();
            if (documentId != null) {
                AnnotationDescriptor documentIdAnnotation = new AnnotationDescriptor(DocumentId.class);
                for (Map.Entry<String, Object> entry : documentId.entrySet()) {
                    documentIdAnnotation.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)DocumentId.class, (Annotation)AnnotationFactory.create(documentIdAnnotation));
            }
        }

        private void createAnalyzerDiscriminator(PropertyDescriptor property) {
            Map<String, Object> analyzerDiscriminator = property.getAnalyzerDiscriminator();
            if (analyzerDiscriminator != null) {
                AnnotationDescriptor analyzerDiscriminatorAnn = new AnnotationDescriptor(AnalyzerDiscriminator.class);
                for (Map.Entry<String, Object> entry : analyzerDiscriminator.entrySet()) {
                    analyzerDiscriminatorAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)AnalyzerDiscriminator.class, (Annotation)AnnotationFactory.create(analyzerDiscriminatorAnn));
            }
        }

        private void createFields(PropertyDescriptor property) {
            AnnotationDescriptor fieldAnnotation;
            Collection<Map<String, Object>> fields = property.getFields();
            Collection<Map<String, Object>> numericFields = property.getNumericFields();
            ArrayList<org.hibernate.search.annotations.Field> fieldAnnotations = new ArrayList<org.hibernate.search.annotations.Field>(fields.size());
            ArrayList<NumericField> numericFieldAnnotations = new ArrayList<NumericField>(numericFields.size());
            for (Map<String, Object> numericField : numericFields) {
                fieldAnnotation = new AnnotationDescriptor(NumericField.class);
                for (Map.Entry<String, Object> entry : numericField.entrySet()) {
                    fieldAnnotation.setValue(entry.getKey(), entry.getValue());
                }
                numericFieldAnnotations.add((NumericField)AnnotationFactory.create(fieldAnnotation));
            }
            for (Map<String, Object> field : fields) {
                fieldAnnotation = new AnnotationDescriptor(org.hibernate.search.annotations.Field.class);
                for (Map.Entry<String, Object> entry : field.entrySet()) {
                    if (entry.getKey().equals("analyzer")) {
                        AnnotationDescriptor analyzerAnnotation = new AnnotationDescriptor(Analyzer.class);
                        Map analyzer = (Map)entry.getValue();
                        for (Map.Entry analyzerEntry : analyzer.entrySet()) {
                            analyzerAnnotation.setValue((String)analyzerEntry.getKey(), analyzerEntry.getValue());
                        }
                        fieldAnnotation.setValue("analyzer", AnnotationFactory.create(analyzerAnnotation));
                        continue;
                    }
                    if (entry.getKey().equals("boost")) {
                        AnnotationDescriptor boostAnnotation = new AnnotationDescriptor(Boost.class);
                        Map boost = (Map)entry.getValue();
                        for (Map.Entry boostEntry : boost.entrySet()) {
                            boostAnnotation.setValue((String)boostEntry.getKey(), boostEntry.getValue());
                        }
                        fieldAnnotation.setValue("boost", AnnotationFactory.create(boostAnnotation));
                        continue;
                    }
                    if (entry.getKey().equals("bridge")) {
                        AnnotationDescriptor bridgeAnnotation = new AnnotationDescriptor(FieldBridge.class);
                        Map bridge = (Map)entry.getValue();
                        for (Map.Entry bridgeEntry : bridge.entrySet()) {
                            if (((String)bridgeEntry.getKey()).equals("params")) {
                                MappingModelMetadataProvider.addParamsToAnnotation(bridgeAnnotation, bridgeEntry);
                                continue;
                            }
                            bridgeAnnotation.setValue((String)bridgeEntry.getKey(), bridgeEntry.getValue());
                        }
                        fieldAnnotation.setValue("bridge", AnnotationFactory.create(bridgeAnnotation));
                        continue;
                    }
                    fieldAnnotation.setValue(entry.getKey(), entry.getValue());
                }
                fieldAnnotations.add((org.hibernate.search.annotations.Field)AnnotationFactory.create(fieldAnnotation));
            }
            AnnotationDescriptor fieldsAnnotation = new AnnotationDescriptor(Fields.class);
            AnnotationDescriptor numericFieldsAnnotation = new AnnotationDescriptor(NumericFields.class);
            org.hibernate.search.annotations.Field[] fieldArray = new org.hibernate.search.annotations.Field[fieldAnnotations.size()];
            org.hibernate.search.annotations.Field[] fieldAsArray = fieldAnnotations.toArray(fieldArray);
            NumericField[] numericFieldArray = new NumericField[numericFieldAnnotations.size()];
            NumericField[] numericFieldAsArray = numericFieldAnnotations.toArray(numericFieldArray);
            numericFieldsAnnotation.setValue("value", numericFieldAsArray);
            this.annotations.put((Class<? extends Annotation>)NumericFields.class, (Annotation)AnnotationFactory.create(numericFieldsAnnotation));
            fieldsAnnotation.setValue("value", fieldAsArray);
            this.annotations.put((Class<? extends Annotation>)Fields.class, (Annotation)AnnotationFactory.create(fieldsAnnotation));
            this.createDateBridge(property);
            this.createCalendarBridge(property);
            this.createDynamicBoost(property);
        }

        private void createDynamicBoost(PropertyDescriptor property) {
            if (property.getDynamicBoost() != null) {
                AnnotationDescriptor dynamicBoostAnn = new AnnotationDescriptor(DynamicBoost.class);
                Set<Map.Entry<String, Object>> entrySet = property.getDynamicBoost().entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    dynamicBoostAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)DynamicBoost.class, (Annotation)AnnotationFactory.create(dynamicBoostAnn));
            }
        }

        private void createContainedIn(PropertyDescriptor property) {
            if (property.getContainedIn() != null) {
                Map<String, Object> containedIn = property.getContainedIn();
                AnnotationDescriptor containedInAnn = new AnnotationDescriptor(ContainedIn.class);
                Set<Map.Entry<String, Object>> entrySet = containedIn.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    containedInAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)ContainedIn.class, (Annotation)AnnotationFactory.create(containedInAnn));
            }
        }

        private void createIndexEmbedded(PropertyDescriptor property) {
            Map<String, Object> indexEmbedded = property.getIndexEmbedded();
            if (indexEmbedded != null) {
                AnnotationDescriptor indexEmbeddedAnn = new AnnotationDescriptor(IndexedEmbedded.class);
                Set<Map.Entry<String, Object>> entrySet = indexEmbedded.entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    indexEmbeddedAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)IndexedEmbedded.class, (Annotation)AnnotationFactory.create(indexEmbeddedAnn));
            }
        }

        private void createIndexed(EntityDescriptor entity) {
            AnnotationDescriptor annotation;
            Class<Indexed> annotationType = Indexed.class;
            AnnotationDescriptor annotation2 = new AnnotationDescriptor(annotationType);
            if (entity.getIndexed() != null) {
                for (Map.Entry<String, Object> entry : entity.getIndexed().entrySet()) {
                    annotation2.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)annotationType, (Annotation)AnnotationFactory.create(annotation2));
            }
            if (entity.getSimilarity() != null) {
                annotation = new AnnotationDescriptor(Similarity.class);
                for (Map.Entry<String, Object> entry : entity.getSimilarity().entrySet()) {
                    annotation.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)Similarity.class, (Annotation)AnnotationFactory.create(annotation));
            }
            if (entity.getCacheInMemory() != null) {
                annotation = new AnnotationDescriptor(CacheFromIndex.class);
                for (Map.Entry<String, Object> entry : entity.getCacheInMemory().entrySet()) {
                    annotation.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)CacheFromIndex.class, (Annotation)AnnotationFactory.create(annotation));
            }
            if (entity.getBoost() != null) {
                annotation = new AnnotationDescriptor(Boost.class);
                for (Map.Entry<String, Object> entry : entity.getBoost().entrySet()) {
                    annotation.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)Boost.class, (Annotation)AnnotationFactory.create(annotation));
            }
            if (entity.getAnalyzerDiscriminator() != null) {
                annotation = new AnnotationDescriptor(AnalyzerDiscriminator.class);
                for (Map.Entry<String, Object> entry : entity.getAnalyzerDiscriminator().entrySet()) {
                    annotation.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)AnalyzerDiscriminator.class, (Annotation)AnnotationFactory.create(annotation));
            }
            if (entity.getFullTextFilterDefs().size() > 0) {
                AnnotationDescriptor fullTextFilterDefsAnnotation = new AnnotationDescriptor(FullTextFilterDefs.class);
                FullTextFilterDef[] fullTextFilterDefArray = MappingModelMetadataProvider.createFullTextFilterDefArray(entity.getFullTextFilterDefs());
                fullTextFilterDefsAnnotation.setValue("value", fullTextFilterDefArray);
                this.annotations.put((Class<? extends Annotation>)FullTextFilterDefs.class, (Annotation)AnnotationFactory.create(fullTextFilterDefsAnnotation));
            }
            if (entity.getProvidedId() != null) {
                this.createProvidedId(entity);
            }
            if (entity.getClassBridgeDefs().size() > 0) {
                AnnotationDescriptor classBridgesAnn = new AnnotationDescriptor(ClassBridges.class);
                ClassBridge[] classBridesDefArray = this.createClassBridgesDefArray(entity.getClassBridgeDefs());
                classBridgesAnn.setValue("value", classBridesDefArray);
                this.annotations.put((Class<? extends Annotation>)ClassBridges.class, (Annotation)AnnotationFactory.create(classBridgesAnn));
            }
            if (entity.getDynamicBoost() != null) {
                AnnotationDescriptor dynamicBoostAnn = new AnnotationDescriptor(DynamicBoost.class);
                Set<Map.Entry<String, Object>> entrySet = entity.getDynamicBoost().entrySet();
                for (Map.Entry<String, Object> entry : entrySet) {
                    dynamicBoostAnn.setValue(entry.getKey(), entry.getValue());
                }
                this.annotations.put((Class<? extends Annotation>)DynamicBoost.class, (Annotation)AnnotationFactory.create(dynamicBoostAnn));
            }
        }

        private ClassBridge[] createClassBridgesDefArray(Set<Map<String, Object>> classBridgeDefs) {
            ClassBridge[] classBridgeDefArray = new ClassBridge[classBridgeDefs.size()];
            int index = 0;
            for (Map<String, Object> classBridgeDef : classBridgeDefs) {
                classBridgeDefArray[index] = this.createClassBridge(classBridgeDef);
                ++index;
            }
            return classBridgeDefArray;
        }

        private ClassBridge createClassBridge(Map<String, Object> classBridgeDef) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(ClassBridge.class);
            Set<Map.Entry<String, Object>> entrySet = classBridgeDef.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                if (entry.getKey().equals("params")) {
                    MappingModelMetadataProvider.addParamsToAnnotation(annotation, entry);
                    continue;
                }
                annotation.setValue(entry.getKey(), entry.getValue());
            }
            return (ClassBridge)AnnotationFactory.create(annotation);
        }

        private void createProvidedId(EntityDescriptor entity) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(ProvidedId.class);
            Set<Map.Entry<String, Object>> entrySet = entity.getProvidedId().entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                if (entry.getKey().equals("bridge")) {
                    AnnotationDescriptor bridgeAnnotation = new AnnotationDescriptor(FieldBridge.class);
                    Map bridge = (Map)entry.getValue();
                    for (Map.Entry bridgeEntry : bridge.entrySet()) {
                        if (((String)bridgeEntry.getKey()).equals("params")) {
                            MappingModelMetadataProvider.addParamsToAnnotation(bridgeAnnotation, bridgeEntry);
                            continue;
                        }
                        bridgeAnnotation.setValue((String)bridgeEntry.getKey(), bridgeEntry.getValue());
                    }
                    annotation.setValue("bridge", AnnotationFactory.create(bridgeAnnotation));
                    continue;
                }
                annotation.setValue(entry.getKey(), entry.getValue());
            }
            this.annotations.put((Class<? extends Annotation>)ProvidedId.class, (Annotation)AnnotationFactory.create(annotation));
        }

        private void populateAnnotationArray() {
            this.annotationsArray = new Annotation[this.annotations.size()];
            int index = 0;
            Iterator<Annotation> i$ = this.annotations.values().iterator();
            while (i$.hasNext()) {
                Annotation ann;
                this.annotationsArray[index] = ann = i$.next();
                ++index;
            }
        }

        private void delegatesAnnotationReading() {
            for (Annotation a : this.delegate.getAnnotations()) {
                this.annotations.put(a.annotationType(), a);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            this.initAnnotations();
            return (T)this.annotations.get(annotationType);
        }

        @Override
        public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
            this.initAnnotations();
            return this.annotations.get(annotationType) != null;
        }

        @Override
        public Annotation[] getAnnotations() {
            this.initAnnotations();
            return new Annotation[0];
        }
    }
}

