/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.AllContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class ConnectedAllContext
implements AllContext {
    private final List<BooleanClause> clauses;
    private final QueryCustomizer queryCustomizer = new QueryCustomizer();

    public ConnectedAllContext() {
        this.clauses = new ArrayList<BooleanClause>(5);
        this.clauses.add(new BooleanClause(new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD));
    }

    @Override
    public Query createQuery() {
        Query query;
        if (this.clauses.size() == 1) {
            query = this.clauses.get(0).getQuery();
        } else {
            BooleanQuery booleanQuery = new BooleanQuery();
            for (BooleanClause clause : this.clauses) {
                booleanQuery.add(clause);
            }
            query = booleanQuery;
        }
        return this.queryCustomizer.setWrappedQuery(query).createQuery();
    }

    @Override
    public AllContext except(Query ... queriesMatchingExcludedDocuments) {
        for (Query query : queriesMatchingExcludedDocuments) {
            this.clauses.add(new BooleanClause(query, BooleanClause.Occur.MUST_NOT));
        }
        return this;
    }

    @Override
    public AllContext boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public AllContext withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public AllContext filteredBy(Filter filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }
}

