/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger;

import java.util.LinkedList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.ow2.jonas.audit.internal.logger.AuditLogServiceException;
import org.ow2.jonas.audit.internal.logger.api.IAuditComponentListener;
import org.ow2.jonas.audit.internal.logger.api.IAuditLogListener;
import org.ow2.util.auditreport.impl.jmx.ListeningChecker;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class AuditComponentListener
implements IAuditComponentListener,
NotificationListener {
    private Log logger = LogFactory.getLog(AuditComponentListener.class);
    private MBeanServer jmxServer = null;
    private ObjectName jmxName;
    private int invocations = 0;
    private List<IAuditLogListener> listeners = new LinkedList<IAuditLogListener>();

    public AuditComponentListener(MBeanServer jmxServer) {
        this.jmxServer = jmxServer;
    }

    public final void register(ObjectName jmxName) throws AuditLogServiceException {
        this.jmxName = jmxName;
        try {
            if (this.jmxServer.isRegistered(jmxName)) {
                this.unregister();
                ListeningChecker checker = new ListeningChecker(jmxName, (NotificationListener)this);
                checker.start();
                this.jmxServer.addNotificationListener(jmxName, this, null, null);
            } else {
                this.logger.warn((Object)("The MBean '" + jmxName + "' is not registered"), new Object[0]);
            }
        }
        catch (Exception ex) {
            throw new AuditLogServiceException(ex);
        }
    }

    public final boolean unregister() throws AuditLogServiceException {
        if (this.jmxName == null) {
            return true;
        }
        try {
            if (this.jmxServer.isRegistered(this.jmxName)) {
                this.jmxServer.removeNotificationListener(this.jmxName, this);
            }
        }
        catch (ListenerNotFoundException e) {
            this.logger.debug((Object)"Listener not found when unregistering", new Object[]{e});
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"Listener not found when unregistering", new Object[]{e});
            return false;
        }
        return true;
    }

    public void addLogListener(IAuditLogListener listener) {
        this.listeners.add(listener);
    }

    public void removeLogListener(IAuditLogListener listener) {
        boolean ok = true;
        while (ok) {
            ok = this.listeners.remove(listener);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        String report = notification.getMessage();
        String type = notification.getType();
        for (IAuditLogListener listener : this.listeners) {
            listener.onAuditReceived(type, report);
        }
        ++this.invocations;
    }

    public final int getNbInvocations() {
        return this.invocations;
    }
}

