/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.audit;

import org.ow2.easybeans.api.event.EZBEvent;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationEnd;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationError;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycle;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStarted;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStarting;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStopped;
import org.ow2.easybeans.api.event.lifecycle.EZBEventLifeCycleStopping;
import org.ow2.easybeans.component.audit.jmx.JMXNotifier;
import org.ow2.easybeans.component.audit.report.InvocationAuditReportFactory;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.LifeCycleAuditReport;
import org.ow2.util.auditreport.impl.event.Event;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventDispatcher;

public class Auditor
implements EZBEventListener {
    private String eventProviderFilter = ".*";
    private JMXNotifier jmxNotifier = null;
    private InvocationAuditReportFactory invocationAuditReportFactory = null;
    private boolean lifecycleEnabled = false;
    private IEventService eventService;

    public Auditor(String filter, JMXNotifier jmxNotifier, InvocationAuditReportFactory invocationAuditReportFactory, IEventService eventService) {
        this.eventService = eventService;
        this.eventProviderFilter = filter;
        this.jmxNotifier = jmxNotifier;
        this.invocationAuditReportFactory = invocationAuditReportFactory;
    }

    public void handle(IEvent event) {
        Event eventReport;
        EZBEventBeanInvocationEnd eventEnd;
        EZBEventBeanInvocationBegin e;
        String eventOn = ((EZBEvent)event).getEventProviderId();
        String methodName = eventOn.substring(eventOn.lastIndexOf("/") + 1, eventOn.length());
        EventDispatcher dispatcherEJB = (EventDispatcher)this.eventService.getDispatcher("EJB");
        if (dispatcherEJB == null) {
            dispatcherEJB = new EventDispatcher();
            dispatcherEJB.setNbWorkers(2);
            dispatcherEJB.start();
            this.eventService.registerDispatcher("EJB", (IEventDispatcher)dispatcherEJB);
            dispatcherEJB = (EventDispatcher)this.eventService.getDispatcher("EJB");
        }
        if (EZBEventBeanInvocationBegin.class.isAssignableFrom(event.getClass()) && (e = (EZBEventBeanInvocationBegin)event).getEventProviderId().contains(this.eventProviderFilter)) {
            this.invocationAuditReportFactory.prepareAuditReport(e.getTime(), methodName, Thread.currentThread(), e, e.getEventProviderId(), e.getCallerRoles(), e.getCallerPrincipal());
        }
        if (EZBEventBeanInvocationEnd.class.isAssignableFrom(event.getClass()) && (eventEnd = (EZBEventBeanInvocationEnd)event).getEventProviderId().contains(this.eventProviderFilter)) {
            eventReport = new Event((GenericAuditReport)this.invocationAuditReportFactory.getAuditReport(eventEnd.getTime(), eventEnd, eventEnd.getEventProviderId()));
            dispatcherEJB.dispatch((IEvent)eventReport);
        }
        if (EZBEventBeanInvocationError.class.isAssignableFrom(event.getClass()) && (eventEnd = (EZBEventBeanInvocationError)event).getEventProviderId().contains(this.eventProviderFilter)) {
            eventReport = new Event((GenericAuditReport)this.invocationAuditReportFactory.getAuditReport(eventEnd.getTime(), (EZBEventBeanInvocationError)eventEnd, eventEnd.getEventProviderId()));
            dispatcherEJB.dispatch((IEvent)eventReport);
        }
        if (this.lifecycleEnabled) {
            if (EZBEventLifeCycleStarted.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStarted)event;
                eventReport = new Event((GenericAuditReport)this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STARTED, Thread.currentThread()));
                dispatcherEJB.dispatch((IEvent)eventReport);
            }
            if (EZBEventLifeCycleStarting.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStarting)event;
                eventReport = new Event((GenericAuditReport)this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STARTING, Thread.currentThread()));
                dispatcherEJB.dispatch((IEvent)eventReport);
            }
            if (EZBEventLifeCycleStopped.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStopped)event;
                eventReport = new Event((GenericAuditReport)this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STOPPED, Thread.currentThread()));
                dispatcherEJB.dispatch((IEvent)eventReport);
            }
            if (EZBEventLifeCycleStopping.class.isAssignableFrom(event.getClass())) {
                eventEnd = (EZBEventLifeCycleStopping)event;
                eventReport = new Event((GenericAuditReport)this.getLifeCycleAuditReport((EZBEventLifeCycle)eventEnd, this.eventProviderFilter, LifeCycleAuditReport.STEP.STOPPING, Thread.currentThread()));
                dispatcherEJB.dispatch((IEvent)eventReport);
            }
        }
    }

    public String getEventProviderFilter() {
        return this.eventProviderFilter;
    }

    public boolean accept(IEvent event) {
        try {
            return ((EZBEvent)event).getEventProviderId().contains(this.eventProviderFilter);
        }
        catch (Throwable error) {
            return false;
        }
    }

    public EventPriority getPriority() {
        return EventPriority.ASYNC_LOW;
    }

    public LifeCycleAuditReport getLifeCycleAuditReport(EZBEventLifeCycle event, String beanName, LifeCycleAuditReport.STEP step, Thread current) {
        int freeMemoryBefore = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryBefore = (int)Runtime.getRuntime().totalMemory();
        int freeMemoryAfter = (int)Runtime.getRuntime().freeMemory();
        int totalMemoryAfter = (int)Runtime.getRuntime().totalMemory();
        return new LifeCycleAuditReport(event.getTime(), beanName, step, current, freeMemoryBefore, totalMemoryBefore, freeMemoryAfter, totalMemoryAfter);
    }
}

