/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session;

import java.util.List;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.transaction.Transaction;
import javax.xml.rpc.handler.MessageContext;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.container.EZBSessionContext;
import org.ow2.easybeans.container.EasyBeansEJBContext;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.proxy.helper.ProxyHelper;
import org.ow2.easybeans.proxy.helper.ProxyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansSessionContext<FactoryType extends SessionFactory<?>>
extends EasyBeansEJBContext<FactoryType>
implements EZBSessionContext<FactoryType>,
SessionContext {
    private Transaction beanTransaction = null;
    private Long beanId = null;

    public Transaction getBeanTransaction() {
        return this.beanTransaction;
    }

    public void setBeanTransaction(Transaction beanTransaction) {
        this.beanTransaction = beanTransaction;
    }

    public Long getBeanId() {
        return this.beanId;
    }

    public void setBeanId(Long beanId) {
        this.beanId = beanId;
    }

    public EasyBeansSessionContext(FactoryType factory) {
        super(factory);
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        throw new IllegalStateException("No getEJBLocalObject() method");
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        throw new IllegalStateException("No getEJBObject() method");
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        throw new IllegalStateException("No getMessageContext() method");
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        if (businessInterface == null) {
            throw new IllegalStateException("Invalid business interface '" + businessInterface + "'.");
        }
        String businessInterfaceClassname = businessInterface.getName();
        IBeanInfo beanInfo = ((SessionFactory)this.getFactory()).getBeanInfo();
        List localInterfaces = beanInfo.getLocalInterfaces();
        List remoteInterfaces = beanInfo.getRemoteInterfaces();
        String noInterfaceViewInterface = beanInfo.getNoInterfaceViewInterface();
        if (!(localInterfaces.contains(businessInterfaceClassname) || remoteInterfaces.contains(businessInterfaceClassname) || businessInterfaceClassname.equals(noInterfaceViewInterface))) {
            String optionalInterface = "";
            if (noInterfaceViewInterface != null) {
                optionalInterface = "and No-Interface view '" + noInterfaceViewInterface + "'";
            }
            throw new IllegalStateException("The interface '" + businessInterface + "' is not a valid interface for this bean '" + beanInfo.getName() + "'. Valid Local Interfaces are '" + localInterfaces + "' and remote interfaces '" + remoteInterfaces + "'" + optionalInterface + ".");
        }
        ProxyType proxyType = ProxyType.REMOTE;
        if (businessInterfaceClassname.equals(noInterfaceViewInterface)) {
            proxyType = ProxyType.NO_INTERFACE;
        } else if (localInterfaces.contains(businessInterfaceClassname)) {
            proxyType = ProxyType.LOCAL;
        }
        return ProxyHelper.getProxy(this.getFactory(), businessInterface, proxyType, this.beanId);
    }

    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        String invokedBusinessInterfaceName = (String)((SessionFactory)this.getFactory()).getInvokedBusinessInterfaceNameThreadLocal().get();
        if (invokedBusinessInterfaceName == null) {
            throw new IllegalStateException("This method has not be called through a business interface");
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(invokedBusinessInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the business interface class '" + invokedBusinessInterfaceName + "'.", e);
        }
    }

    public boolean wasCancelCalled() throws IllegalStateException {
        return false;
    }
}

