/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class InheritanceMethodResolver {
    private static final String JAVA_LANG_OBJECT = Type.getInternalName(Object.class);
    private static Log logger = LogFactory.getLog(InheritanceMethodResolver.class);

    private InheritanceMethodResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata classAnnotationMetadata) throws ResolverException {
        InheritanceMethodResolver.addMethodMetadata(classAnnotationMetadata, classAnnotationMetadata, 1);
    }

    private static void addMethodMetadata(EasyBeansEjbJarClassMetadata beanclassAnnotationMetadata, EasyBeansEjbJarClassMetadata visitingClassAnnotationMetadata, int inheritanceLevel) throws ResolverException {
        String superClass = visitingClassAnnotationMetadata.getSuperName();
        if (superClass != null) {
            EasyBeansEjbJarMethodMetadata[] methodsToAnalyze;
            if (superClass.equals(JAVA_LANG_OBJECT)) {
                return;
            }
            EasyBeansEjbJarClassMetadata superClassMetadata = (EasyBeansEjbJarClassMetadata)beanclassAnnotationMetadata.getLinkedClassMetadata(superClass);
            if (superClassMetadata == null) {
                throw new ResolverException("The class " + (Object)((Object)beanclassAnnotationMetadata) + " extends the class " + superClass + "but this class seems to be outside of the ejb-jar");
            }
            for (EasyBeansEjbJarMethodMetadata methodAnnotationMetadata : methodsToAnalyze = superClassMetadata.getMethodMetadataCollection().toArray(new EasyBeansEjbJarMethodMetadata[superClassMetadata.getMethodMetadataCollection().size()])) {
                EasyBeansEjbJarMethodMetadata clonedMethodAnnotationMetadata;
                boolean superMethodIsPrivate;
                if (methodAnnotationMetadata.isInherited() || methodAnnotationMetadata.isPrivateSuperCallGenerated()) continue;
                JMethod method = methodAnnotationMetadata.getJMethod();
                EasyBeansEjbJarMethodMetadata beanMethod = (EasyBeansEjbJarMethodMetadata)beanclassAnnotationMetadata.getMethodMetadata(method);
                boolean bl = superMethodIsPrivate = (method.getAccess() & 2) == 2;
                if (beanMethod != null && superMethodIsPrivate && !visitingClassAnnotationMetadata.isBean()) {
                    clonedMethodAnnotationMetadata = (EasyBeansEjbJarMethodMetadata)methodAnnotationMetadata.clone();
                    JMethod oldMethod = clonedMethodAnnotationMetadata.getJMethod();
                    JMethod newMethod = new JMethod(1, oldMethod.getName() + superClassMetadata.getClassName().replace("/", ""), oldMethod.getDescriptor(), oldMethod.getSignature(), oldMethod.getExceptions());
                    clonedMethodAnnotationMetadata.setJMethod(newMethod);
                    clonedMethodAnnotationMetadata.setPrivateSuperCallGenerated(true, superClassMetadata, 0);
                    clonedMethodAnnotationMetadata.setSuperPrivateMethodName(oldMethod.getName());
                    superClassMetadata.addStandardMethodMetadata((IMethodMetadata)clonedMethodAnnotationMetadata);
                    methodAnnotationMetadata = clonedMethodAnnotationMetadata;
                    beanMethod = (EasyBeansEjbJarMethodMetadata)beanclassAnnotationMetadata.getMethodMetadata(newMethod);
                }
                if (beanMethod != null && !superMethodIsPrivate) continue;
                clonedMethodAnnotationMetadata = (EasyBeansEjbJarMethodMetadata)methodAnnotationMetadata.clone();
                clonedMethodAnnotationMetadata.setClassMetadata((IClassMetadata)beanclassAnnotationMetadata);
                clonedMethodAnnotationMetadata.setPrivateSuperCallGenerated(false, null, 0);
                clonedMethodAnnotationMetadata.setSuperPrivateMethodName(null);
                clonedMethodAnnotationMetadata.setInherited(true, superClassMetadata);
                if (beanMethod == null) {
                    beanclassAnnotationMetadata.addStandardMethodMetadata((IMethodMetadata)clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPostConstruct()) {
                    beanclassAnnotationMetadata.addPostConstructMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPreDestroy()) {
                    beanclassAnnotationMetadata.addPreDestroyMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPostActivate()) {
                    beanclassAnnotationMetadata.addPostActivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (clonedMethodAnnotationMetadata.isPrePassivate()) {
                    beanclassAnnotationMetadata.addPrePassivateMethodMetadata(clonedMethodAnnotationMetadata);
                }
                if (!clonedMethodAnnotationMetadata.isAroundInvoke()) continue;
                beanclassAnnotationMetadata.addAroundInvokeMethodMetadata(clonedMethodAnnotationMetadata);
            }
            InheritanceMethodResolver.addMethodMetadata(beanclassAnnotationMetadata, superClassMetadata, ++inheritanceLevel);
        }
    }
}

