/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.helper.listener;

import java.lang.constant.Constable;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.ow2.easybeans.deployment.helper.listener.AbstractExtensionListener;
import org.ow2.easybeans.event.naming.JavaContextNamingEvent;
import org.ow2.util.ee.metadata.common.api.struct.IEnvEntry;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EnvEntriesExtensionListener
extends AbstractExtensionListener {
    private Log logger = LogFactory.getLog(EnvEntriesExtensionListener.class);

    public boolean accept(IEvent event) {
        JavaContextNamingEvent namingEvent;
        return event instanceof JavaContextNamingEvent && "java:".equals((namingEvent = (JavaContextNamingEvent)event).getEventProviderId());
    }

    public void handle(IEvent event) {
        JavaContextNamingEvent javaContextNamingEvent = (JavaContextNamingEvent)event;
        String beanName = javaContextNamingEvent.getFactory().getBeanInfo().getName();
        Context javaContext = javaContextNamingEvent.getJavaContext();
        Context javaCompEnvCtx = null;
        try {
            javaCompEnvCtx = (Context)javaContext.lookup("comp/env");
        }
        catch (NamingException e) {
            this.throwException(javaContextNamingEvent, new IllegalStateException("Cannot lookup java:comp/env element.", e));
        }
        Context javaModuleCtx = null;
        try {
            javaModuleCtx = (Context)javaContext.lookup("module");
        }
        catch (NamingException e) {
            this.throwException(javaContextNamingEvent, new IllegalStateException("Cannot lookup java:module element.", e));
        }
        Context javaAppCtx = null;
        try {
            javaAppCtx = (Context)javaContext.lookup("app");
        }
        catch (NamingException e) {
            this.throwException(javaContextNamingEvent, new IllegalStateException("Cannot lookup java:app element.", e));
        }
        Context javaGlobalCtx = null;
        try {
            javaGlobalCtx = (Context)javaContext.lookup("global");
        }
        catch (NamingException e) {
            this.throwException(javaContextNamingEvent, new IllegalStateException("Cannot lookup java:global element.", e));
        }
        for (IEnvEntry envEntry : javaContextNamingEvent.getBeanMetadata().getEnvEntryCollection()) {
            String name = envEntry.getName();
            Object value = this.getEnvEntryValue(envEntry, javaContextNamingEvent);
            if (value == null) continue;
            Context bindContext = javaCompEnvCtx;
            if (name != null && name.startsWith("java:")) {
                if (name.startsWith("java:module/")) {
                    bindContext = javaModuleCtx;
                    name = name.substring("java:module/".length());
                } else if (name.startsWith("java:app/")) {
                    bindContext = javaAppCtx;
                    name = name.substring("java:app/".length());
                } else if (name.startsWith("java:global/")) {
                    bindContext = javaGlobalCtx;
                    name = name.substring("java:global/".length());
                } else if (name.startsWith("java:comp/env/")) {
                    bindContext = javaCompEnvCtx;
                    name = name.substring("java:comp/env/".length());
                } else {
                    this.throwException(javaContextNamingEvent, new IllegalStateException("Invalid Env Entry name '" + name + "' for bean '" + beanName + "'."));
                }
            }
            try {
                bindContext.rebind(name, value);
            }
            catch (NamingException e) {
                this.throwException(javaContextNamingEvent, new IllegalStateException("Cannot bind element '" + name + "' for bean '" + beanName + "'.", e));
            }
        }
    }

    private Object getEnvEntryValue(IEnvEntry envEntry, JavaContextNamingEvent event) {
        String type = envEntry.getType();
        String value = envEntry.getValue();
        String lookupName = envEntry.getLookupName();
        Constable returnedValue = null;
        if (lookupName != null) {
            return new LinkRef(lookupName);
        }
        if (Boolean.class.getName().equals(type)) {
            if (value != null) {
                returnedValue = "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
            }
        } else if (String.class.getName().equals(type)) {
            returnedValue = value;
        } else if (Integer.class.getName().equals(type)) {
            if (value != null) {
                returnedValue = new Integer(value);
            }
        } else if (Character.class.getName().equals(type)) {
            if (value != null) {
                if (value.length() != 1) {
                    this.throwException(event, new IllegalStateException("The value '" + value + "' is not a valid value for env-entry of type java.lang.Character."));
                }
                returnedValue = Character.valueOf(value.charAt(0));
            }
        } else if (Double.class.getName().equals(type)) {
            if (value != null) {
                returnedValue = new Double(value);
            }
        } else if (Byte.class.getName().equals(type)) {
            if (value != null) {
                returnedValue = new Byte(value);
            }
        } else if (Short.class.getName().equals(type)) {
            if (value != null) {
                returnedValue = new Short(value);
            }
        } else if (Long.class.getName().equals(type)) {
            if (value != null) {
                returnedValue = new Long(value);
            }
        } else if (Float.class.getName().equals(type)) {
            if (value != null) {
                returnedValue = new Float(value);
            }
        } else if (Class.class.getName().equals(type)) {
            if (value != null) {
                try {
                    returnedValue = event.getFactory().getContainer().getClassLoader().loadClass(value);
                }
                catch (ClassNotFoundException e) {
                    this.throwException(event, new IllegalStateException("Unable to load the class '" + value + "' for env-entry '" + envEntry.getName() + "' of Bean '" + event.getFactory().getBeanInfo().getName() + "'.", e));
                }
            }
        } else {
            if (value != null) {
                Class<?> clazz = null;
                try {
                    ?[] constants;
                    clazz = event.getFactory().getContainer().getClassLoader().loadClass(type);
                    if (clazz.isEnum() && (constants = clazz.getEnumConstants()) != null && constants.length > 1) {
                        boolean found = false;
                        for (int i = 0; !found && i < constants.length; ++i) {
                            String constant = constants[i].toString();
                            if (!value.equals(constant)) continue;
                            found = true;
                            return constants[i];
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    this.logger.debug((Object)"Unable to load type for value ''{0}'' ", new Object[]{value, e});
                }
            }
            if (value != null) {
                this.throwException(event, new IllegalStateException(type + " is not a valid type for env-entry '" + envEntry.getName() + "'."));
            }
        }
        return returnedValue;
    }
}

