/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.ejbinwar;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.AbsArchiveImpl;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBInWarArchive
extends AbsArchiveImpl
implements IArchive {
    private static final String WEB_INF = "WEB-INF/";
    private static final String WEB_INF_EJBJAR_XML = "WEB-INF/".concat("ejb-jar.xml");
    private static final String WEB_INF_EASYBEANS_XML = "WEB-INF/".concat("easybeans.xml");
    public static final String META_INF_EJBJAR_XML = "META-INF/ejb-jar.xml";
    public static final String META_INF_EASYBEANS_XML = "META-INF/easybeans.xml";
    private static final String WEB_INF_CLASSES = "WEB-INF/".concat("classes");
    private static final String WEB_INF_LIB = "WEB-INF/".concat("lib");
    private static final String JAR_SUFFIX = ".jar";
    private static final String CLASS_SUFFIX = ".class";
    private IArchive wrappedWarArchive = null;
    private Map<String, URL> entries = null;

    public EJBInWarArchive(IArchive wrappedWarArchive) throws ArchiveException {
        this.wrappedWarArchive = wrappedWarArchive;
        this.entries = new HashMap<String, URL>();
        this.init();
    }

    public void init() throws ArchiveException {
        Iterator itEntries = this.wrappedWarArchive.getEntries();
        while (itEntries.hasNext()) {
            URL url;
            String wrappedEntry = (String)itEntries.next();
            if (WEB_INF_EJBJAR_XML.equals(wrappedEntry)) {
                this.addEntry(META_INF_EJBJAR_XML, this.wrappedWarArchive.getResource(wrappedEntry));
            }
            if (WEB_INF_EASYBEANS_XML.equals(wrappedEntry)) {
                this.addEntry(META_INF_EASYBEANS_XML, this.wrappedWarArchive.getResource(wrappedEntry));
            }
            if (META_INF_EASYBEANS_XML.equals(wrappedEntry)) {
                this.addEntry(META_INF_EASYBEANS_XML, this.wrappedWarArchive.getResource(wrappedEntry));
            }
            if (!wrappedEntry.startsWith(WEB_INF)) continue;
            if (wrappedEntry.startsWith(WEB_INF_CLASSES)) {
                this.addEntry(wrappedEntry.substring(WEB_INF_CLASSES.length() + 1), this.wrappedWarArchive.getResource(wrappedEntry));
            }
            if (!wrappedEntry.startsWith(WEB_INF_LIB) || !wrappedEntry.endsWith(JAR_SUFFIX) || !"file".equals((url = this.wrappedWarArchive.getResource(wrappedEntry)).getProtocol())) continue;
            File lib = URLUtils.urlToFile((URL)url);
            IArchive libArchive = ArchiveManager.getInstance().getArchive((Object)lib);
            Iterator libIterator = libArchive.getEntries();
            while (libIterator.hasNext()) {
                String libEntry = (String)libIterator.next();
                if (!libEntry.endsWith(CLASS_SUFFIX)) continue;
                this.addEntry(libEntry, libArchive.getResource(libEntry));
            }
        }
    }

    protected void addEntry(String name, URL wrappedEntry) throws ArchiveException {
        this.entries.put(name, wrappedEntry);
    }

    public boolean close() {
        return this.wrappedWarArchive.close();
    }

    public Iterator<String> getEntries() throws ArchiveException {
        return this.entries.keySet().iterator();
    }

    public String getName() {
        return "EJBInWar[".concat(this.wrappedWarArchive.getName()).concat("]");
    }

    public URL getResource(String resourceName) throws ArchiveException {
        return this.entries.get(resourceName);
    }

    public Iterator<URL> getResources() throws ArchiveException {
        return this.entries.values().iterator();
    }

    public Iterator<URL> getResources(String resourceName) throws ArchiveException {
        ArrayList<URL> lst = new ArrayList<URL>();
        URL url = this.entries.get(resourceName);
        if (url != null) {
            lst.add(url);
        }
        return lst.iterator();
    }

    public URL getURL() throws ArchiveException {
        return this.wrappedWarArchive.getURL();
    }

    public IArchive getWrappedWarArchive() {
        return this.wrappedWarArchive;
    }
}

