/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.interceptor.EZBInterceptorInvoker;
import org.ow2.easybeans.api.interceptor.EZBInterceptorManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicInvocationContextImpl
implements EasyBeansInvocationContext {
    private static final Log LOGGER = LogFactory.getLog(DynamicInvocationContextImpl.class);
    private volatile Map<String, Object> contextData;
    private Object[] parameters;
    private EasyBeansBean instance;
    private Object timer;
    private List<EZBInterceptorInvoker> interceptorInvokerList;
    private Method method = null;
    private int index;
    private EZBInterceptorManager interceptorManager;
    private boolean isLifeCycleMode = false;
    private volatile Map<String, Object> oldContextData = null;

    public DynamicInvocationContextImpl(EasyBeansBean instance, List<EZBInterceptorInvoker> interceptorInvokerList, EZBInterceptorManager interceptorManager, boolean isLifeCycleMode, Method method, Object ... parameters) {
        LOGGER.debug((Object)"Creating DynamicInvocationContextImpl for instance ''{0}'', interceptor Invoker list ''{1}'', interceptor manager ''{2}'', method ''{3}'', parameters ''{4}''", new Object[]{instance, interceptorInvokerList, interceptorManager, method, Arrays.asList(parameters)});
        this.index = 0;
        this.instance = instance;
        this.interceptorInvokerList = interceptorInvokerList;
        this.interceptorManager = interceptorManager;
        this.isLifeCycleMode = isLifeCycleMode;
        this.method = method;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        Object object;
        block4: {
            if (this.index == this.interceptorInvokerList.size()) {
                this.index = this.interceptorInvokerList.size() - 1;
            }
            if (this.index == 0 && this.getFactory() != null) {
                this.oldContextData = (Map)this.getFactory().getContextDataThreadLocal().get();
                this.getFactory().getContextDataThreadLocal().set(this.getContextData());
            }
            try {
                object = this.interceptorInvokerList.get(this.index++).invoke((EasyBeansInvocationContext)this, this.interceptorManager);
                Object var3_2 = null;
                if (this.index != this.interceptorInvokerList.size() || this.getFactory() == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var3_3 = null;
                    if (this.index != this.interceptorInvokerList.size() || this.getFactory() == null) break block5;
                    this.getFactory().getContextDataThreadLocal().set(this.oldContextData);
                }
                throw throwable;
            }
            this.getFactory().getContextDataThreadLocal().set(this.oldContextData);
        }
        return object;
    }

    public Factory<?, ?> getFactory() {
        return this.instance.getEasyBeansFactory();
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Method getMethod() {
        if (this.isLifeCycleMode) {
            return null;
        }
        return this.method;
    }

    public Object[] getParameters() {
        if (this.isLifeCycleMode) {
            throw new IllegalStateException("getParameters method shouldn't be called on lifecycle interceptors");
        }
        return this.getInternalParameters();
    }

    protected Object[] getInternalParameters() {
        return this.parameters;
    }

    public Object getTarget() {
        return this.instance;
    }

    public Object getTimer() {
        return this.timer;
    }

    public void setParameters(Object[] parameters) {
        if (this.isLifeCycleMode) {
            throw new IllegalStateException("setParameters method shouldn't be called on lifecycle interceptors");
        }
        Class<?>[] types = this.method.getParameterTypes();
        if (types.length > 0 && parameters == null) {
            throw new IllegalArgumentException("Invalid null argument. Expecting '" + types + "' and got '" + parameters + "'.");
        }
        if (types.length != parameters.length) {
            throw new IllegalArgumentException("Invalid size of the parameters. Expecting '" + types + "' and got '" + parameters + "'.");
        }
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = this.convertType(types[i]);
            if (parameters[i] == null || type.isAssignableFrom(parameters[i].getClass())) continue;
            throw new IllegalArgumentException("Expecting '" + types + "' and got '" + parameters + "'.");
        }
        this.parameters = parameters;
    }

    private Class<?> convertType(Class<?> clazz) {
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        return clazz;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[");
        int j = 1;
        for (EZBInterceptorInvoker invoker : this.interceptorInvokerList) {
            sb.append("\n  [").append(j).append("/").append(this.interceptorInvokerList.size()).append("] = ").append(invoker);
            if (j == this.index) {
                sb.append("  <-- current");
            }
            ++j;
        }
        sb.append("]");
        return sb.toString();
    }
}

