/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.injection;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.ow2.easybeans.api.EZBStatefulSessionFactory;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.persistence.api.EZBExtendedEntityManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class EntityManagerHelper {
    private static Log logger = LogFactory.getLog(EntityManagerHelper.class);

    private EntityManagerHelper() {
    }

    public static EntityManager getEntityManager(EZBEJBContext ejbContext, String unitName, PersistenceContextType type, EasyBeansBean bean) {
        Factory factory = ejbContext.getFactory();
        EZBPersistenceUnitManager persistenceUnitManager = factory.getContainer().getPersistenceUnitManager();
        if (persistenceUnitManager != null) {
            if (PersistenceContextType.EXTENDED == type) {
                if (factory instanceof EZBStatefulSessionFactory) {
                    Map extendedPersistenceContexts = factory.getContainer().getCurrentExtendedPersistenceContexts();
                    if (extendedPersistenceContexts == null) {
                        throw new IllegalStateException("Extended PersistenceContexts map shouldn't be empty for stateful on factory + " + factory.getClassName() + "'.");
                    }
                    EZBExtendedEntityManager extendedEntityManager = (EZBExtendedEntityManager)extendedPersistenceContexts.get(unitName);
                    if (extendedEntityManager != null) {
                        extendedEntityManager.addUsage();
                    } else {
                        extendedEntityManager = (EZBExtendedEntityManager)persistenceUnitManager.getEntityManager(unitName, type);
                        extendedPersistenceContexts.put(unitName, extendedEntityManager);
                    }
                    EasyBeansSFSB statefulSessionBean = (EasyBeansSFSB)bean;
                    EZBStatefulSessionFactory statefulFactory = (EZBStatefulSessionFactory)factory;
                    statefulFactory.addExtendedPersistenceContext(statefulSessionBean, extendedEntityManager);
                    return extendedEntityManager;
                }
                logger.warn((Object)"Requested an EntityManager with an extended mode but factory {0} is not a stateful so no extended mode available.", new Object[]{factory});
            }
            return persistenceUnitManager.getEntityManager(unitName, type);
        }
        logger.warn((Object)"Requested an EntityManager object but there is no persistenceUnitManager associated to this bean/interceptor : {0}", new Object[]{factory});
        return null;
    }

    public static EntityManagerFactory getEntityManagerFactory(EZBEJBContext ejbContext, String unitName) {
        Factory factory = ejbContext.getFactory();
        EZBPersistenceUnitManager persistenceUnitManager = factory.getContainer().getPersistenceUnitManager();
        if (persistenceUnitManager != null) {
            return persistenceUnitManager.getEntityManagerFactory(unitName);
        }
        logger.warn((Object)"Requested an EntityManagerFactory but there is no persistenceUnitManager associated to this bean/interceptor : {0}", new Object[]{factory});
        return null;
    }
}

