/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.ow2.easybeans.naming.ORBInitHelper;
import org.ow2.easybeans.naming.context.ContextImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class NamingManager {
    private static final String COMP_SUBCONTEXT = "comp";
    private static final String ENV_SUBCONTEXT = "env";
    private static final String APP_SUBCONTEXT = "app";
    private static final String MODULE_SUBCONTEXT = "module";
    private static final String GLOBAL_SUBCONTEXT = "global";
    private static Log logger = LogFactory.getLog(NamingManager.class);
    private static ThreadLocal<Context> threadContext = new ThreadLocal();
    private InitialContext ictx = new InitialContext();
    private static Context clientCtx = null;
    private static NamingManager unique = null;
    private UserTransaction userTransaction = null;

    private NamingManager() throws NamingException {
    }

    public static synchronized NamingManager getInstance() throws NamingException {
        if (unique == null) {
            unique = new NamingManager();
        }
        return unique;
    }

    public InitialContext getInitialContext() {
        return this.ictx;
    }

    public Context createEnvironmentContext(String namespace, Context envContext, Context moduleContext, Context appContext) throws NamingException {
        ContextImpl ctx = new ContextImpl(namespace);
        ContextImpl compCtx = (ContextImpl)ctx.createSubcontext(COMP_SUBCONTEXT);
        if (envContext != null) {
            compCtx.addBinding(ENV_SUBCONTEXT, envContext);
        } else {
            compCtx.createSubcontext(ENV_SUBCONTEXT);
        }
        ctx.addBinding(GLOBAL_SUBCONTEXT, this.ictx);
        if (moduleContext != null) {
            ctx.addBinding(MODULE_SUBCONTEXT, moduleContext);
        } else {
            ctx.addBinding(MODULE_SUBCONTEXT, new ContextImpl("moduleContext"));
        }
        Context appCtx = null;
        appCtx = appContext == null ? new ContextImpl("appContext") : appContext;
        ctx.addBinding(APP_SUBCONTEXT, appCtx);
        if (this.userTransaction == null) {
            try {
                this.userTransaction = (UserTransaction)this.ictx.lookup("javax.transaction.UserTransaction");
            }
            catch (NamingException e) {
                logger.error((Object)"Cannot lookup UserTransaction.", new Object[]{e});
            }
        }
        if (this.userTransaction != null) {
            compCtx.rebind("UserTransaction", (Object)this.userTransaction);
        }
        try {
            compCtx.rebind("ORB", (Object)ORBInitHelper.getORB());
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot bind ORB", new Object[]{e});
        }
        return ctx;
    }

    public Context getComponentContext() throws NamingException {
        Context ctx = null;
        ctx = threadContext.get();
        if (ctx != null) {
            return ctx;
        }
        if (clientCtx != null && (ctx = clientCtx) != null) {
            return ctx;
        }
        throw new NamingException("No java: context for components running outside EasyBeans.");
    }

    public Context setComponentContext(Context ctx) {
        Context ret = threadContext.get();
        threadContext.set(ctx);
        return ret;
    }

    public void resetComponentContext(Context ctx) {
        threadContext.set(ctx);
    }

    public static void setClientContainerComponentContext(Context ctx) {
        clientCtx = ctx;
    }
}

