/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.ow2.easybeans.persistence.JPersistenceContext;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitManager
implements EZBPersistenceUnitManager {
    private Map<String, JPersistenceContext> persistenceContexts = null;
    private JPersistenceUnitInfo[] persistenceUnitInfos;

    public PersistenceUnitManager(JPersistenceUnitInfo[] persistenceUnitInfos) {
        this.persistenceUnitInfos = persistenceUnitInfos;
        this.persistenceContexts = new HashMap<String, JPersistenceContext>();
        this.addExtraPersistenceUnitInfos(persistenceUnitInfos);
    }

    public void addExtraPersistenceUnitInfos(JPersistenceUnitInfo[] newPersistenceUnitInfos) {
        if (newPersistenceUnitInfos != null) {
            for (JPersistenceUnitInfo pUnitInfo : newPersistenceUnitInfos) {
                String persistenceUnitName = pUnitInfo.getPersistenceUnitName();
                JPersistenceContext jPersistenceContext = this.persistenceContexts.get(persistenceUnitName);
                if (jPersistenceContext != null) {
                    throw new IllegalArgumentException("There is already an existing persistence unit name named '" + persistenceUnitName + "' in this persistence unit manager.");
                }
                this.persistenceContexts.put(persistenceUnitName, new JPersistenceContext(pUnitInfo));
            }
        }
    }

    private JPersistenceContext getPersistenceContext(String unitName) {
        if (unitName == null || unitName.equals("")) {
            if (this.persistenceContexts.size() == 0) {
                throw new IllegalArgumentException("No persistence-unit defined");
            }
            if (this.persistenceContexts.size() > 1) {
                throw new IllegalArgumentException("Too many persistence-unit defined, cannot take the default one.");
            }
            return this.persistenceContexts.values().iterator().next();
        }
        JPersistenceContext persistenceContext = this.persistenceContexts.get(unitName);
        if (persistenceContext == null) {
            throw new IllegalArgumentException("No persistence-unit with name '" + unitName + "' defined.");
        }
        return persistenceContext;
    }

    public EntityManager getEntityManager(String unitName, PersistenceContextType type) {
        if (PersistenceContextType.EXTENDED == type) {
            return this.getPersistenceContext(unitName).getExtendedEntityManager();
        }
        return this.getPersistenceContext(unitName).getTxEntityManager();
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName) {
        return this.getPersistenceContext(unitName).getEntityManagerFactory();
    }

    public void merge(EZBPersistenceUnitManager otherEZBPersistenceUnitManager) {
        if (otherEZBPersistenceUnitManager == null) {
            return;
        }
        PersistenceUnitManager otherPersistenceUnitManager = null;
        if (!(otherEZBPersistenceUnitManager instanceof PersistenceUnitManager)) {
            return;
        }
        otherPersistenceUnitManager = (PersistenceUnitManager)otherEZBPersistenceUnitManager;
        for (String unitName : otherPersistenceUnitManager.persistenceContexts.keySet()) {
            JPersistenceContext pContext = this.persistenceContexts.get(unitName);
            if (pContext != null) continue;
            this.persistenceContexts.put(unitName, otherPersistenceUnitManager.persistenceContexts.get(unitName));
        }
    }

    public JPersistenceUnitInfo[] getPersistenceUnitInfos() {
        return this.persistenceUnitInfos;
    }

    public void setProperty(String name, String value) {
        this.setProperty(name, value, null);
    }

    public void setProperty(String name, String value, String persistenceUnitName) {
        JPersistenceUnitInfo[] persistenceUnitInfos;
        for (JPersistenceUnitInfo persistenceUnitInfo : persistenceUnitInfos = this.getPersistenceUnitInfos()) {
            if (persistenceUnitName == null) {
                persistenceUnitInfo.getProperties().setProperty(name, value);
                continue;
            }
            if (!persistenceUnitInfo.getPersistenceUnitName().equals(persistenceUnitName)) continue;
            persistenceUnitInfo.getProperties().setProperty(name, value);
        }
    }

    public Map<String, String> getProperty(String name) {
        JPersistenceUnitInfo[] persistenceUnitInfos;
        HashMap<String, String> properties = new HashMap<String, String>();
        for (JPersistenceUnitInfo persistenceUnitInfo : persistenceUnitInfos = this.getPersistenceUnitInfos()) {
            if (persistenceUnitInfo.getProperties().getProperty(name) == null) continue;
            properties.put(persistenceUnitInfo.getPersistenceUnitName(), persistenceUnitInfo.getProperties().getProperty(name));
        }
        return properties;
    }
}

