/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.EmbeddedManager;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.container.managedbean.ManagedBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            RefAddr embeddedIDAddr = ref.get("embeddedID");
            RefAddr containerIDAddr = ref.get("containerID");
            RefAddr factoryNameAddr = ref.get("factoryName");
            Integer embeddedID = Integer.valueOf((String)embeddedIDAddr.getContent());
            String containerID = (String)containerIDAddr.getContent();
            String factoryName = (String)factoryNameAddr.getContent();
            return this.getFactory(embeddedID, containerID, factoryName).getObjectInstance();
        }
        throw new IllegalStateException("Can only build object with a reference");
    }

    private ManagedBeanFactory getFactory(Integer embeddedID, String containerId, String factoryName) {
        EZBServer ejb3Server = EmbeddedManager.getEmbedded((Integer)embeddedID);
        if (ejb3Server == null) {
            throw new IllegalStateException("Cannot find the server with id '" + embeddedID + "'.");
        }
        EZBContainer container = ejb3Server.getContainer(containerId);
        if (container == null) {
            throw new IllegalStateException("Cannot find the container with id '" + containerId + "'.");
        }
        Factory factory = container.getFactory(factoryName);
        if (factory == null) {
            throw new IllegalStateException("Cannot find the factory with name '" + factoryName + "'.");
        }
        if (!(factory instanceof ManagedBeanFactory)) {
            throw new IllegalStateException("'" + factoryName + "' is not a ManagedBeanFactory as expected.");
        }
        return (ManagedBeanFactory)factory;
    }
}

