/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.expression.BinaryOperatorExpression;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.predicate.ImplicitNumericExpressionTypeDeterminer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryArithmeticOperation<N extends Number>
extends ExpressionImpl<N>
implements BinaryOperatorExpression<N>,
Serializable {
    private final Operation operator;
    private final Expression<? extends N> rhs;
    private final Expression<? extends N> lhs;

    public static Class<? extends Number> determineResultType(Class<? extends Number> argument1Type, Class<? extends Number> argument2Type) {
        return BinaryArithmeticOperation.determineResultType(argument1Type, argument2Type, false);
    }

    public static Class<? extends Number> determineResultType(Class<? extends Number> argument1Type, Class<? extends Number> argument2Type, boolean isQuotientOperation) {
        if (isQuotientOperation) {
            return Number.class;
        }
        return ImplicitNumericExpressionTypeDeterminer.determineResultType(argument1Type, argument2Type);
    }

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Expression<? extends Number> expression) {
        return expression == null || expression.getJavaType() == null ? defaultType : expression.getJavaType();
    }

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Number numberLiteral) {
        return numberLiteral == null ? defaultType : numberLiteral.getClass();
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> resultType, Operation operator, Expression<? extends N> lhs, Expression<? extends N> rhs) {
        super(criteriaBuilder, resultType);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> javaType, Operation operator, Expression<? extends N> lhs, N rhs) {
        super(criteriaBuilder, javaType);
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = new LiteralExpression<N>(criteriaBuilder, rhs);
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> javaType, Operation operator, N lhs, Expression<? extends N> rhs) {
        super(criteriaBuilder, javaType);
        this.operator = operator;
        this.lhs = new LiteralExpression<N>(criteriaBuilder, lhs);
        this.rhs = rhs;
    }

    public Operation getOperator() {
        return this.operator;
    }

    @Override
    public Expression<? extends N> getRightHandOperand() {
        return this.rhs;
    }

    @Override
    public Expression<? extends N> getLeftHandOperand() {
        return this.lhs;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getRightHandOperand(), registry);
        ParameterContainer.Helper.possibleParameter(this.getLeftHandOperand(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.getOperator().apply(((Renderable)this.getLeftHandOperand()).render(renderingContext), ((Renderable)this.getRightHandOperand()).render(renderingContext));
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        ADD{

            String apply(String lhs, String rhs) {
                return Operation.applyPrimitive(lhs, '+', rhs);
            }
        }
        ,
        SUBTRACT{

            String apply(String lhs, String rhs) {
                return Operation.applyPrimitive(lhs, '-', rhs);
            }
        }
        ,
        MULTIPLY{

            String apply(String lhs, String rhs) {
                return Operation.applyPrimitive(lhs, '*', rhs);
            }
        }
        ,
        DIVIDE{

            String apply(String lhs, String rhs) {
                return Operation.applyPrimitive(lhs, '/', rhs);
            }
        }
        ,
        QUOT{

            String apply(String lhs, String rhs) {
                return Operation.applyPrimitive(lhs, '/', rhs);
            }
        }
        ,
        MOD{

            String apply(String lhs, String rhs) {
                return "mod(" + lhs + "," + rhs + ")";
            }
        };

        private static final char LEFT_PAREN = '(';
        private static final char RIGHT_PAREN = ')';

        abstract String apply(String var1, String var2);

        private static String applyPrimitive(String lhs, char operator, String rhs) {
            return new StringBuffer(lhs.length() + rhs.length() + 3).append('(').append(lhs).append(operator).append(rhs).append(')').toString();
        }
    }
}

