/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.ow2.jonas.lib.loader.xml.FiltersDefinition;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.IPropertyResolver;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringClassLoader
extends URLClassLoader {
    public static final String CLASSLOADER_FILTERING_FILE = "classloader-filtering.xml";
    public static final String XML_FILE = "classloader-default-filtering.xml";
    public static final String MAPPING_FILE = "classloader-default-filtering-mapping.xml";
    public static final String DISABLE_FILTERING_PROPERTY_NAME = "jonas-disable-filtering-class-loader";
    private static Log logger = LogFactory.getLog(FilteringClassLoader.class);
    private boolean transparent = false;
    private boolean started = false;
    private URL definitionUrl;
    private List<String> filters = null;

    public FilteringClassLoader(ClassLoader parentClassLoader) {
        super(new URL[0], parentClassLoader);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        if (!this.started) {
            this.transparent = transparent;
        }
    }

    public URL getDefinitionUrl() {
        return this.definitionUrl;
    }

    public void setDefinitionUrl(URL definitionUrl) {
        if (!this.started) {
            this.definitionUrl = definitionUrl;
        }
    }

    public void start() {
        this.started = true;
        if (!this.transparent && Boolean.getBoolean(DISABLE_FILTERING_PROPERTY_NAME)) {
            this.transparent = true;
            logger.debug((Object)"FilteringClassLoader has been disabled.", new Object[0]);
        }
        if (!this.transparent && this.definitionUrl != null) {
            this.loadFilters();
        }
    }

    private void loadFilters() {
        XMLConfiguration xmlConfiguration = new XMLConfiguration(MAPPING_FILE);
        xmlConfiguration.addConfigurationFile(this.definitionUrl);
        xmlConfiguration.setPropertyResolver((IPropertyResolver)new SystemPropertyResolver());
        HashMap contextualInstances = new HashMap();
        xmlConfiguration.setContextualInstances(contextualInstances);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FilteringClassLoader.class.getClassLoader());
            xmlConfiguration.configure((Object)this);
        }
        catch (XMLConfigurationException e) {
            throw new IllegalArgumentException("Cannot configure the Filters inside the Filtering Classloader", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.verifyFilters();
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.isFiltered(name)) {
            throw new ClassNotFoundException("The class '" + name + "' is a filtered class so it cannot be found in the Application Server classloader." + " The class should be added into the application classloader.");
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if (this.isFiltered(name)) {
            logger.debug((Object)"The resource ''{0}'' has been asked but as it is a filtered resource, return null", new Object[]{name});
            return null;
        }
        return super.getResource(name);
    }

    protected boolean isFiltered(String name) {
        if (this.transparent || name == null || this.filters == null) {
            return false;
        }
        for (String pattern : this.filters) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public List<String> getFilters() {
        ArrayList<String> clone = new ArrayList<String>();
        if (this.filters != null) {
            clone.addAll(this.filters);
        }
        return clone;
    }

    public void setFiltersDefinition(FiltersDefinition filtersDefinition) {
        this.filters = filtersDefinition.getFilters();
    }

    protected void verifyFilters() {
        if (this.filters != null) {
            Iterator<String> it = this.filters.iterator();
            while (it.hasNext()) {
                String filter = it.next();
                if (!"*".equals(filter)) continue;
                logger.warn((Object)("The '*' filter is not a valid value for a filter for definition file '" + this.definitionUrl + "'."), new Object[0]);
                it.remove();
            }
        }
    }
}

