/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.MessageDestinationRef;

public class WebAnnotationSet {
    private static final String SEPARATOR = "/";

    public static void loadApplicationAnnotations(Context context) {
        WebAnnotationSet.loadApplicationListenerAnnotations(context);
        WebAnnotationSet.loadApplicationFilterAnnotations(context);
        WebAnnotationSet.loadApplicationServletAnnotations(context);
    }

    protected static void loadApplicationListenerAnnotations(Context context) {
        Class<?> classClass = null;
        String[] applicationListeners = context.findApplicationListeners();
        for (int i = 0; i < applicationListeners.length; ++i) {
            classClass = WebAnnotationSet.loadClass(context, applicationListeners[i]);
            if (classClass == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, classClass);
            WebAnnotationSet.loadFieldsAnnotation(context, classClass);
            WebAnnotationSet.loadMethodsAnnotation(context, classClass);
        }
    }

    protected static void loadApplicationFilterAnnotations(Context context) {
        Class<?> classClass = null;
        FilterDef[] filterDefs = context.findFilterDefs();
        for (int i = 0; i < filterDefs.length; ++i) {
            classClass = WebAnnotationSet.loadClass(context, filterDefs[i].getFilterClass());
            if (classClass == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, classClass);
            WebAnnotationSet.loadFieldsAnnotation(context, classClass);
            WebAnnotationSet.loadMethodsAnnotation(context, classClass);
        }
    }

    protected static void loadApplicationServletAnnotations(Context context) {
        Wrapper wrapper = null;
        Class<?> classClass = null;
        Container[] children = context.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Wrapper) || (wrapper = (Wrapper)children[i]).getServletClass() == null || (classClass = WebAnnotationSet.loadClass(context, wrapper.getServletClass())) == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, classClass);
            WebAnnotationSet.loadFieldsAnnotation(context, classClass);
            WebAnnotationSet.loadMethodsAnnotation(context, classClass);
            if (!classClass.isAnnotationPresent(RunAs.class)) continue;
            RunAs annotation = classClass.getAnnotation(RunAs.class);
            wrapper.setRunAs(annotation.value());
        }
    }

    protected static void loadClassAnnotation(Context context, Class<?> classClass) {
        int i;
        Resource annotation;
        if (classClass.isAnnotationPresent(Resource.class)) {
            annotation = classClass.getAnnotation(Resource.class);
            WebAnnotationSet.addResource(context, annotation);
        }
        if (classClass.isAnnotationPresent(Resources.class)) {
            annotation = classClass.getAnnotation(Resources.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                WebAnnotationSet.addResource(context, annotation.value()[i]);
            }
        }
        if (classClass.isAnnotationPresent(DeclareRoles.class)) {
            annotation = classClass.getAnnotation(DeclareRoles.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                context.addSecurityRole(annotation.value()[i]);
            }
        }
    }

    protected static void loadFieldsAnnotation(Context context, Class<?> classClass) {
        Field[] fields = WebAnnotationSet.getDeclaredFields(classClass);
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Resource.class)) continue;
                Resource annotation = field.getAnnotation(Resource.class);
                String defaultName = classClass.getName() + SEPARATOR + field.getName();
                String defaultType = field.getType().getCanonicalName();
                WebAnnotationSet.addResource(context, annotation, defaultName, defaultType);
            }
        }
    }

    protected static void loadMethodsAnnotation(Context context, Class<?> classClass) {
        Method[] methods = WebAnnotationSet.getDeclaredMethods(classClass);
        if (methods != null && methods.length > 0) {
            for (Method method : methods) {
                if (!method.isAnnotationPresent(Resource.class)) continue;
                Resource annotation = method.getAnnotation(Resource.class);
                WebAnnotationSet.checkBeanNamingConventions(method);
                String defaultName = classClass.getName() + SEPARATOR + DefaultInstanceManager.getName(method);
                String defaultType = method.getParameterTypes()[0].getCanonicalName();
                WebAnnotationSet.addResource(context, annotation, defaultName, defaultType);
            }
        }
    }

    protected static void addResource(Context context, Resource annotation) {
        WebAnnotationSet.addResource(context, annotation, null, null);
    }

    protected static void addResource(Context context, Resource annotation, String defaultName, String defaultType) {
        String name = WebAnnotationSet.getName(annotation, defaultName);
        String type = WebAnnotationSet.getType(annotation, defaultType);
        if (type.equals("java.lang.String") || type.equals("java.lang.Character") || type.equals("java.lang.Integer") || type.equals("java.lang.Boolean") || type.equals("java.lang.Double") || type.equals("java.lang.Byte") || type.equals("java.lang.Short") || type.equals("java.lang.Long") || type.equals("java.lang.Float")) {
            ContextEnvironment resource = new ContextEnvironment();
            resource.setName(name);
            resource.setType(type);
            resource.setDescription(annotation.description());
            resource.setValue(annotation.mappedName());
            context.getNamingResources().addEnvironment(resource);
        } else if (type.equals("javax.xml.rpc.Service")) {
            ContextService service = new ContextService();
            service.setName(name);
            service.setWsdlfile(annotation.mappedName());
            service.setType(type);
            service.setDescription(annotation.description());
            context.getNamingResources().addService(service);
        } else if (type.equals("javax.sql.DataSource") || type.equals("javax.jms.ConnectionFactory") || type.equals("javax.jms.QueueConnectionFactory") || type.equals("javax.jms.TopicConnectionFactory") || type.equals("javax.mail.Session") || type.equals("java.net.URL") || type.equals("javax.resource.cci.ConnectionFactory") || type.equals("org.omg.CORBA_2_3.ORB") || type.endsWith("ConnectionFactory")) {
            ContextResource resource = new ContextResource();
            resource.setName(name);
            resource.setType(type);
            if (annotation.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                resource.setAuth("Container");
            } else if (annotation.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                resource.setAuth("Application");
            }
            resource.setScope(annotation.shareable() ? "Shareable" : "Unshareable");
            resource.setProperty("mappedName", annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResource(resource);
        } else if (type.equals("javax.jms.Queue") || type.equals("javax.jms.Topic")) {
            MessageDestinationRef resource = new MessageDestinationRef();
            resource.setName(name);
            resource.setType(type);
            resource.setUsage(annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addMessageDestinationRef(resource);
        } else {
            if (type.equals("javax.resource.cci.InteractionSpec") || !type.equals("javax.transaction.UserTransaction")) {
                // empty if block
            }
            ContextResourceEnvRef resource = new ContextResourceEnvRef();
            resource.setName(name);
            resource.setType(type);
            resource.setProperty("mappedName", annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResourceEnvRef(resource);
        }
    }

    private static void checkBeanNamingConventions(Method method) {
        if (!method.getName().startsWith("set") || method.getName().length() < 4 || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation.");
        }
    }

    private static String getType(Resource annotation, String defaultType) {
        String type = annotation.type().getCanonicalName();
        if ((type == null || type.equals("java.lang.Object")) && defaultType != null) {
            type = defaultType;
        }
        return type;
    }

    private static String getName(Resource annotation, String defaultName) {
        String name = annotation.name();
        if ((name == null || name.equals("")) && defaultName != null) {
            name = defaultName;
        }
        return name;
    }

    private static Field[] getDeclaredFields(Class<?> classClass) {
        Field[] fields = null;
        if (Globals.IS_SECURITY_ENABLED) {
            final Class<?> clazz = classClass;
            fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                @Override
                public Field[] run() {
                    return clazz.getDeclaredFields();
                }
            });
        } else {
            fields = classClass.getDeclaredFields();
        }
        return fields;
    }

    private static Method[] getDeclaredMethods(Class<?> classClass) {
        Method[] methods = null;
        if (Globals.IS_SECURITY_ENABLED) {
            final Class<?> clazz = classClass;
            methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    return clazz.getDeclaredMethods();
                }
            });
        } else {
            methods = classClass.getDeclaredMethods();
        }
        return methods;
    }

    private static Class<?> loadClass(Context context, String fileString) {
        ClassLoader classLoader = context.getLoader().getClassLoader();
        Class<?> classClass = null;
        try {
            classClass = classLoader.loadClass(fileString);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        return classClass;
    }
}

