/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.loader.WebappLoader;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.loader.FilteringClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.web.tomcat7.JOnASNamingResources;
import org.ow2.jonas.web.tomcat7.Tomcat7Service;
import org.ow2.jonas.web.tomcat7.loader.NoSystemAccessWebappClassLoader;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASStandardContext
extends StandardContext {
    private static final long serialVersionUID = 1L;
    private static transient Tomcat7Service catalinaService = null;
    private static Log logger = LogFactory.getLog(JOnASStandardContext.class);
    private URL earURL = null;
    private boolean inEarCase = false;
    private boolean inServerXml = false;
    private boolean java2DelegationModel = false;
    private WebContainerDeploymentDesc webDeploymentDescriptor = null;
    private String jonasDeploymentDescriptor = null;
    private boolean startedJStdx = false;
    private URL warURL = null;
    private String earON = null;
    private ClassLoader ejbClassLoader = null;
    private ClassLoader earClassLoader = null;
    private FilteringClassLoader filteringClassLoader = null;
    private Map<String, Map<String, String>> injectionsMap = null;
    private Context envContext = null;
    private NamingResources namingResources = null;

    public JOnASStandardContext() {
        this(true, true, false);
    }

    public JOnASStandardContext(boolean inServerXml, boolean java2DelegationModel, boolean inEarCase) {
        this.inServerXml = inServerXml;
        this.java2DelegationModel = java2DelegationModel;
        this.inEarCase = inEarCase;
    }

    public void setTomcatService(Tomcat7Service tomcat) {
        catalinaService = tomcat;
    }

    public URL getEarURL() {
        return this.earURL;
    }

    public WebContainerDeploymentDesc getWebDeploymentDescriptor() {
        return this.webDeploymentDescriptor;
    }

    public String getJonasDeploymentDescriptor() {
        return this.jonasDeploymentDescriptor;
    }

    public URL getWarURL() {
        return this.warURL;
    }

    public boolean isInEarCase() {
        return this.inEarCase;
    }

    public boolean isInServerXml() {
        return this.inServerXml;
    }

    public boolean isJava2DelegationModel() {
        return this.java2DelegationModel;
    }

    protected void setEarURL(URL earURL) {
        this.earURL = earURL;
        ObjectName j2eeAppOn = null;
        String appName = this.getJ2EEApplication();
        String serverON = this.getServer();
        if (appName != null && serverON != null) {
            try {
                ObjectName serverOn = ObjectName.getInstance(serverON);
                String domainName = serverOn.getDomain();
                String serverName = serverOn.getKeyProperty("name");
                j2eeAppOn = J2eeObjectName.J2EEApplication((String)domainName, (String)serverName, (String)appName);
            }
            catch (MalformedObjectNameException e) {
                logger.error((Object)"Cannot build the ObjectName for the context ''{0}''", new Object[]{e});
            }
        }
        if (j2eeAppOn != null) {
            this.earON = j2eeAppOn.toString();
        }
    }

    protected void setInEarCase(boolean inEarCase) {
        this.inEarCase = inEarCase;
    }

    protected void setJava2DelegationModel(boolean java2DelegationModel) {
        this.java2DelegationModel = java2DelegationModel;
    }

    public void setWebDeploymentDescriptor(WebContainerDeploymentDesc webDeploymentDescriptor) {
        this.webDeploymentDescriptor = webDeploymentDescriptor;
    }

    public void setJonasDeploymentDescriptor(String jonasDeploymentDescriptor) {
        this.jonasDeploymentDescriptor = jonasDeploymentDescriptor;
    }

    protected void setWarURL(URL warURL) {
        this.warURL = warURL;
    }

    @Override
    public synchronized void startInternal() throws LifecycleException {
        if (catalinaService != null && catalinaService.isTomcatStarted()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Tomcat in Web container service is started, starting the context...", new Object[0]);
            }
            this.startedJStdx = true;
            super.startInternal();
        }
    }

    @Override
    public synchronized void stopInternal() throws LifecycleException {
        if (this.startedJStdx) {
            this.startedJStdx = false;
            super.stopInternal();
        }
    }

    public void addResource(ContextResource resource) {
    }

    public void addEnvironment(ContextEnvironment environment) {
    }

    @Override
    public void addMessageDestinationRef(MessageDestinationRef mdr) {
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        if (!this.startedJStdx) {
            super.setParentClassLoader(parent);
        }
    }

    public String getEarON() {
        return this.earON;
    }

    @Override
    public String getWorkDir() {
        String superWorkDir = super.getWorkDir();
        if (superWorkDir == null) {
            String temp;
            String hostName = null;
            String engineName = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                hostName = parentHost.getName();
                Container parentEngine = parentHost.getParent();
                if (parentEngine != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            superWorkDir = catalinaService.getServerProperties().getWorkDirectory() + File.separator + "tomcat" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            new File(superWorkDir).mkdirs();
            super.setWorkDir(superWorkDir);
        }
        return superWorkDir;
    }

    @Override
    public void setLoader(Loader loader) {
        if (loader instanceof WebappLoader) {
            ((WebappLoader)loader).setLoaderClass(NoSystemAccessWebappClassLoader.class.getName());
        }
        super.setLoader(loader);
    }

    public void setEnvContext(Context envContext) {
        this.envContext = envContext;
    }

    public void setInjectionMap(Map<String, Map<String, String>> injectionsMap) {
        this.injectionsMap = injectionsMap;
    }

    public ClassLoader getEjbClassLoader() {
        return this.ejbClassLoader;
    }

    public void setEjbClassLoader(ClassLoader ejbClassLoader) {
        this.ejbClassLoader = ejbClassLoader;
    }

    public void setEarClassLoader(ClassLoader earClassLoader) {
        this.earClassLoader = earClassLoader;
    }

    public String loadClass(String className) {
        Transformer transformer;
        if (!this.startedJStdx) {
            throw new IllegalStateException("Cannot load a class if context is not started");
        }
        JClassLoader systemClassLoader = null;
        try {
            systemClassLoader = LoaderManager.getInstance().getExternalLoader();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get LoaderManager", e);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot build document builder", e);
        }
        Document document = builder.newDocument();
        Element classElement = document.createElement("class");
        document.appendChild(classElement);
        classElement.setAttribute("name", className);
        boolean classNotFound = false;
        String error = null;
        ClassLoader webAppClassLoader = this.getLoader().getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = webAppClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            error = e.toString();
            classNotFound = true;
        }
        catch (Error e) {
            classNotFound = true;
            error = e.toString();
        }
        classElement.setAttribute("classNotFound", Boolean.toString(classNotFound));
        if (classNotFound) {
            Element errorElement = document.createElement("error");
            classElement.appendChild(errorElement);
            Text errorText = document.createTextNode(error);
            errorElement.appendChild(errorText);
        } else {
            String type = "Application/WebApp (This module)";
            ClassLoader classClassLoader = clazz.getClassLoader();
            boolean found = false;
            for (ClassLoader cl = webAppClassLoader; cl != null && !found; cl = cl.getParent()) {
                if (cl.equals(classClassLoader)) {
                    found = true;
                }
                if (systemClassLoader.equals(cl)) {
                    type = "System";
                }
                if (cl.equals(this.earClassLoader)) {
                    type = "Application/EAR";
                }
                if (!cl.equals(this.ejbClassLoader)) continue;
                type = "Application/EJBs";
            }
            classElement.setAttribute("where", type);
            if (classClassLoader != null) {
                Element classLoaderElement = document.createElement("class-loader");
                classElement.appendChild(classLoaderElement);
                classLoaderElement.setAttribute("name", classClassLoader.getClass().getName());
                Text classLoaderText = document.createTextNode(classClassLoader.toString());
                classLoaderElement.appendChild(classLoaderText);
            }
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Unable to get a new transformer", e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Unable to transform the document", e);
        }
        return stringWriter.toString();
    }

    public String[] getClassLoaderFilters() {
        List filters = this.filteringClassLoader.getFilters();
        return filters.toArray(new String[filters.size()]);
    }

    public URL[] getResources(String resourceName) {
        if (!this.startedJStdx) {
            throw new IllegalStateException("Cannot load a resource if context is not started");
        }
        ClassLoader webAppClassLoader = this.getLoader().getClassLoader();
        Enumeration<URL> urls = null;
        try {
            urls = webAppClassLoader.getResources(resourceName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get the resource '" + resourceName + "'.", e);
        }
        ArrayList<URL> urlsList = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            urlsList.add(urls.nextElement());
        }
        return urlsList.toArray(new URL[urlsList.size()]);
    }

    public void setFilteringClassLoader(FilteringClassLoader filteringClassLoader) {
        this.filteringClassLoader = filteringClassLoader;
    }

    @Override
    public String getRealPath(String path) {
        if (path != null && path.startsWith("bundle")) {
            return null;
        }
        return super.getRealPath(path);
    }

    @Override
    public NamingResources getNamingResources() {
        if (this.namingResources == null) {
            this.namingResources = new JOnASNamingResources();
            this.setNamingResources(this.namingResources);
        }
        return super.getNamingResources();
    }

    @Override
    public void loadOnStartup(Container[] children) {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (Container aChildren : children) {
            Wrapper wrapper = (Wrapper)aChildren;
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            Integer key = loadOnStartup;
            ArrayList<Wrapper> list = (ArrayList<Wrapper>)map.get(key);
            if (list == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (ArrayList list : map.values()) {
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    Throwable rootCause = StandardWrapper.getRootCause(e);
                    this.getLogger().error(sm.getString("standardWrapper.loadException", this.getName()), rootCause);
                    Object o = this.getServletContext().getAttribute("jonas.tomcat.load.on.startup.preserve.exceptions");
                    if (o == null || !(o instanceof Collection) || ((Collection)o).isEmpty() || !(((Collection)o).iterator().next() instanceof Class)) continue;
                    Collection exceptions = (Collection)o;
                    for (Class exception : exceptions) {
                        if (!exception.isAssignableFrom(rootCause.getClass())) continue;
                        throw new RuntimeException(rootCause);
                    }
                }
            }
        }
    }
}

