/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.osgi.Activator;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.naming.NamingException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.connector.JoramResourceAdapter;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.ConnectionMetaData;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminItf;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.JoramAdmin;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public final class JoramAdapter
extends JoramResourceAdapter
implements JoramAdapterMBean,
ExceptionListener {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)JoramAdapter.class.getName());
    private boolean isActive = false;
    private long adminDurationState = 0L;
    private JoramAdmin wrapper = null;
    private ServerDesc serverDesc = null;
    private ServiceRegistration registration;
    boolean collocated = false;
    boolean startJoramServer = false;
    String hostName = "localhost";
    int serverPort = -1;
    String rootName = "root";
    String rootPasswd = "root";
    String identityClass = SimpleIdentity.class.getName();
    short serverId = 0;
    private String storage = "s0";
    private String platformConfigDir;
    private String adminFileXML = null;
    private String adminFileExportXML = "joramAdminExport.xml";
    public int connectingTimer = 0;

    public void setCollocated(Boolean collocated) {
        this.collocated = collocated;
    }

    public Boolean getCollocated() {
        return new Boolean(this.collocated);
    }

    public void setStartJoramServer(Boolean startJoramServer) {
        this.startJoramServer = startJoramServer;
    }

    public Boolean getStartJoramServer() {
        return new Boolean(this.startJoramServer);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Integer getServerPort() {
        return new Integer(this.serverPort);
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rn) {
        this.rootName = rn;
    }

    public String getRootPasswd() {
        return this.rootPasswd;
    }

    public void setRootPasswd(String rp) {
        this.rootPasswd = rp;
    }

    public String getIdentityClass() {
        return this.identityClass;
    }

    public void setIdentityClass(String identityClass) {
        this.identityClass = identityClass;
    }

    public Short getServerId() {
        return new Short(this.serverId);
    }

    public void setServerId(Short serverId) {
        this.serverId = serverId;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public String getPlatformConfigDir() {
        return this.platformConfigDir;
    }

    public void setPlatformConfigDir(String platformConfigDir) {
        this.platformConfigDir = platformConfigDir;
    }

    public String getAdminFileXML() {
        return this.adminFileXML;
    }

    public void setAdminFileXML(String adminFileXML) {
        this.adminFileXML = adminFileXML;
    }

    public String getAdminFileExportXML() {
        return this.adminFileExportXML;
    }

    public void setAdminFileExportXML(String adminFileExportXML) {
        this.adminFileExportXML = adminFileExportXML;
    }

    public Integer getConnectingTimer() {
        return new Integer(this.connectingTimer);
    }

    public void setConnectingTimer(Integer connectingTimer) {
        this.connectingTimer = connectingTimer;
    }

    public JoramAdapter() {
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM adapter instantiated.");
        }
    }

    public JoramAdapter(MBeanServer jmxServer) {
        super(jmxServer);
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM adapter instantiated.");
        }
    }

    private boolean isJoramServerRun() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("isJoramServerRun status = " + AgentServer.getStatusInfo()));
        }
        return AgentServer.getStatus() == 3 || AgentServer.getStatus() == 4;
    }

    private void waitAgentServerStarted() throws ResourceAdapterInternalException {
        block8: {
            try {
                if (Activator.context != null) {
                    ServiceTracker serviceTracker = new ServiceTracker(Activator.context, ServerDesc.class.getName(), null);
                    serviceTracker.open();
                    this.serverDesc = (ServerDesc)serviceTracker.waitForService(10000L);
                    serviceTracker.close();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block8;
                logger.log(BasicLevel.DEBUG, (Object)("waitAgentServerStarted::" + Activator.context), (Throwable)e);
            }
        }
        int i = 0;
        while (AgentServer.getStatus() != 4) {
            try {
                if (i == 10) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    buff.append("\nThe Joram collocated server is not started !");
                    buff.append("\nA Joram running server is required to start the resource adapter.");
                    buff.append("\nThe Joram server status is : " + AgentServer.getStatusInfo() + "\n");
                    buff.append("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
                    if (logger.isLoggable(BasicLevel.ERROR)) {
                        logger.log(BasicLevel.ERROR, (Object)buff.toString());
                    }
                    throw new ResourceAdapterInternalException(buff.toString());
                }
                Thread.sleep(1000L);
                ++i;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public synchronized void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.setWorkManager(ctx.getWorkManager());
        this.start();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void start() throws ResourceAdapterInternalException {
        block38: {
            block37: {
                block36: {
                    super.start();
                    this.status.value = 1;
                    if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                        JoramAdapter.logger.log(BasicLevel.INFO, (Object)("JORAM adapter:: Start the Joram server : " + this.startJoramServer));
                    }
                    joramPort = null;
                    if (this.startJoramServer) {
                        if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                            JoramAdapter.logger.log(BasicLevel.INFO, (Object)"JORAM adapter starting deployment...");
                        }
                        if (this.isJoramServerRun()) {
                            throw new ResourceAdapterInternalException("Restriction: only one server can run in the VM");
                        }
                        if (this.collocated) {
                            if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                                JoramAdapter.logger.log(BasicLevel.INFO, (Object)" - Collocated JORAM server is starting...");
                            }
                            if (this.platformConfigDir != null) {
                                System.setProperty("fr.dyade.aaa.agent.A3CONF_DIR", this.platformConfigDir);
                                System.setProperty("fr.dyade.aaa.DEBUG_DIR", this.platformConfigDir);
                            }
                            try {
                                AgentServer.init((short)this.serverId, (String)this.storage, null);
                                AgentServer.start();
                                joramPort = AgentServer.getServiceArgs((short)AgentServer.getServerId(), (String)TcpProxyService.class.getName());
                                if (this.serverPort < 0 && joramPort != null && joramPort.length() > 0) {
                                    this.serverPort = new Integer(joramPort);
                                }
                                if (!JoramAdapter.logger.isLoggable(BasicLevel.INFO)) ** GOTO lbl47
                                JoramAdapter.logger.log(BasicLevel.INFO, (Object)"JoramAdapter - Collocated JORAM server has successfully started.");
                            }
                            catch (Exception exc) {
                                if (JoramAdapter.logger.isLoggable(BasicLevel.DEBUG)) {
                                    JoramAdapter.logger.log(BasicLevel.DEBUG, (Object)"EXCEPTION:: AgentServer", (Throwable)exc);
                                }
                                AgentServer.stop();
                                AgentServer.reset((boolean)true);
                                throw new ResourceAdapterInternalException("Could not start collocated JORAM instance: " + exc);
                            }
                        }
                    } else if (this.collocated) {
                        this.waitAgentServerStarted();
                        this.serverId = AgentServer.getServerId();
                        try {
                            this.hostName = AgentServer.getHostname((short)this.serverId);
                            joramPort = AgentServer.getServiceArgs((short)this.serverId, (String)TcpProxyService.class.getName());
                            if (this.serverPort < 0 && joramPort != null && joramPort.length() > 0) {
                                this.serverPort = new Integer(joramPort);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
lbl47:
                    // 7 sources

                    if (joramPort != null && JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                        JoramAdapter.logger.log(BasicLevel.INFO, (Object)("JoramAdapter - JORAM server listen on port " + joramPort));
                    }
                    try {
                        this.adminConnect();
                        this.serverId = (short)this.wrapper.getLocalServerId();
                    }
                    catch (Exception exc) {
                        if (!JoramAdapter.logger.isLoggable(BasicLevel.WARN)) break block36;
                        JoramAdapter.logger.log(BasicLevel.WARN, (Object)(" - JORAM server not administerable: " + exc));
                    }
                }
                if (this.adminFileXML != null) {
                    try {
                        if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                            JoramAdapter.logger.log(BasicLevel.INFO, (Object)("JoramAdapter - Reading the provided admin file: " + this.adminFileXML));
                        }
                        AdminModule.executeXMLAdmin((String)this.platformConfigDir, (String)this.adminFileXML);
                    }
                    catch (FileNotFoundException exc) {
                        if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                            JoramAdapter.logger.log(BasicLevel.INFO, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileXML + " file not found."));
                        }
                    }
                    catch (Exception exc) {
                        if (!JoramAdapter.logger.isLoggable(BasicLevel.ERROR)) break block37;
                        JoramAdapter.logger.log(BasicLevel.ERROR, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileXML), (Throwable)exc);
                    }
                }
            }
            if (this.adminFileExportXML != null) {
                try {
                    if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                        JoramAdapter.logger.log(BasicLevel.INFO, (Object)("JoramAdapter - Reading the provided admin file: " + this.adminFileExportXML));
                    }
                    AdminModule.executeXMLAdmin((String)this.platformConfigDir, (String)this.adminFileExportXML);
                }
                catch (FileNotFoundException exc) {
                    if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                        JoramAdapter.logger.log(BasicLevel.INFO, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileExportXML + " file not found."));
                    }
                }
                catch (Exception exc) {
                    if (!JoramAdapter.logger.isLoggable(BasicLevel.ERROR)) break block38;
                    JoramAdapter.logger.log(BasicLevel.ERROR, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileExportXML), (Throwable)exc);
                }
            }
        }
        if (this.collocated) {
            if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
                JoramAdapter.logger.log(BasicLevel.INFO, (Object)"Collocated server.");
            }
        } else if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
            JoramAdapter.logger.log(BasicLevel.INFO, (Object)("Server port is " + this.serverPort));
        }
        this.status.value = 2;
        if (JoramAdapter.logger.isLoggable(BasicLevel.INFO)) {
            JoramAdapter.logger.log(BasicLevel.INFO, (Object)("JORAM adapter " + ConnectionMetaData.providerVersion + " successfully deployed."));
        }
    }

    void adminConnect() throws AdminException {
        try {
            block15: {
                ConnectionFactory cf = this.collocated ? LocalConnectionFactory.create() : TcpConnectionFactory.create((String)this.hostName, (int)this.serverPort);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("adminConnect: cf = " + cf));
                }
                cf.getParameters().connectingTimer = this.connectingTimer == 0 ? 60 : this.connectingTimer;
                cf.setIdentityClassName(this.identityClass);
                cf.setCnxJMXBeanBaseName(jmxRootName + "#" + this.getName());
                Connection cnx = cf.createConnection(this.rootName, this.rootPasswd);
                cnx.start();
                this.wrapper = new JoramAdmin(cnx);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("adminConnect: wrapper = " + this.wrapper));
                }
                try {
                    if (Activator.context != null) {
                        Properties props = new Properties();
                        props.setProperty("name", this.getName());
                        props.setProperty("host", this.hostName);
                        props.setProperty("port", "" + this.serverPort);
                        props.setProperty("user", this.rootName);
                        this.registration = Activator.context.registerService(AdminItf.class.getName(), (Object)this.wrapper, (Dictionary)props);
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Bundle context " + Activator.context + " registerService AdminWrapper " + this.getName()));
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block15;
                    logger.log(BasicLevel.WARN, (Object)("adminConnect: register wrapper in context " + Activator.context), (Throwable)e);
                }
            }
            if (!this.isActive) {
                this.adminDurationState = System.currentTimeMillis();
            }
            this.isActive = true;
            try {
                MXWrapper.registerMBean((Object)this, (String)this.getMBeanName());
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"  - Could not register JoramAdapterMBean", (Throwable)e);
                }
            }
        }
        catch (ConnectException exc) {
            if (this.isActive) {
                this.adminDurationState = System.currentTimeMillis();
            }
            this.isActive = false;
            throw new AdminException("Admin connection can't be established: " + exc.getMessage());
        }
        catch (JMSException e) {
            if (this.isActive) {
                this.adminDurationState = System.currentTimeMillis();
            }
            this.isActive = false;
            throw new AdminException("Admin connection can't be established: " + e.getMessage());
        }
    }

    public String getMBeanName() {
        StringBuffer strbuf = new StringBuffer();
        if (Boolean.getBoolean("joram.ra.oldMBeanName")) {
            strbuf.append("joramClient");
        } else {
            strbuf.append(jmxRootName).append("#").append(this.getName());
        }
        strbuf.append(':');
        strbuf.append("type=JoramAdapter");
        return strbuf.toString();
    }

    void adminDisconnect() {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.wrapper.close();
        if (this.isActive) {
            this.adminDurationState = System.currentTimeMillis();
        }
        this.isActive = false;
    }

    public synchronized void stop() {
        block10: {
            block9: {
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)"JORAM adapter stopping...");
                }
                if (this.getStatus() != 2 || this.getStatus() == 4 || AgentServer.getStatus() != 4 || AgentServer.getStatus() != 3) {
                    this.status.value = 4;
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)"JORAM adapter successfully stopped.");
                    }
                    return;
                }
                super.stop();
                this.adminDisconnect();
                try {
                    MXWrapper.unregisterMBean((String)this.getMBeanName());
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block9;
                    logger.log(BasicLevel.DEBUG, (Object)("unregisterMBean: " + this.getMBeanName()), (Throwable)e);
                }
            }
            if (this.startJoramServer && this.collocated) {
                try {
                    AgentServer.stop();
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block10;
                    logger.log(BasicLevel.WARN, (Object)"Error during AgentServer stopping", (Throwable)exc);
                }
            }
        }
        this.status.value = 4;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM adapter successfully stopped.");
        }
    }

    public void reconnect() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"JoramAdapter: reconnect()");
        }
        boolean connected = false;
        if (this.getStatus() != 2 || this.getStatus() == 4 || this.getStatus() == 3) {
            return;
        }
        try {
            this.wrapper.getConfiguration();
            connected = true;
        }
        catch (Exception e1) {
            block12: {
                if (this.getStatus() == 3 || this.getStatus() == 4) {
                    return;
                }
                try {
                    this.adminDisconnect();
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block12;
                    logger.log(BasicLevel.DEBUG, (Object)("JoramAdapter: reconnect " + e));
                }
            }
            try {
                this.adminConnect();
            }
            catch (AdminException e) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("JoramAdapter: reconnect " + (Object)((Object)e)));
                }
                throw e;
            }
        }
        if (connected) {
            return;
        }
        super.reconnect();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("JoramAdapter: is reconnected = " + connected));
        }
    }

    public int hashCode() {
        return (this.collocated + " " + this.hostName + " " + this.serverPort).hashCode();
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof JoramAdapter)) {
            return false;
        }
        JoramAdapter other = (JoramAdapter)o;
        boolean bl = res = this.name == other.name && this.collocated == other.collocated && this.hostName.equals(other.hostName) && this.serverPort == other.serverPort;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " equals = " + res));
        }
        return res;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public long getAdminDurationBeforeChangeState() {
        return this.adminDurationState;
    }

    public String getAdminDurationBeforeChangeStateDate() {
        return new Date(this.adminDurationState).toString();
    }

    public long getTimeOutToAbortRequest() throws ConnectException {
        return this.wrapper.getTimeOutToAbortRequest();
    }

    public void setTimeOutToAbortRequest(long timeOut) throws ConnectException {
        this.wrapper.setTimeOutToAbortRequest(timeOut);
    }

    public String getDefaultDMQId() throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQId();
    }

    public String getDefaultDMQId(short serverId) throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQId((int)serverId);
    }

    public void resetDefaultDMQ(short serverId) throws ConnectException, AdminException {
        this.wrapper.setDefaultDMQ((int)serverId, null);
    }

    public int getDefaultThreshold() throws ConnectException, AdminException {
        return this.wrapper.getDefaultThreshold();
    }

    public int getDefaultThreshold(short serverId) throws ConnectException, AdminException {
        return this.wrapper.getDefaultThreshold((int)serverId);
    }

    public void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        this.wrapper.setDefaultThreshold(threshold);
    }

    public void setDefaultThreshold(short serverId, int threshold) throws ConnectException, AdminException {
        this.wrapper.setDefaultThreshold((int)serverId, threshold);
    }

    public String[] getDestinations() throws ConnectException, AdminException {
        return this.getDestinations((short)this.wrapper.getLocalServerId());
    }

    public String[] getDestinations(short serverId) throws ConnectException, AdminException {
        Destination[] destinations = this.wrapper.getDestinations((int)serverId);
        String[] names = new String[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            names[i] = destinations[i].registerMBean(this.wrapper.getJMXBaseName());
        }
        return names;
    }

    public String createQueue(String name) throws AdminException, ConnectException {
        return this.createQueue(this.serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public String createQueue(short serverId, String name) throws AdminException, ConnectException {
        return this.createQueue(serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public String createQueue(short serverId, String name, String className, Properties prop) throws AdminException, ConnectException {
        Queue queue = null;
        try {
            queue = (Queue)this.jndiHelper.lookup(name);
        }
        catch (NamingException exc) {
            String shortName = JoramAdapter.removePrefix(name);
            queue = (Queue)this.wrapper.createQueue((int)serverId, shortName, className, prop);
            queue.setFreeReading();
            queue.setFreeWriting();
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - Queue [" + shortName + "] has been created."));
            }
            this.bind(name, queue);
        }
        return Destination.getJMXBeanName((String)this.wrapper.getJMXBaseName(), (Destination)queue);
    }

    public String createTopic(String name) throws AdminException, ConnectException {
        return this.createTopic(this.serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public String createTopic(short serverId, String name) throws AdminException, ConnectException {
        return this.createTopic(serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public String createTopic(short serverId, String name, String className, Properties prop) throws AdminException, ConnectException {
        Topic topic = null;
        try {
            topic = (Topic)this.jndiHelper.lookup(name);
        }
        catch (NamingException exc) {
            String shortName = JoramAdapter.removePrefix(name);
            topic = (Topic)this.wrapper.createTopic((int)serverId, shortName, className, prop);
            topic.setFreeReading();
            topic.setFreeWriting();
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - Topic [" + shortName + "] has been created."));
            }
            this.bind(name, topic);
        }
        return Destination.getJMXBeanName((String)this.wrapper.getJMXBaseName(), (Destination)topic);
    }

    public void removeDestination(String name) throws AdminException {
        try {
            Destination dest;
            block4: {
                dest = (Destination)this.jndiHelper.lookup(name);
                dest.setWrapper((AdminItf)this.wrapper);
                try {
                    MXWrapper.unregisterMBean((String)Destination.getJMXBeanName((String)this.wrapper.getJMXBaseName(), (Destination)dest));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) break block4;
                    logger.log(BasicLevel.DEBUG, (Object)("unregisterMBean: " + name), (Throwable)e);
                }
            }
            dest.delete();
            this.unbind(name);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.WARN, (Object)("removeDestination failed: " + name), (Throwable)exc);
            throw new AdminException("removeDestination(" + name + ") failed.");
        }
    }

    public String[] getUsers() throws ConnectException, AdminException {
        return this.getUsers((short)this.wrapper.getLocalServerId());
    }

    public String[] getUsers(short serverId) throws ConnectException, AdminException {
        User[] users = this.wrapper.getUsers((int)serverId);
        String[] names = new String[users.length];
        for (int i = 0; i < users.length; ++i) {
            names[i] = users[i].registerMBean(this.wrapper.getJMXBaseName());
        }
        return names;
    }

    public String createUser(String name, String password) throws AdminException, ConnectException {
        return this.createUser(name, password, (short)this.wrapper.getLocalServerId(), SimpleIdentity.class.getName());
    }

    public String createUser(String name, String password, String identityClass) throws AdminException, ConnectException {
        return this.createUser(name, password, (short)this.wrapper.getLocalServerId(), identityClass);
    }

    public String createUser(String name, String password, short serverId) throws AdminException, ConnectException {
        return this.createUser(name, password, serverId, SimpleIdentity.class.getName());
    }

    public String createUser(String name, String password, short serverId, String identityClass) throws AdminException, ConnectException {
        User user = this.wrapper.createUser(name, password, (int)serverId, identityClass);
        return User.getJMXBeanName((String)this.wrapper.getJMXBaseName(), (User)user);
    }

    public void createCF(String name) {
        ManagedConnectionFactoryImpl mcf = new ManagedConnectionFactoryImpl();
        Properties props = new Properties();
        props.setProperty("name", name);
        props.setProperty("HostName", this.hostName);
        props.setProperty("ServerPort", "" + this.serverPort);
        props.setProperty("UserName", this.getRootName());
        props.setProperty("Password", this.getRootPasswd());
        props.setProperty("IdentityClass", this.getIdentityClass());
        mcf.setManagedConnectionFactoryConfig(props);
        this.createCF(name, mcf);
    }

    public void createQueueCF(String name) {
        ManagedConnectionFactoryImpl mcf = new ManagedConnectionFactoryImpl();
        Properties props = new Properties();
        props.setProperty("name", name);
        props.setProperty("HostName", this.hostName);
        props.setProperty("ServerPort", "" + this.serverPort);
        props.setProperty("UserName", "anonymous");
        props.setProperty("Password", "anonymous");
        props.setProperty("IdentityClass", "org.objectweb.joram.shared.security.SimpleIdentity");
        mcf.setManagedConnectionFactoryConfig(props);
        this.createQueueCF(name, mcf);
    }

    public void createTopicCF(String name) {
        ManagedConnectionFactoryImpl mcf = new ManagedConnectionFactoryImpl();
        Properties props = new Properties();
        props.setProperty("name", name);
        props.setProperty("HostName", this.hostName);
        props.setProperty("ServerPort", "" + this.serverPort);
        props.setProperty("UserName", "anonymous");
        props.setProperty("Password", "anonymous");
        props.setProperty("IdentityClass", "org.objectweb.joram.shared.security.SimpleIdentity");
        mcf.setManagedConnectionFactoryConfig(props);
        this.createTopicCF(name, mcf);
    }

    private static String removePrefix(String name) {
        String PREFIX_NAME = "scn:comp/";
        try {
            if (name.startsWith(PREFIX_NAME)) {
                return name.substring(PREFIX_NAME.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public void executeXMLAdmin(String path) throws Exception {
        AdminModule.executeXMLAdmin((String)path);
    }

    public void exportRepositoryToFile(String exportDir) throws AdminException {
        AdminModule.exportRepositoryToFile((String)exportDir, (String)this.adminFileExportXML);
    }

    public void exportRepositoryToFile(String exportDir, String exportFilename) throws AdminException {
        AdminModule.exportRepositoryToFile((String)exportDir, (String)exportFilename);
    }

    public Short[] getServersIds() throws ConnectException, AdminException {
        int[] sids = this.wrapper.getServersIds();
        Short[] serversIds = new Short[sids.length];
        for (int i = 0; i < sids.length; ++i) {
            serversIds[i] = new Short((short)sids[i]);
        }
        return serversIds;
    }

    public final String[] getServersNames() throws ConnectException, AdminException {
        return this.wrapper.getServersNames(null);
    }

    public final String getConfiguration() throws ConnectException, AdminException {
        return this.wrapper.getConfiguration();
    }

    public JoramAdmin getWrapper() {
        return this.wrapper;
    }

    public Boolean getCollocatedServer() {
        return new Boolean(this.collocated);
    }

    public String getServerName() {
        return this.name;
    }
}

