/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedQueueConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedTopicConnectionFactoryImpl;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ObjectFactoryImpl
implements ObjectFactory {
    public static Logger logger = Debug.getLogger((String)ObjectFactoryImpl.class.getName());
    String cf = "org.objectweb.joram.client.connector.OutboundConnectionFactory";
    String qcf = "org.objectweb.joram.client.connector.OutboundQueueConnectionFactory";
    String tcf = "org.objectweb.joram.client.connector.OutboundTopicConnectionFactory";

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getObjectInstance(" + obj + ", " + name + ", " + ctx + ", " + env + ")"));
        }
        Reference ref = (Reference)obj;
        String hostName = (String)ref.get("hostName").getContent();
        Integer serverPort = new Integer((String)ref.get("serverPort").getContent());
        String userName = (String)ref.get("userName").getContent();
        String password = (String)ref.get("password").getContent();
        String identityClass = (String)ref.get("identityClass").getContent();
        ManagedConnectionFactoryImpl mcf = null;
        if (ref.getClassName().equals(this.cf)) {
            mcf = new ManagedConnectionFactoryImpl();
        } else if (ref.getClassName().equals(this.qcf)) {
            mcf = new ManagedQueueConnectionFactoryImpl();
        } else if (ref.getClassName().equals(this.tcf)) {
            mcf = new ManagedTopicConnectionFactoryImpl();
        } else {
            return null;
        }
        mcf.setCollocated(new Boolean(false));
        mcf.setHostName(hostName);
        mcf.setServerPort(serverPort);
        mcf.setUserName(userName);
        mcf.setPassword(password);
        mcf.setIdentityClass(identityClass);
        try {
            return mcf.createConnectionFactory();
        }
        catch (Exception exc) {
            return null;
        }
    }
}

