/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.ejb.ScheduleExpression;
import org.ow2.easybeans.component.quartz.EasyBeansScheduleExpression;
import org.ow2.easybeans.component.quartz.EasyBeansTimer;
import org.ow2.easybeans.component.quartz.ScheduleExpressionParser;
import org.ow2.easybeans.component.quartz.ScheduleValue;
import org.ow2.easybeans.component.quartz.ScheduleValueAttribute;
import org.ow2.easybeans.component.quartz.ScheduleValueWildCard;
import org.ow2.easybeans.component.quartz.ValueResult;
import org.quartz.impl.triggers.CoreTrigger;
import org.quartz.impl.triggers.CronTriggerImpl;

public class EasyBeansScheduleTrigger
extends CronTriggerImpl
implements CoreTrigger {
    private static final long serialVersionUID = 5986420827628682444L;
    private ScheduleExpression scheduleExpression = null;
    private ScheduleExpressionParser parser = null;
    private EasyBeansScheduleExpression easyBeansScheduleExpression;
    private static final int MAX_LOOP = 200;
    private EasyBeansTimer easyBeansTimer = null;

    public EasyBeansScheduleTrigger(ScheduleExpression scheduleExpression) {
        this.scheduleExpression = scheduleExpression;
        this.parser = new ScheduleExpressionParser();
        this.init();
    }

    protected void init() {
        this.easyBeansScheduleExpression = this.parser.parse(this.scheduleExpression);
    }

    protected Date getTimeAfter(Date afterTime) {
        int loop = 0;
        GregorianCalendar afterTimeCalendar = new GregorianCalendar(this.getTimeZone());
        Calendar originalDate = null;
        if (this.scheduleExpression.getStart() != null) {
            afterTimeCalendar.setTime(this.getStartTime());
            originalDate = (Calendar)((Calendar)afterTimeCalendar).clone();
        } else {
            afterTimeCalendar.setTime(afterTime);
            originalDate = (Calendar)((Calendar)afterTimeCalendar).clone();
            ((Calendar)afterTimeCalendar).add(13, 1);
        }
        afterTimeCalendar.set(14, 0);
        afterTimeCalendar.setFirstDayOfWeek(1);
        boolean daysDone = false;
        boolean gotOne = false;
        while (!gotOne) {
            if (++loop > 200) {
                return null;
            }
            ScheduleValue dayOfMonthScheduleValue = this.easyBeansScheduleExpression.getDayOfMonth();
            ScheduleValue dayOfWeekScheduleValue = this.easyBeansScheduleExpression.getDayOfWeek();
            ValueResult valueResult = this.easyBeansScheduleExpression.getSecond().getTimeAfter(afterTimeCalendar);
            int previousSeconds = afterTimeCalendar.get(13);
            if (valueResult.needsIncrement()) {
                ((Calendar)afterTimeCalendar).add(12, 1);
            }
            if (previousSeconds != valueResult.getResult() || valueResult.needsIncrement()) {
                afterTimeCalendar.set(13, valueResult.getResult());
            }
            valueResult = this.easyBeansScheduleExpression.getMinute().getTimeAfter(afterTimeCalendar);
            int previousMinutes = afterTimeCalendar.get(12);
            if (valueResult.needsIncrement()) {
                ((Calendar)afterTimeCalendar).add(10, 1);
            }
            if (previousMinutes != valueResult.getResult() || valueResult.needsIncrement()) {
                afterTimeCalendar.set(12, valueResult.getResult());
                afterTimeCalendar.set(13, 0);
                continue;
            }
            valueResult = this.easyBeansScheduleExpression.getHour().getTimeAfter(afterTimeCalendar);
            int previousHours = afterTimeCalendar.get(11);
            if (valueResult.needsIncrement() && dayOfWeekScheduleValue instanceof ScheduleValueWildCard && dayOfMonthScheduleValue instanceof ScheduleValueWildCard) {
                ((Calendar)afterTimeCalendar).add(5, 1);
            }
            if (previousHours != valueResult.getResult() || valueResult.needsIncrement()) {
                afterTimeCalendar.set(11, valueResult.getResult());
                afterTimeCalendar.set(13, 0);
                afterTimeCalendar.set(12, 0);
                continue;
            }
            valueResult = this.easyBeansScheduleExpression.getMonth().getTimeAfter(afterTimeCalendar);
            int previousMonth = afterTimeCalendar.get(2);
            Date startTime = this.scheduleExpression.getStart();
            if (valueResult.needsIncrement()) {
                ((Calendar)afterTimeCalendar).add(1, 1);
            }
            if (previousMonth != valueResult.getResult() || valueResult.needsIncrement()) {
                afterTimeCalendar.set(2, valueResult.getResult());
                afterTimeCalendar.set(13, 0);
                afterTimeCalendar.set(12, 0);
                afterTimeCalendar.set(11, 0);
                afterTimeCalendar.set(5, 1);
                daysDone = false;
                continue;
            }
            valueResult = this.easyBeansScheduleExpression.getYear().getTimeAfter(afterTimeCalendar);
            int previousYear = afterTimeCalendar.get(1);
            if (valueResult.needsIncrement()) {
                ((Calendar)afterTimeCalendar).add(1, 1);
            }
            if (previousYear != valueResult.getResult() || valueResult.needsIncrement()) {
                afterTimeCalendar.set(1, valueResult.getResult());
                afterTimeCalendar.set(13, 0);
                afterTimeCalendar.set(12, 0);
                afterTimeCalendar.set(11, 0);
                afterTimeCalendar.set(2, 0);
                afterTimeCalendar.set(5, 1);
                daysDone = false;
                continue;
            }
            if (!daysDone) {
                if (!(dayOfMonthScheduleValue instanceof ScheduleValueWildCard) && dayOfWeekScheduleValue instanceof ScheduleValueWildCard) {
                    valueResult = dayOfMonthScheduleValue.getTimeAfter(afterTimeCalendar);
                    int previousDayOfMonth = afterTimeCalendar.get(5);
                    if (startTime != null && startTime.after(afterTimeCalendar.getTime())) {
                        valueResult.setNeedsIncrement(true);
                    }
                    if (valueResult.needsIncrement()) {
                        ((Calendar)afterTimeCalendar).add(2, 1);
                    }
                    if (previousDayOfMonth != valueResult.getResult() || valueResult.needsIncrement()) {
                        afterTimeCalendar.set(5, valueResult.getResult());
                        afterTimeCalendar.set(13, 0);
                        afterTimeCalendar.set(12, 0);
                        afterTimeCalendar.set(11, 0);
                    }
                } else if (dayOfMonthScheduleValue instanceof ScheduleValueWildCard && !(dayOfWeekScheduleValue instanceof ScheduleValueWildCard)) {
                    int wantedMonth;
                    valueResult = dayOfWeekScheduleValue.getTimeAfter(afterTimeCalendar);
                    int previousDayOfWeek = afterTimeCalendar.get(7);
                    if (valueResult.needsIncrement()) {
                        ((Calendar)afterTimeCalendar).add(8, 1);
                    }
                    GregorianCalendar now = new GregorianCalendar();
                    now.set(14, 0);
                    Date previousFireTime = this.getPreviousFireTime();
                    if (((Calendar)afterTimeCalendar).equals(now) && previousFireTime == null && ((Calendar)afterTimeCalendar).equals(originalDate)) {
                        int currentMonth;
                        ((Calendar)afterTimeCalendar).add(8, 1);
                        if (this.easyBeansScheduleExpression.getMonth() instanceof ScheduleValueAttribute && this.easyBeansScheduleExpression.getYear() instanceof ScheduleValueAttribute && (wantedMonth = Integer.parseInt(this.scheduleExpression.getMonth())) != (currentMonth = afterTimeCalendar.get(2) + 1)) {
                            ((Calendar)afterTimeCalendar).add(8, -1);
                            return afterTimeCalendar.getTime();
                        }
                        return afterTimeCalendar.getTime();
                    }
                    if (originalDate.after(afterTimeCalendar)) {
                        int currentMonth;
                        ((Calendar)afterTimeCalendar).add(8, 1);
                        if (this.easyBeansScheduleExpression.getMonth() instanceof ScheduleValueAttribute && this.easyBeansScheduleExpression.getYear() instanceof ScheduleValueAttribute && (wantedMonth = Integer.parseInt(this.scheduleExpression.getMonth())) != (currentMonth = afterTimeCalendar.get(2) + 1)) {
                            ((Calendar)afterTimeCalendar).add(8, -1);
                            return afterTimeCalendar.getTime();
                        }
                        return afterTimeCalendar.getTime();
                    }
                    if (previousDayOfWeek != valueResult.getResult() || valueResult.needsIncrement()) {
                        afterTimeCalendar.set(7, valueResult.getResult());
                        afterTimeCalendar.set(13, 0);
                        afterTimeCalendar.set(12, 0);
                        afterTimeCalendar.set(11, 0);
                    }
                } else if (!(dayOfMonthScheduleValue instanceof ScheduleValueWildCard) || !(dayOfWeekScheduleValue instanceof ScheduleValueWildCard)) {
                    ValueResult valueResultDayOfMonth = dayOfMonthScheduleValue.getTimeAfter(afterTimeCalendar);
                    ValueResult valueResultDayOfWeek = dayOfWeekScheduleValue.getTimeAfter(afterTimeCalendar);
                    int currentDayOfMonth = afterTimeCalendar.get(5);
                    int currentDayOfWeek = afterTimeCalendar.get(7);
                    if (currentDayOfMonth == valueResultDayOfMonth.getResult()) {
                        afterTimeCalendar.set(5, valueResultDayOfMonth.getResult());
                    } else if (currentDayOfWeek == valueResultDayOfWeek.getResult()) {
                        afterTimeCalendar.set(7, valueResultDayOfWeek.getResult());
                    } else {
                        throw new IllegalStateException("No expression matching the current day of week and day of month");
                    }
                }
                daysDone = true;
                continue;
            }
            gotOne = true;
        }
        return this.checkIfBeforeEnd(this.updateIfAlreadySent(afterTimeCalendar.getTime()));
    }

    protected Date checkIfBeforeEnd(Date fireTime) {
        if (fireTime == null) {
            return null;
        }
        Date end = this.scheduleExpression.getEnd();
        if (end == null) {
            return fireTime;
        }
        if (end.before(fireTime)) {
            this.easyBeansTimer.setInvalid();
            return null;
        }
        return fireTime;
    }

    protected Date updateIfAlreadySent(Date fireTime) {
        Date previousTime = this.getPreviousFireTime();
        if (previousTime != null && fireTime.equals(previousTime)) {
            return null;
        }
        return fireTime;
    }

    public Object clone() {
        EasyBeansScheduleTrigger copy = (EasyBeansScheduleTrigger)super.clone();
        if (this.easyBeansTimer != null) {
            copy.setEasyBeansTimer(this.easyBeansTimer);
        }
        return copy;
    }

    public EasyBeansTimer getEasyBeansTimer() {
        return this.easyBeansTimer;
    }

    public void setEasyBeansTimer(EasyBeansTimer easyBeansTimer) {
        this.easyBeansTimer = easyBeansTimer;
    }
}

