/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Properties;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.AbstractChannelFactory;
import org.jacorb.slf4j.Logger;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;

public class NotifyServer {
    private static Configuration configuration = null;
    private static Logger logger = null;
    private static String fileName = null;
    private static String fileNameTyped = null;
    private static Properties props = new Properties();

    public static void configure(Configuration configuration) {
        NotifyServer.configuration = configuration;
        logger = NotifyServer.configuration.getLogger("jacorb.notify");
        fileName = NotifyServer.configuration.getAttribute("jacorb.notify.ior_filename", "./notify.ior");
        fileNameTyped = NotifyServer.configuration.getAttribute("jacorb.notifyTyped.ior_filename", "./notify.ior");
    }

    public static AbstractChannelFactory newFactory(ORB oRB, POA pOA) throws Exception {
        props.put("jacorb.notification.enable_typed_channel", "off");
        props.put("jacorb.notification.ior_file", fileName);
        props.put("jacorb.notification.start_channels", "1");
        return AbstractChannelFactory.newFactory(oRB, null, props);
    }

    public static AbstractChannelFactory createInstance(ORB oRB, POA pOA) throws Exception {
        AbstractChannelFactory abstractChannelFactory = null;
        try {
            Configuration configuration = ((org.jacorb.orb.ORB)oRB).getConfiguration();
            NotifyServer.configure(configuration);
            abstractChannelFactory = NotifyServer.newFactory(oRB, pOA);
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return abstractChannelFactory;
    }
}

